/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.clientgui;

import com.beanit.openiec61850.DataSet;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.FcModelNode;
import com.beanit.openiec61850.LogicalDevice;
import com.beanit.openiec61850.LogicalNode;
import com.beanit.openiec61850.ModelNode;
import com.beanit.openiec61850.ServerModel;
import com.beanit.openiec61850.clientgui.DataObjectTreeNode;
import com.beanit.openiec61850.clientgui.DataSetTreeNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeNode;

public class ServerModelParser {
    private final ServerModel model;
    private DataObjectTreeNode modelTree;

    public ServerModelParser(ServerModel model) {
        this.model = model;
    }

    public TreeNode getModelTree() {
        if (this.modelTree == null) {
            this.createModelTree();
        }
        return this.modelTree;
    }

    private synchronized void createModelTree() {
        if (this.modelTree == null) {
            this.modelTree = new DataObjectTreeNode("server", null);
            for (ModelNode node : this.model.getChildren()) {
                if (!(node instanceof LogicalDevice)) {
                    System.out.println("Node " + node.getName() + " is " + node.getClass() + " (should be LogicalDevice)");
                    continue;
                }
                this.addLogicalDevice(this.modelTree, (LogicalDevice)node);
            }
            for (DataSet dataSet : this.model.getDataSets()) {
                this.addDataSet(this.modelTree, dataSet);
            }
        }
    }

    private void addLogicalDevice(DataObjectTreeNode root, LogicalDevice node) {
        DataObjectTreeNode treeLD = new DataObjectTreeNode(node.getName(), node);
        root.add(treeLD);
        for (ModelNode subNode : node.getChildren()) {
            if (!(subNode instanceof LogicalNode)) {
                System.out.println("Node " + subNode.getName() + " is " + subNode.getClass() + " (should be LogicalNode)");
                continue;
            }
            this.addLogicalNode(treeLD, (LogicalNode)subNode);
        }
    }

    private void addLogicalNode(DataObjectTreeNode parent, LogicalNode node) {
        DataObjectTreeNode treeLN = new DataObjectTreeNode(node.getName(), node);
        parent.add(treeLN);
        Collection<ModelNode> children = node.getChildren();
        HashMap childMap = new HashMap();
        for (ModelNode modelNode : children) {
            if (!childMap.containsKey(modelNode.getName())) {
                childMap.put(modelNode.getName(), new HashSet());
            }
            ((Set)childMap.get(modelNode.getName())).add(((FcModelNode)modelNode).getFc());
        }
        for (Map.Entry entry : childMap.entrySet()) {
            this.addFunctionalConstraintObject(treeLN, node, (String)entry.getKey(), (Set)entry.getValue());
        }
    }

    private void addDataSet(DataObjectTreeNode parent, DataSet node) {
        DataSetTreeNode treeDS = new DataSetTreeNode(node.getReferenceStr(), node);
        parent.add(treeDS);
        List<FcModelNode> children = node.getMembers();
        for (ModelNode modelNode : children) {
            this.addFunctionalConstraintObject(treeDS, node, modelNode);
        }
    }

    private void addFunctionalConstraintObject(DataObjectTreeNode parent, LogicalNode parentNode, String childName, Set<Fc> childFcs) {
        DataObjectTreeNode treeFCDO = new DataObjectTreeNode(childName, null);
        parent.add(treeFCDO);
        for (Fc constraint : childFcs) {
            ModelNode subNode = parentNode.getChild(childName, constraint);
            this.addDataObject(treeFCDO, "[" + (Object)((Object)constraint) + "]", subNode);
        }
    }

    private void addFunctionalConstraintObject(DataSetTreeNode parent, DataSet parentNode, ModelNode node) {
        DataObjectTreeNode treeFCDO = new DataObjectTreeNode(node.getReference().toString(), node);
        parent.add(treeFCDO);
        if (node.getChildren() != null) {
            for (ModelNode subNode : node.getChildren()) {
                this.addDataObject(treeFCDO, subNode.getName(), subNode);
            }
        }
    }

    private void addDataObject(DataObjectTreeNode parent, String name, ModelNode node) {
        DataObjectTreeNode treeDO = new DataObjectTreeNode(name, node);
        parent.add(treeDO);
        if (node.getChildren() != null) {
            for (ModelNode subNode : node.getChildren()) {
                this.addDataObject(treeDO, subNode.getName(), subNode);
            }
        }
    }
}

