/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.clientgui.databind;

import com.beanit.openiec61850.BdaInt16;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.clientgui.databind.TextFieldDataBind;

public class Int16DataBind
extends TextFieldDataBind<BdaInt16> {
    private static final Int16Filter FILTER = new Int16Filter();

    public Int16DataBind(BdaInt16 data) {
        super(data, BdaType.INT16, FILTER);
    }

    @Override
    protected void resetImpl() {
        this.inputField.setText(Short.toString(((BdaInt16)this.data).getValue()));
    }

    @Override
    protected void writeImpl() {
        ((BdaInt16)this.data).setValue(Short.parseShort(this.inputField.getText()));
    }

    private static class Int16Filter
    extends TextFieldDataBind.AbstractFilter {
        private Int16Filter() {
        }

        @Override
        protected boolean test(String text) {
            try {
                Short.parseShort(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

