/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.clientgui.databind;

import com.beanit.openiec61850.BdaInt32;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.clientgui.databind.TextFieldDataBind;

public class Int32DataBind
extends TextFieldDataBind<BdaInt32> {
    private static final Int32Filter FILTER = new Int32Filter();

    public Int32DataBind(BdaInt32 data) {
        super(data, BdaType.INT32, FILTER);
    }

    @Override
    protected void resetImpl() {
        this.inputField.setText(Integer.toString(((BdaInt32)this.data).getValue()));
    }

    @Override
    protected void writeImpl() {
        ((BdaInt32)this.data).setValue(Integer.parseInt(this.inputField.getText()));
    }

    private static class Int32Filter
    extends TextFieldDataBind.AbstractFilter {
        private Int32Filter() {
        }

        @Override
        protected boolean test(String text) {
            try {
                Integer.parseInt(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

