/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.clientgui.databind;

import com.beanit.openiec61850.BdaInt8;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.clientgui.databind.TextFieldDataBind;

public class Int8DataBind
extends TextFieldDataBind<BdaInt8> {
    private static final Int8Filter FILTER = new Int8Filter();

    public Int8DataBind(BdaInt8 data) {
        super(data, BdaType.INT8, FILTER);
    }

    @Override
    protected void resetImpl() {
        this.inputField.setText(Byte.toString(((BdaInt8)this.data).getValue()));
    }

    @Override
    protected void writeImpl() {
        ((BdaInt8)this.data).setValue(Byte.parseByte(this.inputField.getText()));
    }

    private static class Int8Filter
    extends TextFieldDataBind.AbstractFilter {
        private Int8Filter() {
        }

        @Override
        protected boolean test(String text) {
            try {
                Byte.parseByte(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

