/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.clientgui.databind;

import com.beanit.openiec61850.BdaInt8U;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.clientgui.databind.TextFieldDataBind;

public class Int8UDataBind
extends TextFieldDataBind<BdaInt8U> {
    private static final UInt8Filter FILTER = new UInt8Filter();

    public Int8UDataBind(BdaInt8U data) {
        super(data, BdaType.INT8U, FILTER);
    }

    @Override
    protected void resetImpl() {
        this.inputField.setText(Short.toString(((BdaInt8U)this.data).getValue()));
    }

    @Override
    protected void writeImpl() {
        ((BdaInt8U)this.data).setValue(Short.parseShort(this.inputField.getText()));
    }

    private static class UInt8Filter
    extends TextFieldDataBind.AbstractFilter {
        private UInt8Filter() {
        }

        @Override
        protected boolean test(String text) {
            try {
                short value = Short.parseShort(text);
                return value >= 0 && value <= 255;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

