/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.clientgui.databind;

import com.beanit.openiec61850.BasicDataAttribute;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.clientgui.BasicDataBind;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;

public abstract class TextFieldDataBind<E extends BasicDataAttribute>
extends BasicDataBind<E> {
    private final DocumentFilter filter;
    protected JTextField inputField;

    public TextFieldDataBind(E data, BdaType type, AbstractFilter filter) {
        super(data, type);
        this.filter = filter;
    }

    @Override
    protected JComponent init() {
        this.inputField = new JTextField();
        PlainDocument doc = (PlainDocument)this.inputField.getDocument();
        doc.setDocumentFilter(this.filter);
        this.resetImpl();
        return this.inputField;
    }

    protected static abstract class AbstractFilter
    extends DocumentFilter {
        protected AbstractFilter() {
        }

        @Override
        public final void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.insert(offset, string);
            if (this.test(sb.toString())) {
                super.insertString(fb, offset, string, attr);
            }
        }

        @Override
        public final void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.replace(offset, offset + length, text);
            if (this.test(sb.toString())) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        @Override
        public final void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.delete(offset, offset + length);
            if (this.test(sb.toString())) {
                super.remove(fb, offset, length);
            }
        }

        protected abstract boolean test(String var1);
    }
}

