/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.clientgui.databind;

import com.beanit.openiec61850.BdaTimestamp;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.clientgui.BasicDataBind;
import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;

public class TimeStampDataBind
extends BasicDataBind<BdaTimestamp> {
    private static final Dimension DATECHOOSERDIMENSION = new Dimension(120, 20);
    private JDateChooser dateChooser;
    private JSpinner timeSpinner;

    public TimeStampDataBind(BdaTimestamp data) {
        super(data, BdaType.TIMESTAMP);
    }

    @Override
    protected JComponent init() {
        this.dateChooser = new JDateChooser();
        this.dateChooser.setDateFormatString("dd-MM-yyyy");
        this.dateChooser.setPreferredSize(DATECHOOSERDIMENSION);
        this.timeSpinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor timeEditor = new JSpinner.DateEditor(this.timeSpinner, "HH:mm:ss");
        this.timeSpinner.setEditor(timeEditor);
        Date d = ((BdaTimestamp)this.data).getDate();
        if (d == null) {
            d = new Date(0L);
        }
        this.dateChooser.setDate(d);
        this.timeSpinner.setValue(d);
        JPanel dateTimePanel = new JPanel(new FlowLayout(0, 0, 0));
        dateTimePanel.add((Component)this.dateChooser);
        dateTimePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        dateTimePanel.add(this.timeSpinner);
        return dateTimePanel;
    }

    @Override
    protected void resetImpl() {
        Date d = ((BdaTimestamp)this.data).getDate();
        if (d == null) {
            d = new Date(0L);
        }
        this.dateChooser.setDate(d);
        this.timeSpinner.setValue(d);
    }

    @Override
    protected void writeImpl() {
        Date newDate = this.dateChooser.getDate();
        Date timeValues = (Date)this.timeSpinner.getValue();
        newDate.setHours(timeValues.getHours());
        newDate.setMinutes(timeValues.getMinutes());
        newDate.setSeconds(timeValues.getSeconds());
        ((BdaTimestamp)this.data).setDate(newDate);
    }
}

