/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.clientgui.databind;

import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.BdaUnicodeString;
import com.beanit.openiec61850.clientgui.databind.TextFieldDataBind;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class UnicodeStringDataBind
extends TextFieldDataBind<BdaUnicodeString> {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public UnicodeStringDataBind(BdaUnicodeString data) {
        super(data, BdaType.UNICODE_STRING, new Utf8Filter(data.getMaxLength()));
    }

    @Override
    protected void resetImpl() {
        this.inputField.setText(new String(((BdaUnicodeString)this.data).getValue(), UTF8));
    }

    @Override
    protected void writeImpl() {
        ((BdaUnicodeString)this.data).setValue(UTF8.encode(this.inputField.getText()).array());
    }

    private static class Utf8Filter
    extends TextFieldDataBind.AbstractFilter {
        private final CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
        private final int maxBytes;

        public Utf8Filter(int maxBytes) {
            this.maxBytes = maxBytes;
        }

        @Override
        protected boolean test(String text) {
            try {
                byte[] codedString = this.encoder.encode(CharBuffer.wrap(text)).array();
                return codedString.length <= this.maxBytes;
            }
            catch (CharacterCodingException e) {
                return false;
            }
        }
    }
}

