/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.openiec61850.internal.mms.asn1.ServiceError;
import com.beanit.openiec61850.internal.mms.asn1.Unsigned32;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ConfirmedErrorPDU
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private Unsigned32 invokeID = null;
    private Unsigned32 modifierPosition = null;
    private ServiceError serviceError = null;

    public ConfirmedErrorPDU() {
    }

    public ConfirmedErrorPDU(byte[] code) {
        this.code = code;
    }

    public Unsigned32 getInvokeID() {
        return this.invokeID;
    }

    public void setInvokeID(Unsigned32 invokeID) {
        this.invokeID = invokeID;
    }

    public Unsigned32 getModifierPosition() {
        return this.modifierPosition;
    }

    public void setModifierPosition(Unsigned32 modifierPosition) {
        this.modifierPosition = modifierPosition;
    }

    public ServiceError getServiceError() {
        return this.serviceError;
    }

    public void setServiceError(ServiceError serviceError) {
        this.serviceError = serviceError;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        codeLength += this.serviceError.encode(reverseOS, false);
        reverseOS.write(162);
        ++codeLength;
        if (this.modifierPosition != null) {
            codeLength += this.modifierPosition.encode(reverseOS, false);
            reverseOS.write(129);
            ++codeLength;
        }
        codeLength += this.invokeID.encode(reverseOS, false);
        reverseOS.write(128);
        ++codeLength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        codeLength += totalLength;
        subCodeLength += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.invokeID = new Unsigned32();
            subCodeLength += this.invokeID.decode(is, false);
            subCodeLength += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match the mandatory sequence element tag.");
        }
        if (berTag.equals(128, 0, 1)) {
            this.modifierPosition = new Unsigned32();
            subCodeLength += this.modifierPosition.decode(is, false);
            subCodeLength += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 2)) {
            this.serviceError = new ServiceError();
            if ((subCodeLength += this.serviceError.decode(is, false)) == totalLength) {
                return codeLength;
            }
        }
        throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.invokeID != null) {
            sb.append("invokeID: ").append((Object)this.invokeID);
        } else {
            sb.append("invokeID: <empty-required-field>");
        }
        if (this.modifierPosition != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("modifierPosition: ").append((Object)this.modifierPosition);
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.serviceError != null) {
            sb.append("serviceError: ");
            this.serviceError.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("serviceError: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

