/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.openiec61850.internal.mms.asn1.DefineNamedVariableListRequest;
import com.beanit.openiec61850.internal.mms.asn1.DeleteNamedVariableListRequest;
import com.beanit.openiec61850.internal.mms.asn1.FileCloseRequest;
import com.beanit.openiec61850.internal.mms.asn1.FileDeleteRequest;
import com.beanit.openiec61850.internal.mms.asn1.FileDirectoryRequest;
import com.beanit.openiec61850.internal.mms.asn1.FileOpenRequest;
import com.beanit.openiec61850.internal.mms.asn1.FileReadRequest;
import com.beanit.openiec61850.internal.mms.asn1.GetNameListRequest;
import com.beanit.openiec61850.internal.mms.asn1.GetNamedVariableListAttributesRequest;
import com.beanit.openiec61850.internal.mms.asn1.GetVariableAccessAttributesRequest;
import com.beanit.openiec61850.internal.mms.asn1.ReadRequest;
import com.beanit.openiec61850.internal.mms.asn1.WriteRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ConfirmedServiceRequest
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private GetNameListRequest getNameList = null;
    private ReadRequest read = null;
    private WriteRequest write = null;
    private GetVariableAccessAttributesRequest getVariableAccessAttributes = null;
    private DefineNamedVariableListRequest defineNamedVariableList = null;
    private GetNamedVariableListAttributesRequest getNamedVariableListAttributes = null;
    private DeleteNamedVariableListRequest deleteNamedVariableList = null;
    private FileOpenRequest fileOpen = null;
    private FileReadRequest fileRead = null;
    private FileCloseRequest fileClose = null;
    private FileDeleteRequest fileDelete = null;
    private FileDirectoryRequest fileDirectory = null;

    public ConfirmedServiceRequest() {
    }

    public ConfirmedServiceRequest(byte[] code) {
        this.code = code;
    }

    public GetNameListRequest getGetNameList() {
        return this.getNameList;
    }

    public void setGetNameList(GetNameListRequest getNameList) {
        this.getNameList = getNameList;
    }

    public ReadRequest getRead() {
        return this.read;
    }

    public void setRead(ReadRequest read) {
        this.read = read;
    }

    public WriteRequest getWrite() {
        return this.write;
    }

    public void setWrite(WriteRequest write) {
        this.write = write;
    }

    public GetVariableAccessAttributesRequest getGetVariableAccessAttributes() {
        return this.getVariableAccessAttributes;
    }

    public void setGetVariableAccessAttributes(GetVariableAccessAttributesRequest getVariableAccessAttributes) {
        this.getVariableAccessAttributes = getVariableAccessAttributes;
    }

    public DefineNamedVariableListRequest getDefineNamedVariableList() {
        return this.defineNamedVariableList;
    }

    public void setDefineNamedVariableList(DefineNamedVariableListRequest defineNamedVariableList) {
        this.defineNamedVariableList = defineNamedVariableList;
    }

    public GetNamedVariableListAttributesRequest getGetNamedVariableListAttributes() {
        return this.getNamedVariableListAttributes;
    }

    public void setGetNamedVariableListAttributes(GetNamedVariableListAttributesRequest getNamedVariableListAttributes) {
        this.getNamedVariableListAttributes = getNamedVariableListAttributes;
    }

    public DeleteNamedVariableListRequest getDeleteNamedVariableList() {
        return this.deleteNamedVariableList;
    }

    public void setDeleteNamedVariableList(DeleteNamedVariableListRequest deleteNamedVariableList) {
        this.deleteNamedVariableList = deleteNamedVariableList;
    }

    public FileOpenRequest getFileOpen() {
        return this.fileOpen;
    }

    public void setFileOpen(FileOpenRequest fileOpen) {
        this.fileOpen = fileOpen;
    }

    public FileReadRequest getFileRead() {
        return this.fileRead;
    }

    public void setFileRead(FileReadRequest fileRead) {
        this.fileRead = fileRead;
    }

    public FileCloseRequest getFileClose() {
        return this.fileClose;
    }

    public void setFileClose(FileCloseRequest fileClose) {
        this.fileClose = fileClose;
    }

    public FileDeleteRequest getFileDelete() {
        return this.fileDelete;
    }

    public void setFileDelete(FileDeleteRequest fileDelete) {
        this.fileDelete = fileDelete;
    }

    public FileDirectoryRequest getFileDirectory() {
        return this.fileDirectory;
    }

    public void setFileDirectory(FileDirectoryRequest fileDirectory) {
        this.fileDirectory = fileDirectory;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.fileDirectory != null) {
            codeLength += this.fileDirectory.encode(reverseOS, false);
            reverseOS.write(77);
            reverseOS.write(191);
            return codeLength += 2;
        }
        if (this.fileDelete != null) {
            codeLength += this.fileDelete.encode(reverseOS, false);
            reverseOS.write(76);
            reverseOS.write(191);
            return codeLength += 2;
        }
        if (this.fileClose != null) {
            codeLength += this.fileClose.encode(reverseOS, false);
            reverseOS.write(74);
            reverseOS.write(159);
            return codeLength += 2;
        }
        if (this.fileRead != null) {
            codeLength += this.fileRead.encode(reverseOS, false);
            reverseOS.write(73);
            reverseOS.write(159);
            return codeLength += 2;
        }
        if (this.fileOpen != null) {
            codeLength += this.fileOpen.encode(reverseOS, false);
            reverseOS.write(72);
            reverseOS.write(191);
            return codeLength += 2;
        }
        if (this.deleteNamedVariableList != null) {
            codeLength += this.deleteNamedVariableList.encode(reverseOS, false);
            reverseOS.write(173);
            return ++codeLength;
        }
        if (this.getNamedVariableListAttributes != null) {
            int sublength = this.getNamedVariableListAttributes.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(172);
            return ++codeLength;
        }
        if (this.defineNamedVariableList != null) {
            codeLength += this.defineNamedVariableList.encode(reverseOS, false);
            reverseOS.write(171);
            return ++codeLength;
        }
        if (this.getVariableAccessAttributes != null) {
            int sublength = this.getVariableAccessAttributes.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(166);
            return ++codeLength;
        }
        if (this.write != null) {
            codeLength += this.write.encode(reverseOS, false);
            reverseOS.write(165);
            return ++codeLength;
        }
        if (this.read != null) {
            codeLength += this.read.encode(reverseOS, false);
            reverseOS.write(164);
            return ++codeLength;
        }
        if (this.getNameList != null) {
            codeLength += this.getNameList.encode(reverseOS, false);
            reverseOS.write(161);
            return ++codeLength;
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        int codeLength = 0;
        BerTag passedTag = berTag;
        if (berTag == null) {
            berTag = new BerTag();
            codeLength += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 1)) {
            this.getNameList = new GetNameListRequest();
            return codeLength += this.getNameList.decode(is, false);
        }
        if (berTag.equals(128, 32, 4)) {
            this.read = new ReadRequest();
            return codeLength += this.read.decode(is, false);
        }
        if (berTag.equals(128, 32, 5)) {
            this.write = new WriteRequest();
            return codeLength += this.write.decode(is, false);
        }
        if (berTag.equals(128, 32, 6)) {
            codeLength += BerLength.skip((InputStream)is);
            this.getVariableAccessAttributes = new GetVariableAccessAttributesRequest();
            return codeLength += this.getVariableAccessAttributes.decode(is, null);
        }
        if (berTag.equals(128, 32, 11)) {
            this.defineNamedVariableList = new DefineNamedVariableListRequest();
            return codeLength += this.defineNamedVariableList.decode(is, false);
        }
        if (berTag.equals(128, 32, 12)) {
            codeLength += BerLength.skip((InputStream)is);
            this.getNamedVariableListAttributes = new GetNamedVariableListAttributesRequest();
            return codeLength += this.getNamedVariableListAttributes.decode(is, null);
        }
        if (berTag.equals(128, 32, 13)) {
            this.deleteNamedVariableList = new DeleteNamedVariableListRequest();
            return codeLength += this.deleteNamedVariableList.decode(is, false);
        }
        if (berTag.equals(128, 32, 72)) {
            this.fileOpen = new FileOpenRequest();
            return codeLength += this.fileOpen.decode(is, false);
        }
        if (berTag.equals(128, 0, 73)) {
            this.fileRead = new FileReadRequest();
            return codeLength += this.fileRead.decode(is, false);
        }
        if (berTag.equals(128, 0, 74)) {
            this.fileClose = new FileCloseRequest();
            return codeLength += this.fileClose.decode(is, false);
        }
        if (berTag.equals(128, 32, 76)) {
            this.fileDelete = new FileDeleteRequest();
            return codeLength += this.fileDelete.decode(is, false);
        }
        if (berTag.equals(128, 32, 77)) {
            this.fileDirectory = new FileDirectoryRequest();
            return codeLength += this.fileDirectory.decode(is, false);
        }
        if (passedTag != null) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.getNameList != null) {
            sb.append("getNameList: ");
            this.getNameList.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.read != null) {
            sb.append("read: ");
            this.read.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.write != null) {
            sb.append("write: ");
            this.write.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.getVariableAccessAttributes != null) {
            sb.append("getVariableAccessAttributes: ");
            this.getVariableAccessAttributes.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.defineNamedVariableList != null) {
            sb.append("defineNamedVariableList: ");
            this.defineNamedVariableList.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.getNamedVariableListAttributes != null) {
            sb.append("getNamedVariableListAttributes: ");
            this.getNamedVariableListAttributes.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.deleteNamedVariableList != null) {
            sb.append("deleteNamedVariableList: ");
            this.deleteNamedVariableList.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.fileOpen != null) {
            sb.append("fileOpen: ");
            this.fileOpen.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.fileRead != null) {
            sb.append("fileRead: ").append((Object)this.fileRead);
            return;
        }
        if (this.fileClose != null) {
            sb.append("fileClose: ").append((Object)this.fileClose);
            return;
        }
        if (this.fileDelete != null) {
            sb.append("fileDelete: ");
            this.fileDelete.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.fileDirectory != null) {
            sb.append("fileDirectory: ");
            this.fileDirectory.appendAsString(sb, indentLevel + 1);
            return;
        }
        sb.append("<none>");
    }
}

