/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.openiec61850.internal.mms.asn1.BasicIdentifier;
import com.beanit.openiec61850.internal.mms.asn1.ObjectName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeleteNamedVariableListRequest
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private BerInteger scopeOfDelete = null;
    private ListOfVariableListName listOfVariableListName = null;
    private DomainName domainName = null;

    public DeleteNamedVariableListRequest() {
    }

    public DeleteNamedVariableListRequest(byte[] code) {
        this.code = code;
    }

    public BerInteger getScopeOfDelete() {
        return this.scopeOfDelete;
    }

    public void setScopeOfDelete(BerInteger scopeOfDelete) {
        this.scopeOfDelete = scopeOfDelete;
    }

    public ListOfVariableListName getListOfVariableListName() {
        return this.listOfVariableListName;
    }

    public void setListOfVariableListName(ListOfVariableListName listOfVariableListName) {
        this.listOfVariableListName = listOfVariableListName;
    }

    public DomainName getDomainName() {
        return this.domainName;
    }

    public void setDomainName(DomainName domainName) {
        this.domainName = domainName;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.domainName != null) {
            int sublength = this.domainName.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(162);
            ++codeLength;
        }
        if (this.listOfVariableListName != null) {
            codeLength += this.listOfVariableListName.encode(reverseOS, false);
            reverseOS.write(161);
            ++codeLength;
        }
        if (this.scopeOfDelete != null) {
            codeLength += this.scopeOfDelete.encode(reverseOS, false);
            reverseOS.write(128);
            ++codeLength;
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        codeLength += totalLength;
        if (totalLength == 0) {
            return codeLength;
        }
        subCodeLength += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.scopeOfDelete = new BerInteger();
            if ((subCodeLength += this.scopeOfDelete.decode(is, false)) == totalLength) {
                return codeLength;
            }
            subCodeLength += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 1)) {
            this.listOfVariableListName = new ListOfVariableListName();
            if ((subCodeLength += this.listOfVariableListName.decode(is, false)) == totalLength) {
                return codeLength;
            }
            subCodeLength += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 2)) {
            subCodeLength += length.decode(is);
            this.domainName = new DomainName();
            if ((subCodeLength += this.domainName.decode(is, null)) == totalLength) {
                return codeLength;
            }
        }
        throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.scopeOfDelete != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("scopeOfDelete: ").append(this.scopeOfDelete);
            firstSelectedElement = false;
        }
        if (this.listOfVariableListName != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("listOfVariableListName: ");
            this.listOfVariableListName.appendAsString(sb, indentLevel + 1);
            firstSelectedElement = false;
        }
        if (this.domainName != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("domainName: ");
            this.domainName.appendAsString(sb, indentLevel + 1);
            firstSelectedElement = false;
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class DomainName
    implements BerType,
    Serializable {
        private static final long serialVersionUID = 1L;
        public byte[] code = null;
        private BasicIdentifier basic = null;

        public DomainName() {
        }

        public DomainName(byte[] code) {
            this.code = code;
        }

        public BasicIdentifier getBasic() {
            return this.basic;
        }

        public void setBasic(BasicIdentifier basic) {
            this.basic = basic;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            if (this.code != null) {
                for (int i = this.code.length - 1; i >= 0; --i) {
                    reverseOS.write(this.code[i]);
                }
                return this.code.length;
            }
            int codeLength = 0;
            if (this.basic != null) {
                return codeLength += this.basic.encode(reverseOS, true);
            }
            throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, null);
        }

        public int decode(InputStream is, BerTag berTag) throws IOException {
            int codeLength = 0;
            BerTag passedTag = berTag;
            if (berTag == null) {
                berTag = new BerTag();
                codeLength += berTag.decode(is);
            }
            if (berTag.equals((Object)BasicIdentifier.tag)) {
                this.basic = new BasicIdentifier();
                return codeLength += this.basic.decode(is, false);
            }
            if (passedTag != null) {
                return 0;
            }
            throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            if (this.basic != null) {
                sb.append("basic: ").append((Object)this.basic);
                return;
            }
            sb.append("<none>");
        }
    }

    public static class ListOfVariableListName
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        public byte[] code = null;
        private List<ObjectName> seqOf = null;

        public ListOfVariableListName() {
            this.seqOf = new ArrayList<ObjectName>();
        }

        public ListOfVariableListName(byte[] code) {
            this.code = code;
        }

        public List<ObjectName> getObjectName() {
            if (this.seqOf == null) {
                this.seqOf = new ArrayList<ObjectName>();
            }
            return this.seqOf;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                for (int i = this.code.length - 1; i >= 0; --i) {
                    reverseOS.write(this.code[i]);
                }
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            for (int i = this.seqOf.size() - 1; i >= 0; --i) {
                codeLength += this.seqOf.get(i).encode(reverseOS);
            }
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int codeLength = 0;
            int subCodeLength = 0;
            if (withTag) {
                codeLength += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            codeLength += length.decode(is);
            int totalLength = length.val;
            while (subCodeLength < totalLength) {
                ObjectName element = new ObjectName();
                subCodeLength += element.decode(is, null);
                this.seqOf.add(element);
            }
            if (subCodeLength != totalLength) {
                throw new IOException("Decoded SequenceOf or SetOf has wrong length. Expected " + totalLength + " but has " + subCodeLength);
            }
            return codeLength += subCodeLength;
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.seqOf == null) {
                sb.append("null");
            } else {
                Iterator<ObjectName> it = this.seqOf.iterator();
                if (it.hasNext()) {
                    it.next().appendAsString(sb, indentLevel + 1);
                    while (it.hasNext()) {
                        sb.append(",\n");
                        for (int i2 = 0; i2 < indentLevel + 1; ++i2) {
                            sb.append("\t");
                        }
                        it.next().appendAsString(sb, indentLevel + 1);
                    }
                }
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}

