/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.openiec61850.internal.mms.asn1.FileName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class FileDirectoryRequest
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private FileName fileSpecification = null;
    private FileName continueAfter = null;

    public FileDirectoryRequest() {
    }

    public FileDirectoryRequest(byte[] code) {
        this.code = code;
    }

    public FileName getFileSpecification() {
        return this.fileSpecification;
    }

    public void setFileSpecification(FileName fileSpecification) {
        this.fileSpecification = fileSpecification;
    }

    public FileName getContinueAfter() {
        return this.continueAfter;
    }

    public void setContinueAfter(FileName continueAfter) {
        this.continueAfter = continueAfter;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.continueAfter != null) {
            codeLength += this.continueAfter.encode(reverseOS, false);
            reverseOS.write(161);
            ++codeLength;
        }
        if (this.fileSpecification != null) {
            codeLength += this.fileSpecification.encode(reverseOS, false);
            reverseOS.write(160);
            ++codeLength;
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        codeLength += totalLength;
        if (totalLength == 0) {
            return codeLength;
        }
        subCodeLength += berTag.decode(is);
        if (berTag.equals(128, 32, 0)) {
            this.fileSpecification = new FileName();
            if ((subCodeLength += this.fileSpecification.decode(is, false)) == totalLength) {
                return codeLength;
            }
            subCodeLength += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 1)) {
            this.continueAfter = new FileName();
            if ((subCodeLength += this.continueAfter.decode(is, false)) == totalLength) {
                return codeLength;
            }
        }
        throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.fileSpecification != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("fileSpecification: ");
            this.fileSpecification.appendAsString(sb, indentLevel + 1);
            firstSelectedElement = false;
        }
        if (this.continueAfter != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("continueAfter: ");
            this.continueAfter.appendAsString(sb, indentLevel + 1);
            firstSelectedElement = false;
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

