/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.openiec61850.internal.mms.asn1.FileAttributes;
import com.beanit.openiec61850.internal.mms.asn1.Integer32;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class FileOpenResponse
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private Integer32 frsmID = null;
    private FileAttributes fileAttributes = null;

    public FileOpenResponse() {
    }

    public FileOpenResponse(byte[] code) {
        this.code = code;
    }

    public Integer32 getFrsmID() {
        return this.frsmID;
    }

    public void setFrsmID(Integer32 frsmID) {
        this.frsmID = frsmID;
    }

    public FileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    public void setFileAttributes(FileAttributes fileAttributes) {
        this.fileAttributes = fileAttributes;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        codeLength += this.fileAttributes.encode(reverseOS, false);
        reverseOS.write(161);
        ++codeLength;
        codeLength += this.frsmID.encode(reverseOS, false);
        reverseOS.write(128);
        ++codeLength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        codeLength += totalLength;
        subCodeLength += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.frsmID = new Integer32();
            subCodeLength += this.frsmID.decode(is, false);
            subCodeLength += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match the mandatory sequence element tag.");
        }
        if (berTag.equals(128, 32, 1)) {
            this.fileAttributes = new FileAttributes();
            if ((subCodeLength += this.fileAttributes.decode(is, false)) == totalLength) {
                return codeLength;
            }
        }
        throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.frsmID != null) {
            sb.append("frsmID: ").append((Object)this.frsmID);
        } else {
            sb.append("frsmID: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.fileAttributes != null) {
            sb.append("fileAttributes: ");
            this.fileAttributes.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("fileAttributes: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

