/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerNull;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.openiec61850.internal.mms.asn1.Identifier;
import com.beanit.openiec61850.internal.mms.asn1.ObjectClass;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class GetNameListRequest
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private ObjectClass objectClass = null;
    private ObjectScope objectScope = null;
    private Identifier continueAfter = null;

    public GetNameListRequest() {
    }

    public GetNameListRequest(byte[] code) {
        this.code = code;
    }

    public ObjectClass getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(ObjectClass objectClass) {
        this.objectClass = objectClass;
    }

    public ObjectScope getObjectScope() {
        return this.objectScope;
    }

    public void setObjectScope(ObjectScope objectScope) {
        this.objectScope = objectScope;
    }

    public Identifier getContinueAfter() {
        return this.continueAfter;
    }

    public void setContinueAfter(Identifier continueAfter) {
        this.continueAfter = continueAfter;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.continueAfter != null) {
            codeLength += this.continueAfter.encode(reverseOS, false);
            reverseOS.write(130);
            ++codeLength;
        }
        int sublength = this.objectScope.encode(reverseOS);
        codeLength += sublength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
        reverseOS.write(161);
        ++codeLength;
        sublength = this.objectClass.encode(reverseOS);
        codeLength += sublength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
        reverseOS.write(160);
        ++codeLength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        codeLength += totalLength;
        subCodeLength += berTag.decode(is);
        if (berTag.equals(128, 32, 0)) {
            subCodeLength += length.decode(is);
            this.objectClass = new ObjectClass();
            subCodeLength += this.objectClass.decode(is, null);
            subCodeLength += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match the mandatory sequence element tag.");
        }
        if (berTag.equals(128, 32, 1)) {
            subCodeLength += length.decode(is);
            this.objectScope = new ObjectScope();
            if ((subCodeLength += this.objectScope.decode(is, null)) == totalLength) {
                return codeLength;
            }
            subCodeLength += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match the mandatory sequence element tag.");
        }
        if (berTag.equals(128, 0, 2)) {
            this.continueAfter = new Identifier();
            if ((subCodeLength += this.continueAfter.decode(is, false)) == totalLength) {
                return codeLength;
            }
        }
        throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.objectClass != null) {
            sb.append("objectClass: ");
            this.objectClass.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("objectClass: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.objectScope != null) {
            sb.append("objectScope: ");
            this.objectScope.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("objectScope: <empty-required-field>");
        }
        if (this.continueAfter != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("continueAfter: ").append((Object)this.continueAfter);
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class ObjectScope
    implements BerType,
    Serializable {
        private static final long serialVersionUID = 1L;
        public byte[] code = null;
        private BerNull vmdSpecific = null;
        private Identifier domainSpecific = null;
        private BerNull aaSpecific = null;

        public ObjectScope() {
        }

        public ObjectScope(byte[] code) {
            this.code = code;
        }

        public BerNull getVmdSpecific() {
            return this.vmdSpecific;
        }

        public void setVmdSpecific(BerNull vmdSpecific) {
            this.vmdSpecific = vmdSpecific;
        }

        public Identifier getDomainSpecific() {
            return this.domainSpecific;
        }

        public void setDomainSpecific(Identifier domainSpecific) {
            this.domainSpecific = domainSpecific;
        }

        public BerNull getAaSpecific() {
            return this.aaSpecific;
        }

        public void setAaSpecific(BerNull aaSpecific) {
            this.aaSpecific = aaSpecific;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            if (this.code != null) {
                for (int i = this.code.length - 1; i >= 0; --i) {
                    reverseOS.write(this.code[i]);
                }
                return this.code.length;
            }
            int codeLength = 0;
            if (this.aaSpecific != null) {
                codeLength += this.aaSpecific.encode(reverseOS, false);
                reverseOS.write(130);
                return ++codeLength;
            }
            if (this.domainSpecific != null) {
                codeLength += this.domainSpecific.encode(reverseOS, false);
                reverseOS.write(129);
                return ++codeLength;
            }
            if (this.vmdSpecific != null) {
                codeLength += this.vmdSpecific.encode(reverseOS, false);
                reverseOS.write(128);
                return ++codeLength;
            }
            throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, null);
        }

        public int decode(InputStream is, BerTag berTag) throws IOException {
            int codeLength = 0;
            BerTag passedTag = berTag;
            if (berTag == null) {
                berTag = new BerTag();
                codeLength += berTag.decode(is);
            }
            if (berTag.equals(128, 0, 0)) {
                this.vmdSpecific = new BerNull();
                return codeLength += this.vmdSpecific.decode(is, false);
            }
            if (berTag.equals(128, 0, 1)) {
                this.domainSpecific = new Identifier();
                return codeLength += this.domainSpecific.decode(is, false);
            }
            if (berTag.equals(128, 0, 2)) {
                this.aaSpecific = new BerNull();
                return codeLength += this.aaSpecific.decode(is, false);
            }
            if (passedTag != null) {
                return 0;
            }
            throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            if (this.vmdSpecific != null) {
                sb.append("vmdSpecific: ").append(this.vmdSpecific);
                return;
            }
            if (this.domainSpecific != null) {
                sb.append("domainSpecific: ").append((Object)this.domainSpecific);
                return;
            }
            if (this.aaSpecific != null) {
                sb.append("aaSpecific: ").append(this.aaSpecific);
                return;
            }
            sb.append("<none>");
        }
    }
}

