/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.openiec61850.internal.mms.asn1.AccessResult;
import com.beanit.openiec61850.internal.mms.asn1.VariableAccessSpecification;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InformationReport
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private VariableAccessSpecification variableAccessSpecification = null;
    private ListOfAccessResult listOfAccessResult = null;

    public InformationReport() {
    }

    public InformationReport(byte[] code) {
        this.code = code;
    }

    public VariableAccessSpecification getVariableAccessSpecification() {
        return this.variableAccessSpecification;
    }

    public void setVariableAccessSpecification(VariableAccessSpecification variableAccessSpecification) {
        this.variableAccessSpecification = variableAccessSpecification;
    }

    public ListOfAccessResult getListOfAccessResult() {
        return this.listOfAccessResult;
    }

    public void setListOfAccessResult(ListOfAccessResult listOfAccessResult) {
        this.listOfAccessResult = listOfAccessResult;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        codeLength += this.listOfAccessResult.encode(reverseOS, false);
        reverseOS.write(160);
        ++codeLength;
        codeLength += this.variableAccessSpecification.encode(reverseOS);
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        codeLength += totalLength;
        subCodeLength += berTag.decode(is);
        this.variableAccessSpecification = new VariableAccessSpecification();
        subCodeLength += this.variableAccessSpecification.decode(is, berTag);
        subCodeLength += berTag.decode(is);
        if (berTag.equals(128, 32, 0)) {
            this.listOfAccessResult = new ListOfAccessResult();
            if ((subCodeLength += this.listOfAccessResult.decode(is, false)) == totalLength) {
                return codeLength;
            }
        }
        throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.variableAccessSpecification != null) {
            sb.append("variableAccessSpecification: ");
            this.variableAccessSpecification.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("variableAccessSpecification: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.listOfAccessResult != null) {
            sb.append("listOfAccessResult: ");
            this.listOfAccessResult.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("listOfAccessResult: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class ListOfAccessResult
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        public byte[] code = null;
        private List<AccessResult> seqOf = null;

        public ListOfAccessResult() {
            this.seqOf = new ArrayList<AccessResult>();
        }

        public ListOfAccessResult(byte[] code) {
            this.code = code;
        }

        public List<AccessResult> getAccessResult() {
            if (this.seqOf == null) {
                this.seqOf = new ArrayList<AccessResult>();
            }
            return this.seqOf;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                for (int i = this.code.length - 1; i >= 0; --i) {
                    reverseOS.write(this.code[i]);
                }
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            for (int i = this.seqOf.size() - 1; i >= 0; --i) {
                codeLength += this.seqOf.get(i).encode(reverseOS);
            }
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int codeLength = 0;
            int subCodeLength = 0;
            if (withTag) {
                codeLength += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            codeLength += length.decode(is);
            int totalLength = length.val;
            while (subCodeLength < totalLength) {
                AccessResult element = new AccessResult();
                subCodeLength += element.decode(is, null);
                this.seqOf.add(element);
            }
            if (subCodeLength != totalLength) {
                throw new IOException("Decoded SequenceOf or SetOf has wrong length. Expected " + totalLength + " but has " + subCodeLength);
            }
            return codeLength += subCodeLength;
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.seqOf == null) {
                sb.append("null");
            } else {
                Iterator<AccessResult> it = this.seqOf.iterator();
                if (it.hasNext()) {
                    it.next().appendAsString(sb, indentLevel + 1);
                    while (it.hasNext()) {
                        sb.append(",\n");
                        for (int i2 = 0; i2 < indentLevel + 1; ++i2) {
                            sb.append("\t");
                        }
                        it.next().appendAsString(sb, indentLevel + 1);
                    }
                }
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}

