/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.openiec61850.internal.mms.asn1.Integer16;
import com.beanit.openiec61850.internal.mms.asn1.Integer32;
import com.beanit.openiec61850.internal.mms.asn1.Integer8;
import com.beanit.openiec61850.internal.mms.asn1.ParameterSupportOptions;
import com.beanit.openiec61850.internal.mms.asn1.ServiceSupportOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class InitiateResponsePDU
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private Integer32 localDetailCalled = null;
    private Integer16 negotiatedMaxServOutstandingCalling = null;
    private Integer16 negotiatedMaxServOutstandingCalled = null;
    private Integer8 negotiatedDataStructureNestingLevel = null;
    private InitResponseDetail initResponseDetail = null;

    public InitiateResponsePDU() {
    }

    public InitiateResponsePDU(byte[] code) {
        this.code = code;
    }

    public Integer32 getLocalDetailCalled() {
        return this.localDetailCalled;
    }

    public void setLocalDetailCalled(Integer32 localDetailCalled) {
        this.localDetailCalled = localDetailCalled;
    }

    public Integer16 getNegotiatedMaxServOutstandingCalling() {
        return this.negotiatedMaxServOutstandingCalling;
    }

    public void setNegotiatedMaxServOutstandingCalling(Integer16 negotiatedMaxServOutstandingCalling) {
        this.negotiatedMaxServOutstandingCalling = negotiatedMaxServOutstandingCalling;
    }

    public Integer16 getNegotiatedMaxServOutstandingCalled() {
        return this.negotiatedMaxServOutstandingCalled;
    }

    public void setNegotiatedMaxServOutstandingCalled(Integer16 negotiatedMaxServOutstandingCalled) {
        this.negotiatedMaxServOutstandingCalled = negotiatedMaxServOutstandingCalled;
    }

    public Integer8 getNegotiatedDataStructureNestingLevel() {
        return this.negotiatedDataStructureNestingLevel;
    }

    public void setNegotiatedDataStructureNestingLevel(Integer8 negotiatedDataStructureNestingLevel) {
        this.negotiatedDataStructureNestingLevel = negotiatedDataStructureNestingLevel;
    }

    public InitResponseDetail getInitResponseDetail() {
        return this.initResponseDetail;
    }

    public void setInitResponseDetail(InitResponseDetail initResponseDetail) {
        this.initResponseDetail = initResponseDetail;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        codeLength += this.initResponseDetail.encode(reverseOS, false);
        reverseOS.write(164);
        ++codeLength;
        if (this.negotiatedDataStructureNestingLevel != null) {
            codeLength += this.negotiatedDataStructureNestingLevel.encode(reverseOS, false);
            reverseOS.write(131);
            ++codeLength;
        }
        codeLength += this.negotiatedMaxServOutstandingCalled.encode(reverseOS, false);
        reverseOS.write(130);
        ++codeLength;
        codeLength += this.negotiatedMaxServOutstandingCalling.encode(reverseOS, false);
        reverseOS.write(129);
        ++codeLength;
        if (this.localDetailCalled != null) {
            codeLength += this.localDetailCalled.encode(reverseOS, false);
            reverseOS.write(128);
            ++codeLength;
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        codeLength += totalLength;
        subCodeLength += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.localDetailCalled = new Integer32();
            subCodeLength += this.localDetailCalled.decode(is, false);
            subCodeLength += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 1)) {
            this.negotiatedMaxServOutstandingCalling = new Integer16();
            subCodeLength += this.negotiatedMaxServOutstandingCalling.decode(is, false);
            subCodeLength += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match the mandatory sequence element tag.");
        }
        if (berTag.equals(128, 0, 2)) {
            this.negotiatedMaxServOutstandingCalled = new Integer16();
            subCodeLength += this.negotiatedMaxServOutstandingCalled.decode(is, false);
            subCodeLength += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match the mandatory sequence element tag.");
        }
        if (berTag.equals(128, 0, 3)) {
            this.negotiatedDataStructureNestingLevel = new Integer8();
            subCodeLength += this.negotiatedDataStructureNestingLevel.decode(is, false);
            subCodeLength += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 4)) {
            this.initResponseDetail = new InitResponseDetail();
            if ((subCodeLength += this.initResponseDetail.decode(is, false)) == totalLength) {
                return codeLength;
            }
        }
        throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.localDetailCalled != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("localDetailCalled: ").append((Object)this.localDetailCalled);
            firstSelectedElement = false;
        }
        if (!firstSelectedElement) {
            sb.append(",\n");
        }
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.negotiatedMaxServOutstandingCalling != null) {
            sb.append("negotiatedMaxServOutstandingCalling: ").append((Object)this.negotiatedMaxServOutstandingCalling);
        } else {
            sb.append("negotiatedMaxServOutstandingCalling: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.negotiatedMaxServOutstandingCalled != null) {
            sb.append("negotiatedMaxServOutstandingCalled: ").append((Object)this.negotiatedMaxServOutstandingCalled);
        } else {
            sb.append("negotiatedMaxServOutstandingCalled: <empty-required-field>");
        }
        if (this.negotiatedDataStructureNestingLevel != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("negotiatedDataStructureNestingLevel: ").append((Object)this.negotiatedDataStructureNestingLevel);
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.initResponseDetail != null) {
            sb.append("initResponseDetail: ");
            this.initResponseDetail.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("initResponseDetail: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class InitResponseDetail
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        public byte[] code = null;
        private Integer16 negotiatedVersionNumber = null;
        private ParameterSupportOptions negotiatedParameterCBB = null;
        private ServiceSupportOptions servicesSupportedCalled = null;

        public InitResponseDetail() {
        }

        public InitResponseDetail(byte[] code) {
            this.code = code;
        }

        public Integer16 getNegotiatedVersionNumber() {
            return this.negotiatedVersionNumber;
        }

        public void setNegotiatedVersionNumber(Integer16 negotiatedVersionNumber) {
            this.negotiatedVersionNumber = negotiatedVersionNumber;
        }

        public ParameterSupportOptions getNegotiatedParameterCBB() {
            return this.negotiatedParameterCBB;
        }

        public void setNegotiatedParameterCBB(ParameterSupportOptions negotiatedParameterCBB) {
            this.negotiatedParameterCBB = negotiatedParameterCBB;
        }

        public ServiceSupportOptions getServicesSupportedCalled() {
            return this.servicesSupportedCalled;
        }

        public void setServicesSupportedCalled(ServiceSupportOptions servicesSupportedCalled) {
            this.servicesSupportedCalled = servicesSupportedCalled;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                for (int i = this.code.length - 1; i >= 0; --i) {
                    reverseOS.write(this.code[i]);
                }
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            codeLength += this.servicesSupportedCalled.encode(reverseOS, false);
            reverseOS.write(130);
            ++codeLength;
            codeLength += this.negotiatedParameterCBB.encode(reverseOS, false);
            reverseOS.write(129);
            ++codeLength;
            codeLength += this.negotiatedVersionNumber.encode(reverseOS, false);
            reverseOS.write(128);
            ++codeLength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int codeLength = 0;
            int subCodeLength = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                codeLength += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            codeLength += length.decode(is);
            int totalLength = length.val;
            codeLength += totalLength;
            subCodeLength += berTag.decode(is);
            if (berTag.equals(128, 0, 0)) {
                this.negotiatedVersionNumber = new Integer16();
                subCodeLength += this.negotiatedVersionNumber.decode(is, false);
                subCodeLength += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match the mandatory sequence element tag.");
            }
            if (berTag.equals(128, 0, 1)) {
                this.negotiatedParameterCBB = new ParameterSupportOptions();
                subCodeLength += this.negotiatedParameterCBB.decode(is, false);
                subCodeLength += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match the mandatory sequence element tag.");
            }
            if (berTag.equals(128, 0, 2)) {
                this.servicesSupportedCalled = new ServiceSupportOptions();
                if ((subCodeLength += this.servicesSupportedCalled.decode(is, false)) == totalLength) {
                    return codeLength;
                }
            }
            throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{");
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.negotiatedVersionNumber != null) {
                sb.append("negotiatedVersionNumber: ").append((Object)this.negotiatedVersionNumber);
            } else {
                sb.append("negotiatedVersionNumber: <empty-required-field>");
            }
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.negotiatedParameterCBB != null) {
                sb.append("negotiatedParameterCBB: ").append((Object)this.negotiatedParameterCBB);
            } else {
                sb.append("negotiatedParameterCBB: <empty-required-field>");
            }
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.servicesSupportedCalled != null) {
                sb.append("servicesSupportedCalled: ").append((Object)this.servicesSupportedCalled);
            } else {
                sb.append("servicesSupportedCalled: <empty-required-field>");
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}

