/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.jasn1.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ObjectClass
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private BerInteger basicObjectClass = null;

    public ObjectClass() {
    }

    public ObjectClass(byte[] code) {
        this.code = code;
    }

    public BerInteger getBasicObjectClass() {
        return this.basicObjectClass;
    }

    public void setBasicObjectClass(BerInteger basicObjectClass) {
        this.basicObjectClass = basicObjectClass;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.basicObjectClass != null) {
            codeLength += this.basicObjectClass.encode(reverseOS, false);
            reverseOS.write(128);
            return ++codeLength;
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        int codeLength = 0;
        BerTag passedTag = berTag;
        if (berTag == null) {
            berTag = new BerTag();
            codeLength += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 0)) {
            this.basicObjectClass = new BerInteger();
            return codeLength += this.basicObjectClass.decode(is, false);
        }
        if (passedTag != null) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.basicObjectClass != null) {
            sb.append("basicObjectClass: ").append(this.basicObjectClass);
            return;
        }
        sb.append("<none>");
    }
}

