/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.openiec61850.internal.BerBoolean;
import com.beanit.openiec61850.internal.mms.asn1.VariableAccessSpecification;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ReadRequest
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private BerBoolean specificationWithResult = null;
    private VariableAccessSpecification variableAccessSpecification = null;

    public ReadRequest() {
    }

    public ReadRequest(byte[] code) {
        this.code = code;
    }

    public BerBoolean getSpecificationWithResult() {
        return this.specificationWithResult;
    }

    public void setSpecificationWithResult(BerBoolean specificationWithResult) {
        this.specificationWithResult = specificationWithResult;
    }

    public VariableAccessSpecification getVariableAccessSpecification() {
        return this.variableAccessSpecification;
    }

    public void setVariableAccessSpecification(VariableAccessSpecification variableAccessSpecification) {
        this.variableAccessSpecification = variableAccessSpecification;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        int sublength = this.variableAccessSpecification.encode(reverseOS);
        codeLength += sublength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
        reverseOS.write(161);
        ++codeLength;
        if (this.specificationWithResult != null) {
            codeLength += this.specificationWithResult.encode(reverseOS, false);
            reverseOS.write(128);
            ++codeLength;
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        codeLength += totalLength;
        subCodeLength += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.specificationWithResult = new BerBoolean();
            subCodeLength += this.specificationWithResult.decode(is, false);
            subCodeLength += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 1)) {
            subCodeLength += length.decode(is);
            this.variableAccessSpecification = new VariableAccessSpecification();
            if ((subCodeLength += this.variableAccessSpecification.decode(is, null)) == totalLength) {
                return codeLength;
            }
        }
        throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.specificationWithResult != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("specificationWithResult: ").append(this.specificationWithResult);
            firstSelectedElement = false;
        }
        if (!firstSelectedElement) {
            sb.append(",\n");
        }
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.variableAccessSpecification != null) {
            sb.append("variableAccessSpecification: ");
            this.variableAccessSpecification.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("variableAccessSpecification: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

