/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.openiec61850.internal.mms.asn1.Unsigned32;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class RejectPDU
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private Unsigned32 originalInvokeID = null;
    private RejectReason rejectReason = null;

    public RejectPDU() {
    }

    public RejectPDU(byte[] code) {
        this.code = code;
    }

    public Unsigned32 getOriginalInvokeID() {
        return this.originalInvokeID;
    }

    public void setOriginalInvokeID(Unsigned32 originalInvokeID) {
        this.originalInvokeID = originalInvokeID;
    }

    public RejectReason getRejectReason() {
        return this.rejectReason;
    }

    public void setRejectReason(RejectReason rejectReason) {
        this.rejectReason = rejectReason;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        codeLength += this.rejectReason.encode(reverseOS);
        if (this.originalInvokeID != null) {
            codeLength += this.originalInvokeID.encode(reverseOS, false);
            reverseOS.write(128);
            ++codeLength;
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        codeLength += totalLength;
        subCodeLength += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.originalInvokeID = new Unsigned32();
            subCodeLength += this.originalInvokeID.decode(is, false);
            subCodeLength += berTag.decode(is);
        }
        this.rejectReason = new RejectReason();
        if ((subCodeLength += this.rejectReason.decode(is, berTag)) == totalLength) {
            return codeLength;
        }
        throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.originalInvokeID != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("originalInvokeID: ").append((Object)this.originalInvokeID);
            firstSelectedElement = false;
        }
        if (!firstSelectedElement) {
            sb.append(",\n");
        }
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.rejectReason != null) {
            sb.append("rejectReason: ");
            this.rejectReason.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("rejectReason: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class RejectReason
    implements BerType,
    Serializable {
        private static final long serialVersionUID = 1L;
        public byte[] code = null;
        private BerInteger confirmedRequestPDU = null;
        private BerInteger confirmedResponsePDU = null;
        private BerInteger confirmedErrorPDU = null;
        private BerInteger unconfirmedPDU = null;
        private BerInteger pduError = null;
        private BerInteger cancelRequestPDU = null;
        private BerInteger cancelResponsePDU = null;
        private BerInteger cancelErrorPDU = null;
        private BerInteger concludeRequestPDU = null;
        private BerInteger concludeResponsePDU = null;
        private BerInteger concludeErrorPDU = null;

        public RejectReason() {
        }

        public RejectReason(byte[] code) {
            this.code = code;
        }

        public BerInteger getConfirmedRequestPDU() {
            return this.confirmedRequestPDU;
        }

        public void setConfirmedRequestPDU(BerInteger confirmedRequestPDU) {
            this.confirmedRequestPDU = confirmedRequestPDU;
        }

        public BerInteger getConfirmedResponsePDU() {
            return this.confirmedResponsePDU;
        }

        public void setConfirmedResponsePDU(BerInteger confirmedResponsePDU) {
            this.confirmedResponsePDU = confirmedResponsePDU;
        }

        public BerInteger getConfirmedErrorPDU() {
            return this.confirmedErrorPDU;
        }

        public void setConfirmedErrorPDU(BerInteger confirmedErrorPDU) {
            this.confirmedErrorPDU = confirmedErrorPDU;
        }

        public BerInteger getUnconfirmedPDU() {
            return this.unconfirmedPDU;
        }

        public void setUnconfirmedPDU(BerInteger unconfirmedPDU) {
            this.unconfirmedPDU = unconfirmedPDU;
        }

        public BerInteger getPduError() {
            return this.pduError;
        }

        public void setPduError(BerInteger pduError) {
            this.pduError = pduError;
        }

        public BerInteger getCancelRequestPDU() {
            return this.cancelRequestPDU;
        }

        public void setCancelRequestPDU(BerInteger cancelRequestPDU) {
            this.cancelRequestPDU = cancelRequestPDU;
        }

        public BerInteger getCancelResponsePDU() {
            return this.cancelResponsePDU;
        }

        public void setCancelResponsePDU(BerInteger cancelResponsePDU) {
            this.cancelResponsePDU = cancelResponsePDU;
        }

        public BerInteger getCancelErrorPDU() {
            return this.cancelErrorPDU;
        }

        public void setCancelErrorPDU(BerInteger cancelErrorPDU) {
            this.cancelErrorPDU = cancelErrorPDU;
        }

        public BerInteger getConcludeRequestPDU() {
            return this.concludeRequestPDU;
        }

        public void setConcludeRequestPDU(BerInteger concludeRequestPDU) {
            this.concludeRequestPDU = concludeRequestPDU;
        }

        public BerInteger getConcludeResponsePDU() {
            return this.concludeResponsePDU;
        }

        public void setConcludeResponsePDU(BerInteger concludeResponsePDU) {
            this.concludeResponsePDU = concludeResponsePDU;
        }

        public BerInteger getConcludeErrorPDU() {
            return this.concludeErrorPDU;
        }

        public void setConcludeErrorPDU(BerInteger concludeErrorPDU) {
            this.concludeErrorPDU = concludeErrorPDU;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            if (this.code != null) {
                for (int i = this.code.length - 1; i >= 0; --i) {
                    reverseOS.write(this.code[i]);
                }
                return this.code.length;
            }
            int codeLength = 0;
            if (this.concludeErrorPDU != null) {
                codeLength += this.concludeErrorPDU.encode(reverseOS, false);
                reverseOS.write(139);
                return ++codeLength;
            }
            if (this.concludeResponsePDU != null) {
                codeLength += this.concludeResponsePDU.encode(reverseOS, false);
                reverseOS.write(138);
                return ++codeLength;
            }
            if (this.concludeRequestPDU != null) {
                codeLength += this.concludeRequestPDU.encode(reverseOS, false);
                reverseOS.write(137);
                return ++codeLength;
            }
            if (this.cancelErrorPDU != null) {
                codeLength += this.cancelErrorPDU.encode(reverseOS, false);
                reverseOS.write(136);
                return ++codeLength;
            }
            if (this.cancelResponsePDU != null) {
                codeLength += this.cancelResponsePDU.encode(reverseOS, false);
                reverseOS.write(135);
                return ++codeLength;
            }
            if (this.cancelRequestPDU != null) {
                codeLength += this.cancelRequestPDU.encode(reverseOS, false);
                reverseOS.write(134);
                return ++codeLength;
            }
            if (this.pduError != null) {
                codeLength += this.pduError.encode(reverseOS, false);
                reverseOS.write(133);
                return ++codeLength;
            }
            if (this.unconfirmedPDU != null) {
                codeLength += this.unconfirmedPDU.encode(reverseOS, false);
                reverseOS.write(132);
                return ++codeLength;
            }
            if (this.confirmedErrorPDU != null) {
                codeLength += this.confirmedErrorPDU.encode(reverseOS, false);
                reverseOS.write(131);
                return ++codeLength;
            }
            if (this.confirmedResponsePDU != null) {
                codeLength += this.confirmedResponsePDU.encode(reverseOS, false);
                reverseOS.write(130);
                return ++codeLength;
            }
            if (this.confirmedRequestPDU != null) {
                codeLength += this.confirmedRequestPDU.encode(reverseOS, false);
                reverseOS.write(129);
                return ++codeLength;
            }
            throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, null);
        }

        public int decode(InputStream is, BerTag berTag) throws IOException {
            int codeLength = 0;
            BerTag passedTag = berTag;
            if (berTag == null) {
                berTag = new BerTag();
                codeLength += berTag.decode(is);
            }
            if (berTag.equals(128, 0, 1)) {
                this.confirmedRequestPDU = new BerInteger();
                return codeLength += this.confirmedRequestPDU.decode(is, false);
            }
            if (berTag.equals(128, 0, 2)) {
                this.confirmedResponsePDU = new BerInteger();
                return codeLength += this.confirmedResponsePDU.decode(is, false);
            }
            if (berTag.equals(128, 0, 3)) {
                this.confirmedErrorPDU = new BerInteger();
                return codeLength += this.confirmedErrorPDU.decode(is, false);
            }
            if (berTag.equals(128, 0, 4)) {
                this.unconfirmedPDU = new BerInteger();
                return codeLength += this.unconfirmedPDU.decode(is, false);
            }
            if (berTag.equals(128, 0, 5)) {
                this.pduError = new BerInteger();
                return codeLength += this.pduError.decode(is, false);
            }
            if (berTag.equals(128, 0, 6)) {
                this.cancelRequestPDU = new BerInteger();
                return codeLength += this.cancelRequestPDU.decode(is, false);
            }
            if (berTag.equals(128, 0, 7)) {
                this.cancelResponsePDU = new BerInteger();
                return codeLength += this.cancelResponsePDU.decode(is, false);
            }
            if (berTag.equals(128, 0, 8)) {
                this.cancelErrorPDU = new BerInteger();
                return codeLength += this.cancelErrorPDU.decode(is, false);
            }
            if (berTag.equals(128, 0, 9)) {
                this.concludeRequestPDU = new BerInteger();
                return codeLength += this.concludeRequestPDU.decode(is, false);
            }
            if (berTag.equals(128, 0, 10)) {
                this.concludeResponsePDU = new BerInteger();
                return codeLength += this.concludeResponsePDU.decode(is, false);
            }
            if (berTag.equals(128, 0, 11)) {
                this.concludeErrorPDU = new BerInteger();
                return codeLength += this.concludeErrorPDU.decode(is, false);
            }
            if (passedTag != null) {
                return 0;
            }
            throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            if (this.confirmedRequestPDU != null) {
                sb.append("confirmedRequestPDU: ").append(this.confirmedRequestPDU);
                return;
            }
            if (this.confirmedResponsePDU != null) {
                sb.append("confirmedResponsePDU: ").append(this.confirmedResponsePDU);
                return;
            }
            if (this.confirmedErrorPDU != null) {
                sb.append("confirmedErrorPDU: ").append(this.confirmedErrorPDU);
                return;
            }
            if (this.unconfirmedPDU != null) {
                sb.append("unconfirmedPDU: ").append(this.unconfirmedPDU);
                return;
            }
            if (this.pduError != null) {
                sb.append("pduError: ").append(this.pduError);
                return;
            }
            if (this.cancelRequestPDU != null) {
                sb.append("cancelRequestPDU: ").append(this.cancelRequestPDU);
                return;
            }
            if (this.cancelResponsePDU != null) {
                sb.append("cancelResponsePDU: ").append(this.cancelResponsePDU);
                return;
            }
            if (this.cancelErrorPDU != null) {
                sb.append("cancelErrorPDU: ").append(this.cancelErrorPDU);
                return;
            }
            if (this.concludeRequestPDU != null) {
                sb.append("concludeRequestPDU: ").append(this.concludeRequestPDU);
                return;
            }
            if (this.concludeResponsePDU != null) {
                sb.append("concludeResponsePDU: ").append(this.concludeResponsePDU);
                return;
            }
            if (this.concludeErrorPDU != null) {
                sb.append("concludeErrorPDU: ").append(this.concludeErrorPDU);
                return;
            }
            sb.append("<none>");
        }
    }
}

