/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.jasn1.ber.types.string.BerVisibleString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ServiceError
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private ErrorClass errorClass = null;
    private BerInteger additionalCode = null;
    private BerVisibleString additionalDescription = null;

    public ServiceError() {
    }

    public ServiceError(byte[] code) {
        this.code = code;
    }

    public ErrorClass getErrorClass() {
        return this.errorClass;
    }

    public void setErrorClass(ErrorClass errorClass) {
        this.errorClass = errorClass;
    }

    public BerInteger getAdditionalCode() {
        return this.additionalCode;
    }

    public void setAdditionalCode(BerInteger additionalCode) {
        this.additionalCode = additionalCode;
    }

    public BerVisibleString getAdditionalDescription() {
        return this.additionalDescription;
    }

    public void setAdditionalDescription(BerVisibleString additionalDescription) {
        this.additionalDescription = additionalDescription;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.additionalDescription != null) {
            codeLength += this.additionalDescription.encode(reverseOS, false);
            reverseOS.write(130);
            ++codeLength;
        }
        if (this.additionalCode != null) {
            codeLength += this.additionalCode.encode(reverseOS, false);
            reverseOS.write(129);
            ++codeLength;
        }
        int sublength = this.errorClass.encode(reverseOS);
        codeLength += sublength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
        reverseOS.write(160);
        ++codeLength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        codeLength += totalLength;
        subCodeLength += berTag.decode(is);
        if (berTag.equals(128, 32, 0)) {
            subCodeLength += length.decode(is);
            this.errorClass = new ErrorClass();
            if ((subCodeLength += this.errorClass.decode(is, null)) == totalLength) {
                return codeLength;
            }
            subCodeLength += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match the mandatory sequence element tag.");
        }
        if (berTag.equals(128, 0, 1)) {
            this.additionalCode = new BerInteger();
            if ((subCodeLength += this.additionalCode.decode(is, false)) == totalLength) {
                return codeLength;
            }
            subCodeLength += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 2)) {
            this.additionalDescription = new BerVisibleString();
            if ((subCodeLength += this.additionalDescription.decode(is, false)) == totalLength) {
                return codeLength;
            }
        }
        throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.errorClass != null) {
            sb.append("errorClass: ");
            this.errorClass.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("errorClass: <empty-required-field>");
        }
        if (this.additionalCode != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("additionalCode: ").append(this.additionalCode);
        }
        if (this.additionalDescription != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("additionalDescription: ").append(this.additionalDescription);
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class ErrorClass
    implements BerType,
    Serializable {
        private static final long serialVersionUID = 1L;
        public byte[] code = null;
        private BerInteger vmdState = null;
        private BerInteger applicationReference = null;
        private BerInteger definition = null;
        private BerInteger resource = null;
        private BerInteger service = null;
        private BerInteger servicePreempt = null;
        private BerInteger timeResolution = null;
        private BerInteger access = null;
        private BerInteger initiate = null;
        private BerInteger conclude = null;
        private BerInteger cancel = null;
        private BerInteger file = null;
        private BerInteger others = null;

        public ErrorClass() {
        }

        public ErrorClass(byte[] code) {
            this.code = code;
        }

        public BerInteger getVmdState() {
            return this.vmdState;
        }

        public void setVmdState(BerInteger vmdState) {
            this.vmdState = vmdState;
        }

        public BerInteger getApplicationReference() {
            return this.applicationReference;
        }

        public void setApplicationReference(BerInteger applicationReference) {
            this.applicationReference = applicationReference;
        }

        public BerInteger getDefinition() {
            return this.definition;
        }

        public void setDefinition(BerInteger definition) {
            this.definition = definition;
        }

        public BerInteger getResource() {
            return this.resource;
        }

        public void setResource(BerInteger resource) {
            this.resource = resource;
        }

        public BerInteger getService() {
            return this.service;
        }

        public void setService(BerInteger service) {
            this.service = service;
        }

        public BerInteger getServicePreempt() {
            return this.servicePreempt;
        }

        public void setServicePreempt(BerInteger servicePreempt) {
            this.servicePreempt = servicePreempt;
        }

        public BerInteger getTimeResolution() {
            return this.timeResolution;
        }

        public void setTimeResolution(BerInteger timeResolution) {
            this.timeResolution = timeResolution;
        }

        public BerInteger getAccess() {
            return this.access;
        }

        public void setAccess(BerInteger access) {
            this.access = access;
        }

        public BerInteger getInitiate() {
            return this.initiate;
        }

        public void setInitiate(BerInteger initiate) {
            this.initiate = initiate;
        }

        public BerInteger getConclude() {
            return this.conclude;
        }

        public void setConclude(BerInteger conclude) {
            this.conclude = conclude;
        }

        public BerInteger getCancel() {
            return this.cancel;
        }

        public void setCancel(BerInteger cancel) {
            this.cancel = cancel;
        }

        public BerInteger getFile() {
            return this.file;
        }

        public void setFile(BerInteger file) {
            this.file = file;
        }

        public BerInteger getOthers() {
            return this.others;
        }

        public void setOthers(BerInteger others) {
            this.others = others;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            if (this.code != null) {
                for (int i = this.code.length - 1; i >= 0; --i) {
                    reverseOS.write(this.code[i]);
                }
                return this.code.length;
            }
            int codeLength = 0;
            if (this.others != null) {
                codeLength += this.others.encode(reverseOS, false);
                reverseOS.write(140);
                return ++codeLength;
            }
            if (this.file != null) {
                codeLength += this.file.encode(reverseOS, false);
                reverseOS.write(139);
                return ++codeLength;
            }
            if (this.cancel != null) {
                codeLength += this.cancel.encode(reverseOS, false);
                reverseOS.write(138);
                return ++codeLength;
            }
            if (this.conclude != null) {
                codeLength += this.conclude.encode(reverseOS, false);
                reverseOS.write(137);
                return ++codeLength;
            }
            if (this.initiate != null) {
                codeLength += this.initiate.encode(reverseOS, false);
                reverseOS.write(136);
                return ++codeLength;
            }
            if (this.access != null) {
                codeLength += this.access.encode(reverseOS, false);
                reverseOS.write(135);
                return ++codeLength;
            }
            if (this.timeResolution != null) {
                codeLength += this.timeResolution.encode(reverseOS, false);
                reverseOS.write(134);
                return ++codeLength;
            }
            if (this.servicePreempt != null) {
                codeLength += this.servicePreempt.encode(reverseOS, false);
                reverseOS.write(133);
                return ++codeLength;
            }
            if (this.service != null) {
                codeLength += this.service.encode(reverseOS, false);
                reverseOS.write(132);
                return ++codeLength;
            }
            if (this.resource != null) {
                codeLength += this.resource.encode(reverseOS, false);
                reverseOS.write(131);
                return ++codeLength;
            }
            if (this.definition != null) {
                codeLength += this.definition.encode(reverseOS, false);
                reverseOS.write(130);
                return ++codeLength;
            }
            if (this.applicationReference != null) {
                codeLength += this.applicationReference.encode(reverseOS, false);
                reverseOS.write(129);
                return ++codeLength;
            }
            if (this.vmdState != null) {
                codeLength += this.vmdState.encode(reverseOS, false);
                reverseOS.write(128);
                return ++codeLength;
            }
            throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, null);
        }

        public int decode(InputStream is, BerTag berTag) throws IOException {
            int codeLength = 0;
            BerTag passedTag = berTag;
            if (berTag == null) {
                berTag = new BerTag();
                codeLength += berTag.decode(is);
            }
            if (berTag.equals(128, 0, 0)) {
                this.vmdState = new BerInteger();
                return codeLength += this.vmdState.decode(is, false);
            }
            if (berTag.equals(128, 0, 1)) {
                this.applicationReference = new BerInteger();
                return codeLength += this.applicationReference.decode(is, false);
            }
            if (berTag.equals(128, 0, 2)) {
                this.definition = new BerInteger();
                return codeLength += this.definition.decode(is, false);
            }
            if (berTag.equals(128, 0, 3)) {
                this.resource = new BerInteger();
                return codeLength += this.resource.decode(is, false);
            }
            if (berTag.equals(128, 0, 4)) {
                this.service = new BerInteger();
                return codeLength += this.service.decode(is, false);
            }
            if (berTag.equals(128, 0, 5)) {
                this.servicePreempt = new BerInteger();
                return codeLength += this.servicePreempt.decode(is, false);
            }
            if (berTag.equals(128, 0, 6)) {
                this.timeResolution = new BerInteger();
                return codeLength += this.timeResolution.decode(is, false);
            }
            if (berTag.equals(128, 0, 7)) {
                this.access = new BerInteger();
                return codeLength += this.access.decode(is, false);
            }
            if (berTag.equals(128, 0, 8)) {
                this.initiate = new BerInteger();
                return codeLength += this.initiate.decode(is, false);
            }
            if (berTag.equals(128, 0, 9)) {
                this.conclude = new BerInteger();
                return codeLength += this.conclude.decode(is, false);
            }
            if (berTag.equals(128, 0, 10)) {
                this.cancel = new BerInteger();
                return codeLength += this.cancel.decode(is, false);
            }
            if (berTag.equals(128, 0, 11)) {
                this.file = new BerInteger();
                return codeLength += this.file.decode(is, false);
            }
            if (berTag.equals(128, 0, 12)) {
                this.others = new BerInteger();
                return codeLength += this.others.decode(is, false);
            }
            if (passedTag != null) {
                return 0;
            }
            throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            if (this.vmdState != null) {
                sb.append("vmdState: ").append(this.vmdState);
                return;
            }
            if (this.applicationReference != null) {
                sb.append("applicationReference: ").append(this.applicationReference);
                return;
            }
            if (this.definition != null) {
                sb.append("definition: ").append(this.definition);
                return;
            }
            if (this.resource != null) {
                sb.append("resource: ").append(this.resource);
                return;
            }
            if (this.service != null) {
                sb.append("service: ").append(this.service);
                return;
            }
            if (this.servicePreempt != null) {
                sb.append("servicePreempt: ").append(this.servicePreempt);
                return;
            }
            if (this.timeResolution != null) {
                sb.append("timeResolution: ").append(this.timeResolution);
                return;
            }
            if (this.access != null) {
                sb.append("access: ").append(this.access);
                return;
            }
            if (this.initiate != null) {
                sb.append("initiate: ").append(this.initiate);
                return;
            }
            if (this.conclude != null) {
                sb.append("conclude: ").append(this.conclude);
                return;
            }
            if (this.cancel != null) {
                sb.append("cancel: ").append(this.cancel);
                return;
            }
            if (this.file != null) {
                sb.append("file: ").append(this.file);
                return;
            }
            if (this.others != null) {
                sb.append("others: ").append(this.others);
                return;
            }
            sb.append("<none>");
        }
    }
}

