/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.openiec61850.internal.mms.asn1.TypeDescription;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class TypeSpecification
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private TypeDescription typeDescription = null;

    public TypeSpecification() {
    }

    public TypeSpecification(byte[] code) {
        this.code = code;
    }

    public TypeDescription getTypeDescription() {
        return this.typeDescription;
    }

    public void setTypeDescription(TypeDescription typeDescription) {
        this.typeDescription = typeDescription;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.typeDescription != null) {
            return codeLength += this.typeDescription.encode(reverseOS);
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        int codeLength = 0;
        BerTag passedTag = berTag;
        if (berTag == null) {
            berTag = new BerTag();
            codeLength += berTag.decode(is);
        }
        this.typeDescription = new TypeDescription();
        int choiceDecodeLength = this.typeDescription.decode(is, berTag);
        if (choiceDecodeLength != 0) {
            return codeLength + choiceDecodeLength;
        }
        this.typeDescription = null;
        if (passedTag != null) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.typeDescription != null) {
            sb.append("typeDescription: ");
            this.typeDescription.appendAsString(sb, indentLevel + 1);
            return;
        }
        sb.append("<none>");
    }
}

