/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.openiec61850.internal.mms.asn1.ObjectName;
import com.beanit.openiec61850.internal.mms.asn1.VariableDefs;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class VariableAccessSpecification
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private VariableDefs listOfVariable = null;
    private ObjectName variableListName = null;

    public VariableAccessSpecification() {
    }

    public VariableAccessSpecification(byte[] code) {
        this.code = code;
    }

    public VariableDefs getListOfVariable() {
        return this.listOfVariable;
    }

    public void setListOfVariable(VariableDefs listOfVariable) {
        this.listOfVariable = listOfVariable;
    }

    public ObjectName getVariableListName() {
        return this.variableListName;
    }

    public void setVariableListName(ObjectName variableListName) {
        this.variableListName = variableListName;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.variableListName != null) {
            int sublength = this.variableListName.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(161);
            return ++codeLength;
        }
        if (this.listOfVariable != null) {
            codeLength += this.listOfVariable.encode(reverseOS, false);
            reverseOS.write(160);
            return ++codeLength;
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        int codeLength = 0;
        BerTag passedTag = berTag;
        if (berTag == null) {
            berTag = new BerTag();
            codeLength += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 0)) {
            this.listOfVariable = new VariableDefs();
            return codeLength += this.listOfVariable.decode(is, false);
        }
        if (berTag.equals(128, 32, 1)) {
            codeLength += BerLength.skip((InputStream)is);
            this.variableListName = new ObjectName();
            return codeLength += this.variableListName.decode(is, null);
        }
        if (passedTag != null) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.listOfVariable != null) {
            sb.append("listOfVariable: ");
            this.listOfVariable.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.variableListName != null) {
            sb.append("variableListName: ");
            this.variableListName.appendAsString(sb, indentLevel + 1);
            return;
        }
        sb.append("<none>");
    }
}

