/*
 * Decompiled with CFR 0.152.
 */
package com.bedatadriven.spss;

import com.bedatadriven.spss.CaseBuffer;
import com.bedatadriven.spss.CaseReader;
import com.bedatadriven.spss.CompressedCaseReader;
import com.bedatadriven.spss.DocumentRecord;
import com.bedatadriven.spss.ExtendedRecordHeader;
import com.bedatadriven.spss.FileHeader;
import com.bedatadriven.spss.LongStringRecord;
import com.bedatadriven.spss.LongVariableNamesRecord;
import com.bedatadriven.spss.MissingValuesHeader;
import com.bedatadriven.spss.SpssInputStream;
import com.bedatadriven.spss.SpssVariable;
import com.bedatadriven.spss.ValueLabelsRecord;
import com.bedatadriven.spss.VersionHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpssDataFileReader {
    private SpssInputStream inputStream;
    private String encoding;
    int currentRowIndex;
    CaseBuffer currentCase;
    private FileHeader fileHeader;
    private VersionHeader versionInfo;
    private MissingValuesHeader missingValueHeader;
    private SpssVariable[] variableRecords;
    private List<SpssVariable> variables;
    private Map<String, SpssVariable> variableNames;
    private CaseReader caseReader;
    private long numCasesOverridden = -1L;

    public SpssDataFileReader(String path) throws IOException {
        this(new SpssInputStream(new FileInputStream(path)));
    }

    public SpssDataFileReader(File file) throws IOException {
        this(new SpssInputStream(new FileInputStream(file)));
    }

    public SpssDataFileReader(InputStream input) throws IOException {
        this(new SpssInputStream(input));
    }

    private SpssDataFileReader(SpssInputStream inStream) throws IOException {
        int recordType;
        this.inputStream = inStream;
        String fileType = new String(this.inputStream.readBytes(4));
        if (!"$FL2".equals(fileType)) {
            throw new IOException("Expected record type '$FL2', but got '" + fileType + "'. Not an SPSS file");
        }
        this.fileHeader = new FileHeader(this.inputStream);
        this.variableRecords = new SpssVariable[this.fileHeader.getCaseSize()];
        this.variables = new ArrayList<SpssVariable>();
        this.variableNames = new HashMap<String, SpssVariable>();
        ValueLabelsRecord currentValueLabels = null;
        int currentVariablePosition = 0;
        block16: do {
            recordType = this.inputStream.readInt();
            block0 : switch (recordType) {
                case 2: {
                    SpssVariable variable = new SpssVariable(this.inputStream, currentVariablePosition, this.variables.size());
                    if (variable.getTypeCode() != -1) {
                        this.addVariable(variable);
                    }
                    ++currentVariablePosition;
                    break;
                }
                case 3: {
                    currentValueLabels = new ValueLabelsRecord(this.inputStream);
                    break;
                }
                case 4: {
                    int variableCount = this.inputStream.readInt();
                    for (int i = 0; i < variableCount; ++i) {
                        int variablePosition = this.inputStream.readInt() - 1;
                        this.variableRecords[variablePosition].valueLabels = currentValueLabels.getLabels();
                    }
                    continue block16;
                }
                case 6: {
                    new DocumentRecord(this.inputStream);
                    break;
                }
                case 7: {
                    ExtendedRecordHeader header = new ExtendedRecordHeader(this.inputStream);
                    switch (header.getSubType()) {
                        case 3: {
                            this.versionInfo = new VersionHeader(this.inputStream);
                            break block0;
                        }
                        case 4: {
                            this.missingValueHeader = new MissingValuesHeader(this.inputStream);
                            break block0;
                        }
                        case 13: {
                            LongVariableNamesRecord names = new LongVariableNamesRecord(header, this.inputStream);
                            names.parseInto(this.variables, this.variableNames);
                            break block0;
                        }
                        case 20: {
                            this.encoding = new String(this.inputStream.readBytes(header.getTotalLength())).trim();
                            this.inputStream.setEncoding(this.encoding);
                            break block0;
                        }
                        case 14: {
                            LongStringRecord r = new LongStringRecord(header, inStream);
                            r.parseInto(this.variables, this.variableNames);
                            break block0;
                        }
                        case 16: {
                            this.inputStream.skipBytes(8);
                            this.numCasesOverridden = inStream.readLong();
                            break block0;
                        }
                    }
                    this.inputStream.skipBytes(header.getTotalLength());
                    break;
                }
                case 999: {
                    this.inputStream.skipBytes(4);
                    break;
                }
            }
        } while (recordType != 999);
        this.currentCase = new CaseBuffer(this.variables.size());
        this.caseReader = !this.isCompressed() ? new CaseReader(this.inputStream, this.variables, this.missingValueHeader, this.fileHeader.getNumCases(), this.currentCase) : new CompressedCaseReader(this.inputStream, this.variables, this.missingValueHeader, this.fileHeader.getNumCases(), this.currentCase);
    }

    private void addVariable(SpssVariable variable) {
        this.variables.add(variable);
        this.variableRecords[variable.getPositionInRecord()] = variable;
        this.variableNames.put(variable.getShortName(), variable);
    }

    public List<SpssVariable> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public long getNumCases() {
        if (this.numCasesOverridden > -1L) {
            return this.numCasesOverridden;
        }
        return this.fileHeader.getNumCases();
    }

    public MissingValuesHeader getMissingValuesHeader() {
        return this.missingValueHeader;
    }

    public boolean isCompressed() {
        return this.fileHeader.isCompressed();
    }

    public String getVariableName(int index) {
        return this.inputStream.stringFromBytes(this.variables.get((int)index).longName).trim();
    }

    public int getVariableIndex(String name) {
        for (SpssVariable variable : this.variables) {
            if (!variable.getVariableName().equals(name)) continue;
            return variable.getIndex();
        }
        return -1;
    }

    public int getWeightVariableIndex() {
        if (this.fileHeader.getWeightVariableRecordIndex() >= 0) {
            return this.variableRecords[this.fileHeader.getWeightVariableRecordIndex()].getIndex();
        }
        return -1;
    }

    public double getDoubleValue(String variableName) {
        return this.getDoubleValue(this.getVariableIndex(variableName));
    }

    public double getDoubleValue(int variableIndex) {
        return this.currentCase.getDoubleValue(variableIndex);
    }

    public String getStringValue(String variableName) {
        return this.getStringValue(this.getVariableIndex(variableName));
    }

    public String getStringValue(int variableIndex) {
        return this.currentCase.getStringValue(variableIndex);
    }

    public String getVeryLongStringValue(String variableName) {
        return this.getVeryLongStringValue(this.getVariableIndex(variableName));
    }

    public String getVeryLongStringValue(int variableIndex) {
        int len = this.variables.get((int)variableIndex).veryLongStringLength;
        if (len <= 0) {
            return null;
        }
        int segments = (len + 251) / 252;
        return this.currentCase.getLongStringValue(variableIndex, segments);
    }

    public boolean isVeryLongString(String variableName) {
        return this.isVeryLongString(this.getVariableIndex(variableName));
    }

    public boolean isVeryLongString(int variableIndex) {
        return this.variables.get(variableIndex).isVeryLongString();
    }

    public boolean isVeryLongStringSegment(String variableName) {
        return this.isVeryLongStringSegment(this.getVariableIndex(variableName));
    }

    public boolean isVeryLongStringSegment(int variableIndex) {
        return this.variables.get(variableIndex).isVeryLongStringSegment();
    }

    public boolean isSystemMissing(String variableName) {
        return this.isSystemMissing(this.getVariableIndex(variableName));
    }

    public boolean isSystemMissing(int variableIndex) {
        return this.currentCase.isSystemMissing(variableIndex);
    }

    public Map<Double, String> getValueLabels(String variableName) {
        return this.getValueLabels(this.getVariableIndex(variableName));
    }

    public Map<Double, String> getValueLabels(int variableIndex) {
        HashMap<Double, String> labels = new HashMap<Double, String>();
        if (this.variables.get((int)variableIndex).valueLabels != null) {
            for (Map.Entry<Double, byte[]> entry : this.variables.get((int)variableIndex).valueLabels.entrySet()) {
                labels.put(entry.getKey(), new String(entry.getValue()));
            }
        }
        return labels;
    }

    public boolean isValueMissing(int variableIndex, double value) {
        return this.variables.get(variableIndex).isMissing(value);
    }

    public boolean readNextCase() throws IOException {
        return this.caseReader.readNext();
    }
}

