/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.player.misc;

import android.graphics.SurfaceTexture;
import android.view.Surface;
import tv.danmaku.ijk.media.player.annotations.CalledByNative;
import tv.danmaku.ijk.media.player.pragma.DebugLog;

public class MediaCodecSurface {
    private Surface mSurface;
    private SurfaceTexture mSurfaceTexture = new SurfaceTexture(0);
    private boolean mReleased = false;
    private boolean mAttached = false;

    public MediaCodecSurface() {
        this.mSurface = new Surface(this.mSurfaceTexture);
        this.mSurfaceTexture.detachFromGLContext();
    }

    @CalledByNative
    public Surface getSurface() {
        if (this.mReleased) {
            return null;
        }
        return this.mSurface;
    }

    @CalledByNative
    public SurfaceTexture getSurfaceTexture() {
        if (this.mReleased) {
            return null;
        }
        return this.mSurfaceTexture;
    }

    @CalledByNative
    public void updateTexImage(float[] mtx) {
        if (this.mReleased || !this.mAttached) {
            return;
        }
        this.mSurfaceTexture.updateTexImage();
        this.mSurfaceTexture.getTransformMatrix(mtx);
    }

    @CalledByNative
    public void attachToGLContext(int texName, int width, int height) {
        if (this.mReleased || this.mAttached) {
            return;
        }
        this.mAttached = true;
        this.mSurfaceTexture.attachToGLContext(texName);
    }

    @CalledByNative
    public void detachFromGLContext() {
        if (this.mAttached) {
            this.mSurfaceTexture.detachFromGLContext();
            this.mAttached = false;
        }
    }

    @CalledByNative
    public void release() {
        DebugLog.d("MediaCodecSurface", "release()," + this.mReleased);
        this.mReleased = true;
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
    }
}

