/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.bean;

import com.belerweb.social.bean.Error;
import com.belerweb.social.exception.SocialException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result<T> {
    private Error error;
    private T result;
    private List<T> results;

    public Result(Error error) {
        this.error = error;
    }

    public Result(T result) {
        this.result = result;
    }

    public Result(List<T> results) {
        this.results = results;
    }

    public boolean success() {
        return this.error == null;
    }

    public Error getError() {
        return this.error;
    }

    public T getResult() {
        return this.result;
    }

    public List<T> getResults() {
        return this.results;
    }

    public static <T> Result<T> parse(String json, Class<T> resultType) {
        try {
            if (json.matches("^\\s*\\[.*$")) {
                return new Result<T>(Result.parse(new JSONArray(json), resultType));
            }
            return Result.parse(new JSONObject(json), resultType);
        }
        catch (Exception e) {
            throw new SocialException(e);
        }
    }

    public static <T> Result<T> parse(JSONObject jsonObject, Class<T> resultType) {
        try {
            Error error = Error.parse(jsonObject);
            if (error == null) {
                Method parse = resultType.getMethod("parse", JSONObject.class);
                Object obj = parse.invoke(null, jsonObject);
                return new Result<Object>(obj);
            }
            return new Result<T>(error);
        }
        catch (Exception e) {
            throw new SocialException(e);
        }
    }

    public static <T> List<T> parse(JSONArray jsonArray, Class<T> resultType) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (jsonArray == null) {
            return list;
        }
        try {
            for (int i = 0; i < jsonArray.length(); ++i) {
                if (resultType.isAssignableFrom(String.class)) {
                    list.add(Result.toString(jsonArray.get(i)));
                    continue;
                }
                if (resultType.isAssignableFrom(Integer.class)) {
                    list.add(Result.parseInteger(jsonArray.get(i)));
                    continue;
                }
                if (resultType.isAssignableFrom(Long.class)) {
                    list.add(Result.parseLong(jsonArray.get(i)));
                    continue;
                }
                if (resultType.isAssignableFrom(Double.class)) {
                    list.add(Result.parseDouble(jsonArray.get(i)));
                    continue;
                }
                Method parse = resultType.getMethod("parse", JSONObject.class);
                list.add(parse.invoke(null, jsonArray.getJSONObject(i)));
            }
            return list;
        }
        catch (Exception e) {
            throw new SocialException(e);
        }
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static Long parseLong(Object obj) {
        if (obj == null) {
            return null;
        }
        Long result = null;
        if (obj instanceof Number) {
            result = ((Number)obj).longValue();
        } else if (obj instanceof String) {
            result = Long.valueOf((String)obj);
        }
        return result;
    }

    public static Integer parseInteger(Object obj) {
        if (obj == null) {
            return null;
        }
        Integer result = null;
        if (obj instanceof Number) {
            result = ((Number)obj).intValue();
        } else if (obj instanceof String) {
            result = Integer.valueOf((String)obj);
        }
        return result;
    }

    public static Double parseDouble(Object obj) {
        if (obj == null) {
            return null;
        }
        Double result = null;
        if (obj instanceof Number) {
            result = ((Number)obj).doubleValue();
        } else if (obj instanceof String) {
            result = Double.valueOf((String)obj);
        }
        return result;
    }

    public static Boolean parseBoolean(Object obj) {
        if (obj == null) {
            return null;
        }
        Boolean result = null;
        if (obj instanceof Boolean) {
            result = (Boolean)obj;
        } else if (obj instanceof Integer) {
            result = (Integer)obj == 1;
        } else if (obj instanceof String) {
            result = Boolean.valueOf(obj.toString());
        }
        return result;
    }

    public static Date parseDate(Object obj, String pattern, Locale locale) {
        if (obj == null) {
            return null;
        }
        Date result = null;
        if (obj instanceof Date) {
            result = new Date(((Date)obj).getTime());
        } else if (obj instanceof String) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
                result = format.parse((String)obj);
            }
            catch (ParseException e) {
                throw new SocialException(e);
            }
        }
        return result;
    }

    public static Date parseTimeSeconds(Object obj) {
        Integer seconds = Result.parseInteger(obj);
        if (seconds == null || seconds == 0) {
            return null;
        }
        return new Date(seconds * 1000);
    }
}

