/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.qq.connect.api;

import com.belerweb.social.API;
import com.belerweb.social.bean.Error;
import com.belerweb.social.bean.Result;
import com.belerweb.social.exception.SocialException;
import com.belerweb.social.http.Http;
import com.belerweb.social.qq.connect.api.QQConnect;
import com.belerweb.social.qq.connect.bean.Album;
import com.belerweb.social.qq.connect.bean.AlbumPrivilege;
import com.belerweb.social.qq.connect.bean.Photo;
import com.belerweb.social.qq.connect.bean.PicUploadResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QZone
extends API {
    protected QZone(QQConnect connect) {
        super(connect);
    }

    public Result<Album> listAlbum(String accessToken, String openid) {
        return this.listAlbum(this.connect.getClientId(), accessToken, openid);
    }

    public Result<Album> listAlbum(String oAuthConsumerKey, String accessToken, String openid) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.connect.addParameter(params, "oauth_consumer_key", oAuthConsumerKey);
        this.connect.addParameter(params, "access_token", accessToken);
        this.connect.addParameter(params, "openid", openid);
        this.connect.addParameter(params, "format", "json");
        String json = this.connect.get("https://graph.qq.com/photo/list_album", params);
        JSONObject jsonObject = new JSONObject(json);
        Error error = Error.parse(jsonObject);
        if (error != null) {
            return new Result<Error>(error);
        }
        ArrayList<Album> results = new ArrayList<Album>();
        JSONArray jsonArray = jsonObject.getJSONArray("album");
        for (int i = 0; i < jsonArray.length(); ++i) {
            results.add(Album.parse(jsonArray.getJSONObject(i)));
        }
        return new Result<Album>(results);
    }

    public Result<Album> addAlbum(String accessToken, String openid, String albumName) {
        return this.addAlbum(this.connect.getClientId(), accessToken, openid, albumName, null, null, null, null);
    }

    public Result<Album> addAlbum(String oAuthConsumerKey, String accessToken, String openid, String albumName, String albumDesc, AlbumPrivilege privilege, String question, String answer) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.connect.addParameter(params, "oauth_consumer_key", oAuthConsumerKey);
        this.connect.addParameter(params, "access_token", accessToken);
        this.connect.addParameter(params, "openid", openid);
        this.connect.addParameter(params, "format", "json");
        this.connect.addParameter(params, "albumname", albumName);
        this.connect.addNotNullParameter(params, "albumdesc", albumDesc);
        this.connect.addNotNullParameter(params, "priv", (Object)privilege);
        if (privilege == AlbumPrivilege.QUESTION) {
            this.connect.addParameter(params, "question", question);
            this.connect.addParameter(params, "answer", answer);
        }
        String json = this.connect.post("https://graph.qq.com/photo/add_album", params);
        return Result.parse(json, Album.class);
    }

    public Result<PicUploadResult> uploadPic(String oAuthConsumerKey, String accessToken, String openid, String title, byte[] picture, String photoDesc, String albumId, Boolean mobile, Double lon, Double lat, Boolean needFeed, Integer successNum, Integer picNum) {
        HttpPost request = new HttpPost("https://graph.qq.com/photo/upload_pic");
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().addBinaryBody("picture", picture, ContentType.create((String)("image/" + title.substring(title.lastIndexOf(".") + 1))), title);
        builder.addTextBody("oauth_consumer_key", oAuthConsumerKey);
        builder.addTextBody("access_token", accessToken);
        builder.addTextBody("openid", openid);
        builder.addTextBody("format", "json");
        builder.addTextBody("title", title);
        if (photoDesc != null) {
            builder.addTextBody("photodesc", photoDesc);
        }
        if (albumId != null) {
            builder.addTextBody("albumid", albumId);
        }
        if (Boolean.TRUE.equals(mobile)) {
            builder.addTextBody("mobile", "1");
        }
        if (lon != null) {
            builder.addTextBody("x", lon.toString());
        }
        if (lat != null) {
            builder.addTextBody("y", lat.toString());
        }
        if (Boolean.FALSE.equals(needFeed)) {
            builder.addTextBody("needfeed", "0");
        }
        if (successNum != null) {
            builder.addTextBody("successnum", successNum.toString());
        }
        if (picNum != null) {
            builder.addTextBody("picnum", picNum.toString());
        }
        request.setEntity(builder.build());
        try {
            HttpResponse response = Http.CLIENT.execute((HttpUriRequest)request);
            String json = IOUtils.toString((InputStream)response.getEntity().getContent());
            Result<PicUploadResult> result = Result.parse(json, PicUploadResult.class);
            return result;
        }
        catch (ClientProtocolException e) {
            throw new SocialException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SocialException(e);
        }
        finally {
            request.releaseConnection();
        }
    }

    public Result<Photo> listPhoto(String accessToken, String openid, String albumId) {
        return this.listPhoto(this.connect.getClientId(), accessToken, openid, albumId);
    }

    public Result<Photo> listPhoto(String oAuthConsumerKey, String accessToken, String openid, String albumId) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.connect.addParameter(params, "oauth_consumer_key", oAuthConsumerKey);
        this.connect.addParameter(params, "access_token", accessToken);
        this.connect.addParameter(params, "openid", openid);
        this.connect.addParameter(params, "format", "json");
        this.connect.addParameter(params, "albumid", albumId);
        String json = this.connect.get("https://graph.qq.com/photo/list_photo", params);
        JSONObject jsonObject = new JSONObject(json);
        Error error = Error.parse(jsonObject);
        if (error != null) {
            return new Result<Error>(error);
        }
        ArrayList<Photo> results = new ArrayList<Photo>();
        JSONArray jsonArray = jsonObject.getJSONArray("photos");
        for (int i = 0; i < jsonArray.length(); ++i) {
            results.add(Photo.parse(jsonArray.getJSONObject(i)));
        }
        return new Result<Photo>(results);
    }
}

