/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.weibo.api;

import com.belerweb.social.API;
import com.belerweb.social.bean.Error;
import com.belerweb.social.bean.Result;
import com.belerweb.social.exception.SocialException;
import com.belerweb.social.weibo.api.Weibo;
import com.belerweb.social.weibo.bean.AccessToken;
import com.belerweb.social.weibo.bean.Display;
import com.belerweb.social.weibo.bean.Scope;
import com.belerweb.social.weibo.bean.TokenInfo;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OAuth2
extends API {
    OAuth2(Weibo weibo) {
        super(weibo);
    }

    public String authorize() {
        return this.authorize(this.weibo.getRedirectUri());
    }

    public String authorize(String redirectUri) {
        return this.authorize(this.weibo.getClientId(), redirectUri, new Scope[]{Scope.ALL}, null, null, null, null);
    }

    public String authorize(String clientId, String redirectUri, Scope[] scope, String state, Display display, Boolean forceLogin, String language) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.weibo.addParameter(params, "client_id", clientId);
        this.weibo.addParameter(params, "redirect_uri", redirectUri);
        if (scope != null) {
            this.weibo.addParameter(params, "scope", StringUtils.join((Object[])scope, (String)","));
        }
        this.weibo.addNotNullParameter(params, "state", state);
        this.weibo.addNotNullParameter(params, "display", (Object)display);
        this.weibo.addTrueParameter(params, "forcelogin", forceLogin);
        this.weibo.addNotNullParameter(params, "language", language);
        return "https://api.weibo.com/oauth2/authorize?" + StringUtils.join(params, (String)"&");
    }

    public Result<AccessToken> accessToken(String code) {
        return this.accessToken(code, this.weibo.getRedirectUri());
    }

    public Result<AccessToken> accessToken(String code, String redirectUri) {
        return this.accessToken(this.weibo.getClientId(), this.weibo.getClientSecret(), "authorization_code", code, redirectUri);
    }

    public Result<AccessToken> accessToken(String clientId, String clientSecret, String grantType, String code, String redirectUri) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.weibo.addParameter(params, "client_id", clientId);
        this.weibo.addParameter(params, "client_secret", clientSecret);
        this.weibo.addParameter(params, "grant_type", grantType);
        if ("authorization_code".equals(grantType)) {
            this.weibo.addParameter(params, "code", code);
            this.weibo.addParameter(params, "redirect_uri", redirectUri);
        }
        String result = this.weibo.post("https://api.weibo.com/oauth2/access_token", params);
        return Result.parse(result, AccessToken.class);
    }

    public Result<TokenInfo> getTokenInfo(String accessToken) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.weibo.addParameter(params, "access_token", accessToken);
        String result = this.weibo.post("https://api.weibo.com/oauth2/get_token_info", params);
        return Result.parse(result, TokenInfo.class);
    }

    public void getOAuth2Token(String oauthConsumerKey, String oauthToken, String oauthSignatureMethod, Long oauthTimestamp, String oauthNonce, String oauthVersion, String oauthSignature) {
        throw new SocialException("\u65b9\u6cd5\u8fd8\u672a\u5b9e\u73b0...");
    }

    public Result<Boolean> revokeOAuth2(String accessToken) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.weibo.addParameter(params, "access_token", accessToken);
        String json = this.weibo.post("https://api.weibo.com/oauth2/revokeoauth2", params);
        JSONObject jsonObject = new JSONObject(json);
        Error error = Error.parse(jsonObject);
        if (error == null) {
            return new Result<Boolean>(Result.parseBoolean(jsonObject.get("result")));
        }
        return new Result<Error>(error);
    }
}

