/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.weixin.api;

import com.belerweb.social.API;
import com.belerweb.social.bean.Error;
import com.belerweb.social.bean.Result;
import com.belerweb.social.exception.SocialException;
import com.belerweb.social.weixin.api.Weixin;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.StringEntity;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends API {
    protected Group(Weixin weixin) {
        super(weixin);
    }

    public Result<List<com.belerweb.social.weixin.bean.Group>> get() {
        return this.get(this.weixin.getAccessToken().getToken());
    }

    public Result<List<com.belerweb.social.weixin.bean.Group>> get(String accessToken) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.weixin.addParameter(params, "access_token", accessToken);
        String json = this.weixin.get("https://api.weixin.qq.com/cgi-bin/groups/get", params);
        JSONObject jsonObject = new JSONObject(json);
        Error error = Error.parse(jsonObject);
        if (error == null) {
            List<com.belerweb.social.weixin.bean.Group> groups = Result.parse(jsonObject.getJSONArray("groups"), com.belerweb.social.weixin.bean.Group.class);
            return new Result<List<com.belerweb.social.weixin.bean.Group>>(groups);
        }
        return new Result<Error>(error);
    }

    public Result<com.belerweb.social.weixin.bean.Group> create(String name) {
        return this.create(this.weixin.getAccessToken().getToken(), name);
    }

    public Result<com.belerweb.social.weixin.bean.Group> create(String accessToken, String name) {
        JSONObject request = new JSONObject();
        JSONObject group = new JSONObject();
        group.put("name", (Object)name);
        request.put("group", (Object)group);
        try {
            String json = this.weixin.post("https://api.weixin.qq.com/cgi-bin/groups/create?access_token=" + accessToken, (HttpEntity)new StringEntity(request.toString()));
            JSONObject jsonObject = new JSONObject(json);
            Error error = Error.parse(jsonObject);
            if (error != null) {
                return new Result<Error>(error);
            }
            return new Result<com.belerweb.social.weixin.bean.Group>(com.belerweb.social.weixin.bean.Group.parse(jsonObject.getJSONObject("group")));
        }
        catch (UnsupportedEncodingException e) {
            throw new SocialException(e);
        }
    }

    public Result<Error> update(String id, String name) {
        return this.update(this.weixin.getAccessToken().getToken(), id, name);
    }

    public Result<Error> update(String accessToken, String id, String name) {
        JSONObject request = new JSONObject();
        JSONObject group = new JSONObject();
        group.put("id", (Object)id);
        group.put("name", (Object)name);
        request.put("group", (Object)group);
        try {
            String json = this.weixin.post("https://api.weixin.qq.com/cgi-bin/groups/update?access_token=" + accessToken, (HttpEntity)new StringEntity(request.toString()));
            return Result.parse(json, Error.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new SocialException(e);
        }
    }

    public Result<Error> move(String openId, String groupId) {
        return this.move(this.weixin.getAccessToken().getToken(), openId, groupId);
    }

    public Result<Error> move(String accessToken, String openId, String groupId) {
        JSONObject request = new JSONObject();
        request.put("openid", (Object)openId);
        request.put("to_groupid", (Object)groupId);
        try {
            String json = this.weixin.post("https://api.weixin.qq.com/cgi-bin/groups/members/update?access_token=" + accessToken, (HttpEntity)new StringEntity(request.toString()));
            return Result.parse(json, Error.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new SocialException(e);
        }
    }
}

