/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.weixin.api;

import com.belerweb.social.API;
import com.belerweb.social.bean.Error;
import com.belerweb.social.bean.Result;
import com.belerweb.social.exception.SocialException;
import com.belerweb.social.weixin.api.Weixin;
import com.belerweb.social.weixin.bean.MenuType;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.StringEntity;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Menu
extends API {
    protected Menu(Weixin weixin) {
        super(weixin);
    }

    public Result<Error> create(List<com.belerweb.social.weixin.bean.Menu> menus) {
        return this.create(this.weixin.getAccessToken().getToken(), menus);
    }

    public Result<Error> create(String accessToken, List<com.belerweb.social.weixin.bean.Menu> menus) {
        JSONArray menuArray = new JSONArray();
        for (com.belerweb.social.weixin.bean.Menu menu : menus) {
            List<com.belerweb.social.weixin.bean.Menu> subs;
            JSONObject obj = new JSONObject();
            MenuType type = menu.getType();
            obj.put("name", (Object)menu.getName());
            if (type != null) {
                obj.put("type", (Object)type.value());
                if (type == MenuType.CLICK) {
                    obj.put("key", (Object)menu.getKey());
                }
                if (type == MenuType.VIEW) {
                    obj.put("url", (Object)menu.getUrl());
                }
            }
            if ((subs = menu.getSubs()) != null) {
                JSONArray _menuArray = new JSONArray();
                for (com.belerweb.social.weixin.bean.Menu _menu : subs) {
                    JSONObject _obj = new JSONObject();
                    MenuType _type = _menu.getType();
                    _obj.put("name", (Object)_menu.getName());
                    if (_type != null) {
                        _obj.put("type", (Object)_type.value());
                        if (_type == MenuType.CLICK) {
                            _obj.put("key", (Object)_menu.getKey());
                        }
                        if (_type == MenuType.VIEW) {
                            _obj.put("url", (Object)_menu.getUrl());
                        }
                    }
                    _menuArray.put((Object)_obj);
                }
                obj.put("sub_button", (Object)_menuArray);
            }
            menuArray.put((Object)obj);
        }
        JSONObject request = new JSONObject();
        request.put("button", (Object)menuArray);
        try {
            String json = this.weixin.post("https://api.weixin.qq.com/cgi-bin/menu/create?access_token=" + accessToken, (HttpEntity)new StringEntity(request.toString(), "UTF-8"));
            return Result.parse(json, Error.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new SocialException(e);
        }
    }

    public Result<List<com.belerweb.social.weixin.bean.Menu>> get() {
        return this.get(this.weixin.getAccessToken().getToken());
    }

    public Result<List<com.belerweb.social.weixin.bean.Menu>> get(String accessToken) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.weixin.addParameter(params, "access_token", accessToken);
        String json = this.weixin.get("https://api.weixin.qq.com/cgi-bin/menu/get", params);
        JSONObject jsonObject = new JSONObject(json);
        Error error = Error.parse(jsonObject);
        if (error != null) {
            return new Result<Error>(error);
        }
        List<Object> menus = new ArrayList();
        JSONObject menu = jsonObject.optJSONObject("menu");
        if (menu != null) {
            menus = Result.parse(menu.optJSONArray("button"), com.belerweb.social.weixin.bean.Menu.class);
        }
        return new Result<List<com.belerweb.social.weixin.bean.Menu>>((List<com.belerweb.social.weixin.bean.Menu>)menus);
    }

    public Result<Error> delete() {
        return this.delete(this.weixin.getAccessToken().getToken());
    }

    public Result<Error> delete(String accessToken) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.weixin.addParameter(params, "access_token", accessToken);
        String json = this.weixin.get("https://api.weixin.qq.com/cgi-bin/menu/delete", params);
        return Result.parse(json, Error.class);
    }
}

