/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.weixin.api;

import com.belerweb.social.SDK;
import com.belerweb.social.bean.Error;
import com.belerweb.social.bean.Result;
import com.belerweb.social.exception.SocialException;
import com.belerweb.social.weixin.api.Group;
import com.belerweb.social.weixin.api.Media;
import com.belerweb.social.weixin.api.Menu;
import com.belerweb.social.weixin.api.OAuth2;
import com.belerweb.social.weixin.api.User;
import com.belerweb.social.weixin.bean.AccessToken;
import com.belerweb.social.weixin.bean.Message;
import com.belerweb.social.weixin.bean.QRCreation;
import com.belerweb.social.weixin.bean.QRTicket;
import com.belerweb.social.weixin.bean.QRType;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.StringEntity;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Weixin
extends SDK {
    private String appId;
    private String secret;
    private String redirectUri;
    private String token;
    private OAuth2 oAuth2;
    private User user;
    private Group group;
    private Media media;
    private Menu menu;
    private AccessToken accessToken;
    private Date accessTokenTime;

    public Weixin(String token) {
        this.token = token;
    }

    public Weixin(String appId, String secret) {
        this.appId = appId;
        this.secret = secret;
    }

    public Weixin(String appId, String secret, String token) {
        this(appId, secret);
        this.token = token;
    }

    public Weixin(String appid, String secret, String redirectUri, String token) {
        this(appid, secret, token);
        this.redirectUri = redirectUri;
    }

    public boolean validate(String signature, String timestamp, String nonce) {
        Object[] chars = new String[]{this.token, timestamp, nonce};
        Arrays.sort(chars);
        String sha1 = DigestUtils.shaHex((String)StringUtils.join((Object[])chars));
        return sha1.equals(signature);
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public AccessToken getAccessToken() {
        if (this.accessToken == null || this.accessTokenTime == null || (new Date().getTime() - this.accessTokenTime.getTime()) / 1000L > this.accessToken.getExpiresIn()) {
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            this.addParameter(params, "appid", this.appId);
            this.addParameter(params, "secret", this.secret);
            this.addParameter(params, "grant_type", "client_credential");
            String json = this.get("https://api.weixin.qq.com/cgi-bin/token?" + StringUtils.join(params, (String)"&"), params);
            Result<AccessToken> result = Result.parse(json, AccessToken.class);
            if (result.success()) {
                this.accessToken = result.getResult();
                this.accessTokenTime = new Date();
            }
        }
        return this.accessToken;
    }

    public Result<QRTicket> createQR(QRType type, Integer sceneId) {
        return this.createQR(this.getAccessToken().getToken(), type, sceneId);
    }

    public Result<QRTicket> createQR(String accessToken, QRType type, Integer sceneId) {
        QRCreation request = new QRCreation();
        request.setType(type);
        request.setSceneId(sceneId);
        try {
            String json = this.post("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=" + accessToken, (HttpEntity)new StringEntity(request.toString()));
            return Result.parse(json, QRTicket.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new SocialException(e);
        }
    }

    public Result<Boolean> sendCustomMessage(Message message) {
        return this.sendCustomMessage(this.getAccessToken().getToken(), message);
    }

    public Result<Boolean> sendCustomMessage(String accessToken, Message message) {
        try {
            String json = this.post("https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + accessToken, (HttpEntity)new StringEntity(message.toJSON(), "UTF-8"));
            return new Result<Error>(Error.parse(new JSONObject(json)));
        }
        catch (UnsupportedEncodingException e) {
            throw new SocialException(e);
        }
    }

    public Result<Boolean> sendTemplateMessage(Message message) {
        return this.sendTemplateMessage(this.getAccessToken().getToken(), message);
    }

    public Result<Boolean> sendTemplateMessage(String accessToken, Message message) {
        try {
            String json = this.post("https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + accessToken, (HttpEntity)new StringEntity(message.toJSON(), "UTF-8"));
            return new Result<Error>(Error.parse(new JSONObject(json)));
        }
        catch (UnsupportedEncodingException e) {
            throw new SocialException(e);
        }
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public OAuth2 getOAuth2() {
        if (this.oAuth2 == null) {
            this.oAuth2 = new OAuth2(this);
        }
        return this.oAuth2;
    }

    public User getUser() {
        if (this.user == null) {
            this.user = new User(this);
        }
        return this.user;
    }

    public Group getGroup() {
        if (this.group == null) {
            this.group = new Group(this);
        }
        return this.group;
    }

    public Media getMedia() {
        if (this.media == null) {
            this.media = new Media(this);
        }
        return this.media;
    }

    public Menu getMenu() {
        if (this.menu == null) {
            this.menu = new Menu(this);
        }
        return this.menu;
    }
}

