/*
 * Decompiled with CFR 0.152.
 */
package com.belerweb.social.weixin.bean;

import com.belerweb.social.bean.JsonBean;
import com.belerweb.social.bean.Result;
import com.belerweb.social.weixin.bean.Article;
import com.belerweb.social.weixin.bean.EventType;
import com.belerweb.social.weixin.bean.MsgType;
import com.belerweb.social.weixin.bean.Variable;
import com.belerweb.social.weixin.bean.VoiceType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
extends JsonBean {
    private Long msgId;
    private String fromUser;
    private String toUser;
    private Date createTime;
    private MsgType msgType;
    private String content;
    private String mediaId;
    private String picUrl;
    private VoiceType voiceType;
    private String recognition;
    private String thumbMediaId;
    private Double lon;
    private Double lat;
    private Integer scale;
    private String label;
    private String title;
    private String description;
    private String url;
    private String musicUrl;
    private String hqMusicUrl;
    private EventType eventType;
    private String eventKey;
    private String ticket;
    private Double precision;
    private List<Article> articles;
    private String templateId;
    private String topColor;
    private List<Variable> variables;

    public Message() {
    }

    public Message(MsgType msgType) {
        this.msgType = msgType;
    }

    private Message(JSONObject jsonObject) {
        super(jsonObject);
    }

    public Long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public String getFromUser() {
        return this.fromUser;
    }

    public void setFromUser(String fromUser) {
        this.fromUser = fromUser;
    }

    public String getToUser() {
        return this.toUser;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public MsgType getMsgType() {
        return this.msgType;
    }

    public void setMsgType(MsgType msgType) {
        this.msgType = msgType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getPicUrl() {
        return this.picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public VoiceType getVoiceType() {
        return this.voiceType;
    }

    public void setVoiceType(VoiceType voiceType) {
        this.voiceType = voiceType;
    }

    public String getRecognition() {
        return this.recognition;
    }

    public void setRecognition(String recognition) {
        this.recognition = recognition;
    }

    public String getThumbMediaId() {
        return this.thumbMediaId;
    }

    public void setThumbMediaId(String thumbMediaId) {
        this.thumbMediaId = thumbMediaId;
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMusicUrl() {
        return this.musicUrl;
    }

    public void setMusicUrl(String musicUrl) {
        this.musicUrl = musicUrl;
    }

    public String getHqMusicUrl() {
        return this.hqMusicUrl;
    }

    public void setHqMusicUrl(String hqMusicUrl) {
        this.hqMusicUrl = hqMusicUrl;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public Double getPrecision() {
        return this.precision;
    }

    public void setPrecision(Double precision) {
        this.precision = precision;
    }

    public List<Article> getArticles() {
        return this.articles;
    }

    public void setArticles(List<Article> articles) {
        this.articles = articles;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getTopColor() {
        return this.topColor;
    }

    public void setTopColor(String topColor) {
        this.topColor = topColor;
    }

    public List<Variable> getVariables() {
        if (this.variables == null) {
            this.variables = new ArrayList<Variable>();
        }
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public Message addVariable(Variable variable) {
        this.getVariables().add(variable);
        return this;
    }

    public String toXML() {
        JSONObject obj = new JSONObject();
        obj.put("MsgType", (Object)this.msgType.toString());
        obj.put("ToUserName", (Object)this.toUser);
        obj.put("FromUserName", (Object)this.fromUser);
        obj.put("CreateTime", (Object)(this.createTime.getTime() / 1000L));
        if (this.msgType == MsgType.TEXT) {
            obj.put("Content", (Object)this.content);
        }
        if (this.msgType == MsgType.IMAGE) {
            JSONObject image = new JSONObject();
            image.put("MediaId", (Object)this.mediaId);
            obj.put("Image", (Object)image);
        }
        if (this.msgType == MsgType.VOICE) {
            JSONObject voice = new JSONObject();
            voice.put("MediaId", (Object)this.mediaId);
            obj.put("Voice", (Object)voice);
        }
        if (this.msgType == MsgType.VIDEO) {
            JSONObject video = new JSONObject();
            video.put("MediaId", (Object)this.mediaId);
            video.put("ThumbMediaId", (Object)this.thumbMediaId);
            obj.put("Video", (Object)video);
        }
        if (this.msgType == MsgType.MUSIC) {
            JSONObject music = new JSONObject();
            music.put("Title", (Object)this.title);
            music.put("Description", (Object)this.description);
            music.put("MusicURL", (Object)this.musicUrl);
            music.put("HQMusicUrl", (Object)this.hqMusicUrl);
            music.put("ThumbMediaId", (Object)this.thumbMediaId);
            obj.put("Music", (Object)music);
        }
        if (this.msgType == MsgType.NEWS) {
            obj.put("ArticleCount", this.articles.size());
            JSONArray array = new JSONArray();
            for (Article article : this.articles) {
                JSONObject itemWrapper = new JSONObject();
                JSONObject item = new JSONObject();
                item.put("Title", (Object)article.getTitle());
                item.put("Description", (Object)article.getDescription());
                item.put("PicUrl", (Object)article.getPicUrl());
                item.put("Url", (Object)article.getUrl());
                itemWrapper.put("item", (Object)item);
                array.put((Object)itemWrapper);
            }
            obj.put("Articles", (Object)array);
        }
        return XML.toString((Object)obj, (String)"xml");
    }

    public String toJSON() {
        JSONObject obj = new JSONObject();
        obj.put("msgtype", (Object)this.msgType.toString());
        obj.put("touser", (Object)this.toUser);
        if (this.msgType == MsgType.TEXT) {
            JSONObject text = new JSONObject();
            text.put("content", (Object)this.content);
            obj.put("text", (Object)text);
        }
        if (this.msgType == MsgType.IMAGE) {
            JSONObject image = new JSONObject();
            image.put("media_id", (Object)this.mediaId);
            obj.put("image", (Object)image);
        }
        if (this.msgType == MsgType.VOICE) {
            JSONObject voice = new JSONObject();
            voice.put("media_id", (Object)this.mediaId);
            obj.put("voice", (Object)voice);
        }
        if (this.msgType == MsgType.VIDEO) {
            JSONObject video = new JSONObject();
            video.put("media_id", (Object)this.mediaId);
            video.put("thumb_media_id", (Object)this.thumbMediaId);
            obj.put("video", (Object)video);
        }
        if (this.msgType == MsgType.MUSIC) {
            JSONObject music = new JSONObject();
            music.put("title", (Object)this.title);
            music.put("description", (Object)this.description);
            music.put("musicurl", (Object)this.musicUrl);
            music.put("hqmusicurl", (Object)this.hqMusicUrl);
            music.put("thumb_media_id", (Object)this.thumbMediaId);
            obj.put("music", (Object)music);
        }
        if (this.msgType == MsgType.NEWS) {
            JSONObject news = new JSONObject();
            JSONArray array = new JSONArray();
            for (Article article : this.articles) {
                JSONObject item = new JSONObject();
                item.put("title", (Object)article.getTitle());
                item.put("description", (Object)article.getDescription());
                item.put("picurl", (Object)article.getPicUrl());
                item.put("url", (Object)article.getUrl());
                array.put((Object)item);
            }
            news.put("articles", (Object)array);
            obj.put("news", (Object)news);
        }
        if (this.msgType == MsgType.TEMPLATE) {
            obj.put("template_id", (Object)this.templateId);
            if (StringUtils.isNotBlank((String)this.topColor)) {
                obj.put("topcolor", (Object)this.topColor);
            }
            JSONObject data = new JSONObject();
            for (Variable var : this.variables) {
                JSONObject varJson = new JSONObject();
                varJson.put("value", (Object)var.getValue());
                if (StringUtils.isNotBlank((String)var.getColor())) {
                    varJson.put("color", (Object)var.getColor());
                }
                data.put(var.getName(), (Object)varJson);
            }
            obj.put("data", (Object)data);
        }
        return obj.toString();
    }

    public static Message parse(String xml) {
        return Message.parse(XML.toJSONObject((String)xml).getJSONObject("xml"));
    }

    public static Message parse(JSONObject jsonObject) {
        MsgType type;
        if (jsonObject == null) {
            return null;
        }
        Message obj = new Message(jsonObject);
        obj.msgId = Result.parseLong(jsonObject.opt("MsgId"));
        obj.msgType = type = MsgType.parse(jsonObject.get("MsgType"));
        obj.createTime = new Date(Result.parseLong(jsonObject.get("CreateTime")) * 1000L);
        obj.fromUser = Result.toString(jsonObject.get("FromUserName"));
        obj.toUser = Result.toString(jsonObject.get("ToUserName"));
        if (type == MsgType.TEXT) {
            obj.content = Result.toString(jsonObject.opt("Content"));
        }
        if (type == MsgType.IMAGE) {
            obj.mediaId = Result.toString(jsonObject.opt("MediaId"));
            obj.picUrl = Result.toString(jsonObject.opt("PicUrl"));
        }
        if (type == MsgType.VOICE) {
            obj.mediaId = Result.toString(jsonObject.opt("MediaId"));
            obj.voiceType = VoiceType.parse(jsonObject.opt("Format"));
            obj.recognition = Result.toString(jsonObject.opt("Recognition"));
        }
        if (type == MsgType.VIDEO) {
            obj.mediaId = Result.toString(jsonObject.opt("MediaId"));
            obj.thumbMediaId = Result.toString(jsonObject.opt("ThumbMediaId"));
        }
        if (type == MsgType.LOCATION) {
            obj.lon = Result.parseDouble(jsonObject.opt("Location_Y"));
            obj.lat = Result.parseDouble(jsonObject.opt("Location_X"));
            obj.scale = Result.parseInteger(jsonObject.opt("Scale"));
            obj.label = Result.toString(jsonObject.opt("Label"));
        }
        if (type == MsgType.LINK) {
            obj.title = Result.toString(jsonObject.opt("Title"));
            obj.description = Result.toString(jsonObject.opt("Description"));
            obj.url = Result.toString(jsonObject.opt("Url"));
        }
        if (type == MsgType.EVENT) {
            EventType eventType;
            obj.eventType = eventType = EventType.parse(jsonObject.get("Event"));
            if (eventType == EventType.SUBSCRIBE) {
                obj.eventKey = Result.toString(jsonObject.opt("EventKey"));
                obj.ticket = Result.toString(jsonObject.opt("Ticket"));
            }
            if (eventType == EventType.UNSUBSCRIBE) {
                // empty if block
            }
            if (eventType == EventType.SCAN) {
                obj.eventKey = Result.toString(jsonObject.opt("EventKey"));
                obj.ticket = Result.toString(jsonObject.opt("Ticket"));
            }
            if (eventType == EventType.LOCATION) {
                obj.lon = Result.parseDouble(jsonObject.opt("Longitude"));
                obj.lat = Result.parseDouble(jsonObject.opt("Latitude"));
            }
            if (eventType == EventType.CLICK) {
                obj.eventKey = Result.toString(jsonObject.opt("EventKey"));
            }
        }
        return obj;
    }
}

