/*
 * Decompiled with CFR 0.152.
 */
package com.bellotapps.utils.error_handler;

import com.bellotapps.utils.error_handler.ErrorHandler;
import com.bellotapps.utils.error_handler.ErrorHandlerFactory;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

public abstract class AbstractErrorHandlerCreationConfigurer
implements ImportAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractErrorHandlerCreationConfigurer.class);
    private AnnotationMetadata importMetadata;
    private final ErrorHandlerFactory errorHandlerFactory;
    private final Collection<String> packagesCollection;
    private boolean initialized;

    protected AbstractErrorHandlerCreationConfigurer(ErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
        this.packagesCollection = new HashSet<String>();
        this.initialized = false;
    }

    protected AnnotationMetadata getImportMetadata() {
        Assert.state((this.importMetadata != null ? 1 : 0) != 0, (String)"No AnnotationMetadata was set");
        return this.importMetadata;
    }

    @Bean
    ErrorHandler errorHandler() {
        Assert.state((this.initialized && this.errorHandlerFactory != null ? 1 : 0) != 0, (String)"The ErrorHandlerCreationConfigurer was not correctly initialized");
        return this.errorHandlerFactory.createErrorHandler(this.packagesCollection);
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.importMetadata = importMetadata;
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.info("Starting ErrorHandler configuration, imported by class {}", (Object)this.importMetadata.getClassName());
        this.initializePackagesCollection();
        this.initialized = true;
    }

    private void initializePackagesCollection() throws Exception {
        this.packagesCollection.addAll(this.getPackagesCollection());
    }

    protected abstract Collection<String> getPackagesCollection() throws Exception;
}

