/*
 * Decompiled with CFR 0.152.
 */
package com.bellotapps.utils.error_handler;

import com.bellotapps.utils.error_handler.AbstractErrorHandlerCreationConfigurer;
import com.bellotapps.utils.error_handler.ErrorHandlerFactory;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Optional;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class AnnotationErrorHandlerCreationConfigurer<A extends Annotation>
extends AbstractErrorHandlerCreationConfigurer {
    protected AnnotationErrorHandlerCreationConfigurer(ErrorHandlerFactory errorHandlerFactory) {
        super(errorHandlerFactory);
    }

    @Override
    protected Collection<String> getPackagesCollection() throws ClassNotFoundException {
        return this.getPackagesCollectionFromAnnotation(this.retrieveAnnotation());
    }

    private A retrieveAnnotation() throws ClassNotFoundException {
        Class<?> importingClass = Class.forName(this.getImportMetadata().getClassName());
        return (A)Optional.ofNullable(AnnotationUtils.findAnnotation(importingClass, this.getAnnotationClass())).orElseThrow(IllegalArgumentException::new);
    }

    protected abstract Collection<String> getPackagesCollectionFromAnnotation(A var1);

    protected abstract Class<A> getAnnotationClass();
}

