/*
 * Decompiled with CFR 0.152.
 */
package com.bellotapps.utils.error_handler;

import com.bellotapps.utils.error_handler.ErrorHandler;
import com.bellotapps.utils.error_handler.ErrorHandlerImpl;
import com.bellotapps.utils.error_handler.ExceptionHandler;
import com.bellotapps.utils.error_handler.ExceptionHandlerObject;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.ResolvableType;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ErrorHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandlerFactory.class);
    private static final String ERROR_MESSAGE = "Could not create an error handler";
    private final ClassLoader classLoader;
    private final BeanFactory beanFactory;
    private final ClassPathScanningCandidateComponentProvider scanner;
    private final Map<String, List<ExceptionHandler<? extends Throwable, ?>>> cachedHandlers;

    public ErrorHandlerFactory(ClassLoader classLoader, BeanFactory beanFactory) {
        Assert.notNull((Object)classLoader, (String)"The class loader must not be null");
        Assert.notNull((Object)beanFactory, (String)"The bean factory must not be null");
        this.classLoader = classLoader;
        this.beanFactory = beanFactory;
        this.scanner = new ClassPathScanningCandidateComponentProvider(false);
        this.scanner.addIncludeFilter((TypeFilter)new ExceptionHandlerObjectAnnotatedAndExceptionHandlerAssignableTypeFilter());
        this.cachedHandlers = new ConcurrentHashMap();
    }

    public void resetCache() {
        this.cachedHandlers.clear();
    }

    public void resetCache(String ... packages) {
        this.resetCache(Arrays.asList(packages));
    }

    public void resetCache(Collection<String> packages) {
        packages.forEach(this.cachedHandlers::remove);
    }

    public ErrorHandler createErrorHandler(String ... packages) {
        return this.createErrorHandler(Arrays.asList(packages));
    }

    public ErrorHandler createErrorHandler(Collection<String> packages) {
        Map foundedHandlers = packages.stream().filter(pkg -> !this.cachedHandlers.containsKey(pkg)).collect(Collectors.toMap(Function.identity(), pkg -> this.scanPackage((String)pkg).stream().map(klass -> new ExceptionHandlerGetter((Class)klass, this.beanFactory)).map(rec$ -> ((ExceptionHandlerGetter)rec$).getHandler()).collect(Collectors.toList())));
        this.cachedHandlers.putAll(foundedHandlers);
        List<ExceptionHandler<? extends Throwable, ?>> handlers = this.cachedHandlers.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        return new ErrorHandlerImpl(handlers);
    }

    private Set<Class<?>> scanPackage(String pkg) {
        return this.scanner.findCandidateComponents(pkg).stream().map(beanDef -> ClassUtils.resolveClassName((String)beanDef.getBeanClassName(), (ClassLoader)this.classLoader)).collect(Collectors.toSet());
    }

    private static class ExceptionHandlerObjectAnnotatedAndExceptionHandlerAssignableTypeFilter
    implements TypeFilter {
        private final AnnotationTypeFilter exceptionHandlerObjectAnnotationFilter = new AnnotationTypeFilter(ExceptionHandlerObject.class);
        private final AssignableTypeFilter assignableFromExceptionHandlerInterfaceFilter = new AssignableTypeFilter(ExceptionHandler.class);

        private ExceptionHandlerObjectAnnotatedAndExceptionHandlerAssignableTypeFilter() {
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            return this.exceptionHandlerObjectAnnotationFilter.match(metadataReader, metadataReaderFactory) && this.assignableFromExceptionHandlerInterfaceFilter.match(metadataReader, metadataReaderFactory);
        }
    }

    private static final class ExceptionHandlerGetter<T extends ExceptionHandler<? extends Throwable, ?>> {
        private final Class<T> handlerClass;
        private final BeanFactory beanFactory;

        private ExceptionHandlerGetter(Class<?> handlerClass, BeanFactory beanFactory) {
            this.handlerClass = handlerClass;
            this.beanFactory = beanFactory;
        }

        private T getHandler() {
            return (T)this.searchForBean().orElseGet(this::instantiate);
        }

        private Optional<T> searchForBean() throws BeanInitializationException {
            try {
                ExceptionHandler handler = (ExceptionHandler)this.beanFactory.getBean(this.handlerClass);
                ExceptionHandlerGetter.logBeanFound(this.handlerClass);
                return Optional.of(handler);
            }
            catch (NoUniqueBeanDefinitionException e) {
                ExceptionHandlerGetter.logMultipleBeans(this.handlerClass);
                return Optional.empty();
            }
            catch (NoSuchBeanDefinitionException e) {
                ExceptionHandlerGetter.logNoBeanFound(this.handlerClass);
                return Optional.empty();
            }
            catch (BeansException e) {
                ExceptionHandlerGetter.logBeansException(this.handlerClass);
                throw new BeanInitializationException(ErrorHandlerFactory.ERROR_MESSAGE, (Throwable)e);
            }
            catch (Throwable e) {
                ExceptionHandlerGetter.logUnexpectedErrorWhenSearchingForBeans(this.handlerClass, e);
                throw new BeanInitializationException(ErrorHandlerFactory.ERROR_MESSAGE, e);
            }
        }

        private T instantiate() {
            try {
                Constructor<T> constructor = this.handlerClass.getDeclaredConstructor(new Class[0]);
                boolean accessible = constructor.isAccessible();
                constructor.setAccessible(true);
                ExceptionHandler handler = (ExceptionHandler)constructor.newInstance(new Object[0]);
                constructor.setAccessible(accessible);
                return (T)handler;
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("No default constructor for class {}", this.handlerClass);
                throw new BeanInitializationException(ErrorHandlerFactory.ERROR_MESSAGE, (Throwable)e);
            }
            catch (InstantiationException e) {
                LOGGER.error("Could not instantiate class {}. Is this class abstract?", this.handlerClass);
                throw new BeanInitializationException(ErrorHandlerFactory.ERROR_MESSAGE, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.debug("Could not access default constructor of class {}", this.handlerClass);
                LOGGER.error("Could not instantiate class {}", this.handlerClass);
                throw new BeanInitializationException(ErrorHandlerFactory.ERROR_MESSAGE, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Could not instantiate exception handler {} as an exception was thrown while executing its constructor.", this.handlerClass);
                throw new BeanInitializationException(ErrorHandlerFactory.ERROR_MESSAGE, (Throwable)e);
            }
        }

        private static void logBeanFound(Class<? extends ExceptionHandler<? extends Throwable, ?>> handlerClass) {
            Class throwableClass = ResolvableType.forClass(ExceptionHandler.class, handlerClass).getGeneric(new int[]{0}).resolve();
            LOGGER.info("Found bean of {} for throwable {}", (Object)handlerClass.getName(), (Object)throwableClass.getName());
        }

        private static void logMultipleBeans(Class<? extends ExceptionHandler<? extends Throwable, ?>> handlerClass) {
            LOGGER.warn("More than one bean exist for class {}. Will instantiate own handler", handlerClass);
        }

        private static void logNoBeanFound(Class<? extends ExceptionHandler<? extends Throwable, ?>> handlerClass) {
            LOGGER.debug("No bean for class {}. Will create one", handlerClass);
        }

        private static void logBeansException(Class<? extends ExceptionHandler<? extends Throwable, ?>> handlerClass) {
            LOGGER.error("Could not get bean for class {}", handlerClass);
        }

        private static void logUnexpectedErrorWhenSearchingForBeans(Class<?> klass, Throwable e) {
            LOGGER.error("Some unexpected error occurred when trying to get an Exception Handler for class {}.", klass);
            LOGGER.error("Please, report this issue.", e);
        }
    }
}

