/*
 * Decompiled with CFR 0.152.
 */
package com.bellotapps.utils.error_handler;

import com.bellotapps.utils.error_handler.ErrorHandlerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ErrorHandlerFactoryConfigurer
implements InitializingBean,
BeanFactoryAware,
BeanClassLoaderAware {
    private BeanFactory beanFactory;
    private ClassLoader classLoader;
    private boolean initialized = false;

    @Bean
    public ErrorHandlerFactory errorHandlerFactory() {
        if (!this.initialized || this.classLoader == null || this.beanFactory == null) {
            throw new BeanInitializationException("The ErrorHandlerFactoryConfigurer was not correctly initialized");
        }
        return new ErrorHandlerFactory(this.classLoader, this.beanFactory);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        this.initialized = true;
    }
}

