/*
 * Decompiled with CFR 0.152.
 */
package com.bellotapps.utils.error_handler;

import com.bellotapps.utils.error_handler.ErrorHandler;
import com.bellotapps.utils.error_handler.ExceptionHandler;
import com.bellotapps.utils.error_handler.HandlingResult;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public class ErrorHandlerImpl
implements ErrorHandler,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandlerContainer.class);
    private final Set<ExceptionHandlerContainer<? extends Throwable, ?>> handlers;
    private static final ExceptionHandler<Throwable, Object> DEFAULT_THROWABLE_HANDLER = ignored -> HandlingResult.justErrorCode(500);

    ErrorHandlerImpl(List<ExceptionHandler<? extends Throwable, ?>> handlers) {
        Set<ExceptionHandlerContainer<Throwable, ?>> container = ErrorHandlerImpl.toContainers(handlers);
        long throwableCount = container.stream().map(rec$ -> ((ExceptionHandlerContainer)rec$).getExceptionClass()).filter(klass -> klass.equals(Throwable.class)).count();
        if (throwableCount == 0L) {
            LOGGER.warn("No ExceptionHandler defined for Throwable. Using default.");
            container.add(new ExceptionHandlerContainer(DEFAULT_THROWABLE_HANDLER));
        }
        this.handlers = Collections.unmodifiableSet(container);
    }

    public void afterPropertiesSet() {
        LOGGER.info("Error handler initialized");
        LOGGER.debug("Will handle {}", this.handlers.stream().map(rec$ -> ((ExceptionHandlerContainer)rec$).getExceptionClass()).collect(Collectors.toSet()));
    }

    @Override
    public <T extends Throwable, E> HandlingResult<E> handle(T exception) {
        Assert.notNull(exception, (String)"The exception must not be null");
        Class<?> receivedExceptionClass = exception.getClass();
        ExceptionHandler handler = this.handlers.stream().filter(container -> ((ExceptionHandlerContainer)container).getExceptionClass().isAssignableFrom(receivedExceptionClass)).map(container -> container).map(container -> new ContainerWithDistance(receivedExceptionClass, (ExceptionHandlerContainer)container)).min(Comparator.comparingInt(rec$ -> ((ContainerWithDistance)rec$).getDistance())).map(rec$ -> ((ContainerWithDistance)rec$).getContainer()).orElseThrow(() -> {
            ErrorHandlerImpl.LOGGER.error("No container saved for received exception, which is a throwable");
            return new IllegalStateException("No container saved for received exception, which is a throwable. Consider storing a ExceptionHandlerContainer for Throwable?");
        }).getHandler();
        return handler.handle(exception);
    }

    private static Set<ExceptionHandlerContainer<? extends Throwable, ?>> toContainers(List<ExceptionHandler<? extends Throwable, ?>> handlers) {
        List containers = handlers.stream().map(x$0 -> new ExceptionHandlerContainer((ExceptionHandler)x$0)).collect(Collectors.toList());
        Map<Class, List> repeated = containers.stream().collect(Collectors.groupingBy(rec$ -> ((ExceptionHandlerContainer)rec$).getExceptionClass())).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        repeated.forEach((exceptionClass, containersList) -> {
            if (containersList.size() == 0) {
                return;
            }
            ExceptionHandlerContainer firstContainer = (ExceptionHandlerContainer)containersList.get(0);
            containers.removeAll((Collection<?>)containersList);
            containers.add(containersList.get(0));
            LOGGER.warn("More than one ExceptionHandler for Throwable {}. {} Will be used.", exceptionClass, (Object)firstContainer.getHandler());
        });
        return new HashSet(containers);
    }

    private static <T extends E, E extends Throwable> int distance(Class<T> receivedExceptionClass, Class<E> savedExceptionClass) throws IllegalArgumentException {
        Assert.notNull(receivedExceptionClass, (String)"Received null as exception to handle");
        Assert.notNull(savedExceptionClass, (String)"A null was saved as a managed exception");
        Assert.isTrue((boolean)savedExceptionClass.isAssignableFrom(receivedExceptionClass), (String)"Received exception class is not assignable from saved exception class");
        int distance = 0;
        for (Class<T> actual = receivedExceptionClass; actual != savedExceptionClass; actual = actual.getSuperclass()) {
            ++distance;
        }
        return distance;
    }

    private static final class ContainerWithDistance<T extends Throwable, E> {
        private final int distance;
        private final ExceptionHandlerContainer<T, E> container;

        private ContainerWithDistance(Class<T> exceptionClass, ExceptionHandlerContainer<T, E> container) {
            this.distance = ErrorHandlerImpl.distance(exceptionClass, ((ExceptionHandlerContainer)container).getExceptionClass());
            this.container = container;
        }

        private int getDistance() {
            return this.distance;
        }

        private ExceptionHandlerContainer<T, E> getContainer() {
            return this.container;
        }
    }

    private static final class ExceptionHandlerContainer<T extends Throwable, E> {
        private final Class<T> exceptionClass;
        private final ExceptionHandler<T, E> handler;

        private ExceptionHandlerContainer(ExceptionHandler<T, E> handler) {
            Assert.notNull(handler, (String)"The handler must not be null");
            this.exceptionClass = ResolvableType.forClass(ExceptionHandler.class, handler.getClass()).getGeneric(new int[]{0}).resolve();
            this.handler = handler;
        }

        private Class<T> getExceptionClass() {
            return this.exceptionClass;
        }

        private ExceptionHandler<T, E> getHandler() {
            return this.handler;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExceptionHandlerContainer)) {
                return false;
            }
            ExceptionHandlerContainer that = (ExceptionHandlerContainer)o;
            return this.exceptionClass.equals(that.exceptionClass);
        }

        public int hashCode() {
            return this.exceptionClass.hashCode();
        }
    }
}

