/*
 * Decompiled with CFR 0.152.
 */
package com.bellotapps.utils.error_handler;

import org.springframework.util.Assert;

public class HandlingResult<E> {
    private final int httpErrorCode;
    private final E errorRepresentationEntity;

    private HandlingResult(int httpErrorCode, E errorRepresentationEntity) {
        this.httpErrorCode = httpErrorCode;
        this.errorRepresentationEntity = errorRepresentationEntity;
    }

    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    public E getErrorRepresentationEntity() {
        return this.errorRepresentationEntity;
    }

    public static <T> HandlingResult<T> withPayload(int httpErrorCode, T errorRepresentationEntity) {
        Assert.notNull(errorRepresentationEntity, (String)"When using the withPayload factory method, a payload must be set. For null payload results use the justErrorCode factory method");
        return new HandlingResult<T>(httpErrorCode, errorRepresentationEntity);
    }

    public static <T> HandlingResult<T> justErrorCode(int httpErrorCode) {
        return new HandlingResult<Object>(httpErrorCode, null);
    }
}

