/*
 * Decompiled with CFR 0.152.
 */
package com.bendb.dropwizard.jooq;

import com.bendb.dropwizard.jooq.JooqConfiguration;
import com.bendb.dropwizard.jooq.JooqFactory;
import com.bendb.dropwizard.jooq.JooqHealthCheck;
import com.bendb.dropwizard.jooq.jersey.JooqBinder;
import com.bendb.dropwizard.jooq.jersey.LoggingDataAccessExceptionMapper;
import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jooq.Configuration;

public abstract class JooqBundle<C extends io.dropwizard.Configuration>
implements ConfiguredBundle<C>,
JooqConfiguration<C> {
    private static final String DEFAULT_NAME = "jooq";
    private final SortedMap<String, Configuration> jooqFactoryConfigurationMap = new TreeMap<String, Configuration>();

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(C configuration, Environment environment) throws Exception {
        this.configureDataSourceFactory(configuration, environment, this.primaryDataSourceName(), this.getDataSourceFactory((io.dropwizard.Configuration)configuration));
        this.getSecondaryDataSourceFactories((io.dropwizard.Configuration)configuration).entrySet().stream().forEach(e -> this.configureDataSourceFactory(configuration, environment, (String)e.getKey(), (PooledDataSourceFactory)e.getValue()));
        environment.jersey().register((Object)new JooqBinder(this.jooqFactoryConfigurationMap));
        environment.jersey().register((Object)new LoggingDataAccessExceptionMapper());
    }

    public String primaryDataSourceName() {
        return DEFAULT_NAME;
    }

    @Override
    public JooqFactory getJooqFactory(C configuration) {
        return new JooqFactory();
    }

    public Configuration getConfiguration() {
        return this.jooqFactoryConfigurationMap.values().stream().findFirst().orElse(null);
    }

    public Map<String, Configuration> getConfigurationMap() {
        return this.jooqFactoryConfigurationMap;
    }

    private void configureDataSourceFactory(C configuration, Environment environment, String name, PooledDataSourceFactory dataSourceFactory) throws RuntimeException {
        try {
            JooqFactory jooqFactory = this.getJooqFactory(configuration);
            Configuration cfg = jooqFactory.build(environment, dataSourceFactory, name);
            JooqHealthCheck healthCheck = new JooqHealthCheck(cfg, dataSourceFactory.getValidationQuery());
            environment.healthChecks().register(name, (HealthCheck)healthCheck);
            this.jooqFactoryConfigurationMap.put(name, cfg);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

