/*
 * Thrifty
 *
 * Copyright (c) Benjamin Bader
 * Copyright (c) Microsoft Corporation
 *
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * THIS CODE IS PROVIDED ON AN  *AS IS* BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION ANY IMPLIED WARRANTIES OR CONDITIONS OF TITLE,
 * FITNESS FOR A PARTICULAR PURPOSE, MERCHANTABLITY OR NON-INFRINGEMENT.
 *
 * See the Apache Version 2.0 License for specific language governing permissions and limitations under the License.
 */
package com.bendb.thrifty.kotlin

import com.bendb.thrifty.protocol.Protocol

/**
 * An object that can read and write Kotlin data classes generated
 * by the Thrifty compiler, to and from a [Protocol] object.
 *
 * @param T The struct type, generated by the Thrifty compiler.
 */
interface Adapter<T> {
    /**
     * Reads a Thrift struct from the given [protocol].
     *
     * @param protocol A [Protocol] from which to read a struct.
     */
    fun read(protocol: Protocol): T

    /**
     * Writes the given [struct] to the given [protocol].
     *
     * @param protocol A [Protocol] to which to write the [struct].
     * @param struct A struct to be written out.
     */
    fun write(protocol: Protocol, struct: T)
}
