/*
 * Decompiled with CFR 0.152.
 */
package com.bendb.thrifty.protocol;

import com.bendb.thrifty.protocol.BaseProtocol;
import com.bendb.thrifty.protocol.FieldMetadata;
import com.bendb.thrifty.protocol.ListMetadata;
import com.bendb.thrifty.protocol.MapMetadata;
import com.bendb.thrifty.protocol.MessageMetadata;
import com.bendb.thrifty.protocol.SetMetadata;
import com.bendb.thrifty.protocol.StructMetadata;
import com.bendb.thrifty.transport.Transport;
import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b+\u0018\u0000 Z2\u00020\u0001:\u0001ZB#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0017H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0017H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0017H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0017H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020\u001aH\u0002J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u0017H\u0016J\u0010\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u000eH\u0016J\u0010\u00104\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u000bH\u0016J\u0010\u00106\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u0011H\u0016J\u0010\u00107\u001a\u00020\u00172\u0006\u00108\u001a\u00020\u0013H\u0016J \u00109\u001a\u00020\u00172\u0006\u0010:\u001a\u00020,2\u0006\u0010;\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u0011H\u0016J\b\u0010=\u001a\u00020\u0017H\u0016J\b\u0010>\u001a\u00020\u0017H\u0016J\u0010\u0010?\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\u001cH\u0016J\u0010\u0010A\u001a\u00020\u00172\u0006\u0010B\u001a\u00020\u001aH\u0016J\u0010\u0010C\u001a\u00020\u00172\u0006\u0010D\u001a\u00020\u0005H\u0016J\u0018\u0010E\u001a\u00020\u00172\u0006\u0010F\u001a\u00020\u00112\u0006\u0010G\u001a\u00020\u001aH\u0016J\b\u0010H\u001a\u00020\u0017H\u0016J \u0010I\u001a\u00020\u00172\u0006\u0010J\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u00112\u0006\u0010L\u001a\u00020\u001aH\u0016J\b\u0010M\u001a\u00020\u0017H\u0016J \u0010N\u001a\u00020\u00172\u0006\u0010O\u001a\u00020,2\u0006\u0010<\u001a\u00020\u00112\u0006\u0010P\u001a\u00020\u001aH\u0016J\b\u0010Q\u001a\u00020\u0017H\u0016J\u0018\u0010R\u001a\u00020\u00172\u0006\u0010F\u001a\u00020\u00112\u0006\u0010S\u001a\u00020\u001aH\u0016J\b\u0010T\u001a\u00020\u0017H\u0016J\u0010\u0010U\u001a\u00020\u00172\u0006\u0010V\u001a\u00020,H\u0016J\u0010\u0010W\u001a\u00020\u00172\u0006\u0010X\u001a\u00020,H\u0016J\b\u0010Y\u001a\u00020\u0017H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/bendb/thrifty/protocol/BinaryProtocol;", "Lcom/bendb/thrifty/protocol/BaseProtocol;", "transport", "Lcom/bendb/thrifty/transport/Transport;", "stringLengthLimit", "", "containerLengthLimit", "(Lcom/bendb/thrifty/transport/Transport;JJ)V", "buffer", "", "strictRead", "", "strictWrite", "readBinary", "Lokio/ByteString;", "readBool", "readByte", "", "readDouble", "", "readFieldBegin", "Lcom/bendb/thrifty/protocol/FieldMetadata;", "readFieldEnd", "", "readFully", "count", "", "readI16", "", "readI32", "readI64", "readListBegin", "Lcom/bendb/thrifty/protocol/ListMetadata;", "readListEnd", "readMapBegin", "Lcom/bendb/thrifty/protocol/MapMetadata;", "readMapEnd", "readMessageBegin", "Lcom/bendb/thrifty/protocol/MessageMetadata;", "readMessageEnd", "readSetBegin", "Lcom/bendb/thrifty/protocol/SetMetadata;", "readSetEnd", "readString", "", "readStringWithSize", "size", "readStructBegin", "Lcom/bendb/thrifty/protocol/StructMetadata;", "readStructEnd", "writeBinary", "buf", "writeBool", "b", "writeByte", "writeDouble", "dub", "writeFieldBegin", "fieldName", "fieldId", "typeId", "writeFieldEnd", "writeFieldStop", "writeI16", "i16", "writeI32", "i32", "writeI64", "i64", "writeListBegin", "elementTypeId", "listSize", "writeListEnd", "writeMapBegin", "keyTypeId", "valueTypeId", "mapSize", "writeMapEnd", "writeMessageBegin", "name", "seqId", "writeMessageEnd", "writeSetBegin", "setSize", "writeSetEnd", "writeString", "str", "writeStructBegin", "structName", "writeStructEnd", "Companion", "thrifty-runtime"})
public final class BinaryProtocol
extends BaseProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long stringLengthLimit;
    private final long containerLengthLimit;
    @NotNull
    private final byte[] buffer;
    private final boolean strictRead;
    private final boolean strictWrite;
    private static final int VERSION_MASK = -65536;
    private static final int VERSION_1 = -2147418112;
    @NotNull
    private static final StructMetadata NO_STRUCT = new StructMetadata("");

    @JvmOverloads
    public BinaryProtocol(@NotNull Transport transport2, long stringLengthLimit, long containerLengthLimit) {
        Intrinsics.checkNotNullParameter((Object)transport2, (String)"transport");
        super(transport2);
        this.stringLengthLimit = stringLengthLimit;
        this.containerLengthLimit = containerLengthLimit;
        this.buffer = new byte[8];
    }

    public /* synthetic */ BinaryProtocol(Transport transport2, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = -1L;
        }
        if ((n & 4) != 0) {
            l2 = -1L;
        }
        this(transport2, l, l2);
    }

    @Override
    public void writeMessageBegin(@NotNull String name, byte typeId, int seqId) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.strictWrite) {
            int version = 0x80010000 | typeId & 0xFF;
            this.writeI32(version);
            this.writeString(name);
            this.writeI32(seqId);
        } else {
            this.writeString(name);
            this.writeByte(typeId);
            this.writeI32(seqId);
        }
    }

    @Override
    public void writeMessageEnd() throws IOException {
    }

    @Override
    public void writeStructBegin(@NotNull String structName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)structName, (String)"structName");
    }

    @Override
    public void writeStructEnd() throws IOException {
    }

    @Override
    public void writeFieldBegin(@NotNull String fieldName, int fieldId, byte typeId) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        this.writeByte(typeId);
        this.writeI16((short)fieldId);
    }

    @Override
    public void writeFieldEnd() throws IOException {
    }

    @Override
    public void writeFieldStop() throws IOException {
        this.writeByte((byte)0);
    }

    @Override
    public void writeMapBegin(byte keyTypeId, byte valueTypeId, int mapSize) throws IOException {
        this.writeByte(keyTypeId);
        this.writeByte(valueTypeId);
        this.writeI32(mapSize);
    }

    @Override
    public void writeMapEnd() throws IOException {
    }

    @Override
    public void writeListBegin(byte elementTypeId, int listSize) throws IOException {
        this.writeByte(elementTypeId);
        this.writeI32(listSize);
    }

    @Override
    public void writeListEnd() throws IOException {
    }

    @Override
    public void writeSetBegin(byte elementTypeId, int setSize) throws IOException {
        this.writeByte(elementTypeId);
        this.writeI32(setSize);
    }

    @Override
    public void writeSetEnd() throws IOException {
    }

    @Override
    public void writeBool(boolean b) throws IOException {
        this.writeByte(b ? (byte)1 : 0);
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.buffer[0] = b;
        this.transport.write(this.buffer, 0, 1);
    }

    @Override
    public void writeI16(short i16) throws IOException {
        this.buffer[0] = (byte)(i16 >> 8 & 0xFF);
        this.buffer[1] = (byte)(i16 & 0xFF);
        this.transport.write(this.buffer, 0, 2);
    }

    @Override
    public void writeI32(int i32) throws IOException {
        this.buffer[0] = (byte)(i32 >> 24 & 0xFF);
        this.buffer[1] = (byte)(i32 >> 16 & 0xFF);
        this.buffer[2] = (byte)(i32 >> 8 & 0xFF);
        this.buffer[3] = (byte)(i32 & 0xFF);
        this.transport.write(this.buffer, 0, 4);
    }

    @Override
    public void writeI64(long i64) throws IOException {
        this.buffer[0] = (byte)(i64 >> 56 & 0xFFL);
        this.buffer[1] = (byte)(i64 >> 48 & 0xFFL);
        this.buffer[2] = (byte)(i64 >> 40 & 0xFFL);
        this.buffer[3] = (byte)(i64 >> 32 & 0xFFL);
        this.buffer[4] = (byte)(i64 >> 24 & 0xFFL);
        this.buffer[5] = (byte)(i64 >> 16 & 0xFFL);
        this.buffer[6] = (byte)(i64 >> 8 & 0xFFL);
        this.buffer[7] = (byte)(i64 & 0xFFL);
        this.transport.write(this.buffer, 0, 8);
    }

    @Override
    public void writeDouble(double dub) throws IOException {
        this.writeI64(Double.doubleToRawLongBits(dub));
    }

    @Override
    public void writeString(@NotNull String str) throws IOException {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        byte[] bs = StringsKt.encodeToByteArray((String)str);
        this.writeI32(bs.length);
        this.transport.write(bs);
    }

    @Override
    public void writeBinary(@NotNull ByteString buf) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.writeI32(buf.size());
        this.transport.write(buf.toByteArray());
    }

    @Override
    @NotNull
    public MessageMetadata readMessageBegin() throws IOException {
        MessageMetadata messageMetadata;
        int size = this.readI32();
        if (size < 0) {
            int version = size & 0xFFFF0000;
            if (version != -2147418112) {
                throw new ProtocolException("Bad version in readMessageBegin");
            }
            messageMetadata = new MessageMetadata(this.readString(), (byte)(size & 0xFF), this.readI32());
        } else {
            if (this.strictRead) {
                throw new ProtocolException("Missing version in readMessageBegin");
            }
            messageMetadata = new MessageMetadata(this.readStringWithSize(size), this.readByte(), this.readI32());
        }
        return messageMetadata;
    }

    @Override
    public void readMessageEnd() throws IOException {
    }

    @Override
    @NotNull
    public StructMetadata readStructBegin() throws IOException {
        return NO_STRUCT;
    }

    @Override
    public void readStructEnd() throws IOException {
    }

    @Override
    @NotNull
    public FieldMetadata readFieldBegin() throws IOException {
        byte typeId = this.readByte();
        short fieldId = typeId == 0 ? (short)0 : this.readI16();
        return new FieldMetadata("", typeId, fieldId);
    }

    @Override
    public void readFieldEnd() throws IOException {
    }

    @Override
    @NotNull
    public MapMetadata readMapBegin() throws IOException {
        byte keyTypeId = this.readByte();
        byte valueTypeId = this.readByte();
        int size = this.readI32();
        if (this.containerLengthLimit != -1L && (long)size > this.containerLengthLimit) {
            throw new ProtocolException("Container size limit exceeded");
        }
        return new MapMetadata(keyTypeId, valueTypeId, size);
    }

    @Override
    public void readMapEnd() throws IOException {
    }

    @Override
    @NotNull
    public ListMetadata readListBegin() throws IOException {
        byte elementTypeId = this.readByte();
        int size = this.readI32();
        if (this.containerLengthLimit != -1L && (long)size > this.containerLengthLimit) {
            throw new ProtocolException("Container size limit exceeded");
        }
        return new ListMetadata(elementTypeId, size);
    }

    @Override
    public void readListEnd() throws IOException {
    }

    @Override
    @NotNull
    public SetMetadata readSetBegin() throws IOException {
        byte elementTypeId = this.readByte();
        int size = this.readI32();
        if (this.containerLengthLimit != -1L && (long)size > this.containerLengthLimit) {
            throw new ProtocolException("Container size limit exceeded");
        }
        return new SetMetadata(elementTypeId, size);
    }

    @Override
    public void readSetEnd() throws IOException {
    }

    @Override
    public boolean readBool() throws IOException {
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws IOException {
        this.readFully(this.buffer, 1);
        return this.buffer[0];
    }

    @Override
    public short readI16() throws IOException {
        this.readFully(this.buffer, 2);
        return (short)((this.buffer[0] & 0xFF) << 8 | this.buffer[1] & 0xFF);
    }

    @Override
    public int readI32() throws IOException {
        this.readFully(this.buffer, 4);
        return (this.buffer[0] & 0xFF) << 24 | (this.buffer[1] & 0xFF) << 16 | (this.buffer[2] & 0xFF) << 8 | this.buffer[3] & 0xFF;
    }

    @Override
    public long readI64() throws IOException {
        this.readFully(this.buffer, 8);
        return ((long)this.buffer[0] & 0xFFL) << 56 | ((long)this.buffer[1] & 0xFFL) << 48 | ((long)this.buffer[2] & 0xFFL) << 40 | ((long)this.buffer[3] & 0xFFL) << 32 | ((long)this.buffer[4] & 0xFFL) << 24 | ((long)this.buffer[5] & 0xFFL) << 16 | ((long)this.buffer[6] & 0xFFL) << 8 | (long)this.buffer[7] & 0xFFL;
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readI64());
    }

    @Override
    @NotNull
    public String readString() throws IOException {
        int sizeInBytes = this.readI32();
        if (this.stringLengthLimit != -1L && (long)sizeInBytes > this.stringLengthLimit) {
            throw new ProtocolException("String size limit exceeded");
        }
        return this.readStringWithSize(sizeInBytes);
    }

    @Override
    @NotNull
    public ByteString readBinary() throws IOException {
        int sizeInBytes = this.readI32();
        if (this.stringLengthLimit != -1L && (long)sizeInBytes > this.stringLengthLimit) {
            throw new ProtocolException("Binary size limit exceeded");
        }
        byte[] data = new byte[sizeInBytes];
        this.readFully(data, data.length);
        return ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])data, (int)0, (int)0, (int)3, null);
    }

    private final String readStringWithSize(int size) throws IOException {
        byte[] encoded = new byte[size];
        this.readFully(encoded, size);
        return StringsKt.decodeToString((byte[])encoded);
    }

    private final void readFully(byte[] buffer, int count) throws IOException {
        int toRead = count;
        int offset = 0;
        while (toRead > 0) {
            int read = this.transport.read(buffer, offset, toRead);
            if (read == -1) {
                throw new EOFException("Expected " + count + " bytes; got " + offset);
            }
            toRead -= read;
            offset += read;
        }
    }

    @JvmOverloads
    public BinaryProtocol(@NotNull Transport transport2, long stringLengthLimit) {
        Intrinsics.checkNotNullParameter((Object)transport2, (String)"transport");
        this(transport2, stringLengthLimit, 0L, 4, null);
    }

    @JvmOverloads
    public BinaryProtocol(@NotNull Transport transport2) {
        Intrinsics.checkNotNullParameter((Object)transport2, (String)"transport");
        this(transport2, 0L, 0L, 6, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/bendb/thrifty/protocol/BinaryProtocol$Companion;", "", "()V", "NO_STRUCT", "Lcom/bendb/thrifty/protocol/StructMetadata;", "VERSION_1", "", "VERSION_MASK", "thrifty-runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

