/*
 * Decompiled with CFR 0.152.
 */
package com.bendb.thrifty.protocol;

import com.bendb.thrifty.protocol.BaseProtocol;
import com.bendb.thrifty.protocol.FieldMetadata;
import com.bendb.thrifty.protocol.ListMetadata;
import com.bendb.thrifty.protocol.MapMetadata;
import com.bendb.thrifty.protocol.MessageMetadata;
import com.bendb.thrifty.protocol.SetMetadata;
import com.bendb.thrifty.protocol.StructMetadata;
import com.bendb.thrifty.transport.Transport;
import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b5\u0018\u0000 i2\u00020\u0001:\u0003hijB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016J.\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00170\u0019H\u0082\b\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020 2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0006H\u0002J\b\u0010#\u001a\u00020\fH\u0016J\b\u0010$\u001a\u00020\u0006H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020 H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020 H\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020 H\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020 H\u0016J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020 H\u0016J\b\u00108\u001a\u00020\u0006H\u0002J\b\u00109\u001a\u00020&H\u0002J\u0010\u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020\u0012H\u0016J\u0010\u0010<\u001a\u00020 2\u0006\u0010=\u001a\u00020\u0014H\u0016J\u0010\u0010>\u001a\u00020 2\u0006\u0010=\u001a\u00020\bH\u0016J\u0010\u0010?\u001a\u00020 2\u0006\u0010@\u001a\u00020\u001cH\u0016J\u0018\u0010A\u001a\u00020 2\u0006\u0010B\u001a\u00020\u00062\u0006\u0010C\u001a\u00020\bH\u0002J \u0010A\u001a\u00020 2\u0006\u0010D\u001a\u0002042\u0006\u0010B\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\bH\u0016J\b\u0010F\u001a\u00020 H\u0016J\b\u0010G\u001a\u00020 H\u0016J\u0010\u0010H\u001a\u00020 2\u0006\u0010I\u001a\u00020\fH\u0016J\u0010\u0010J\u001a\u00020 2\u0006\u0010K\u001a\u00020\u0006H\u0016J\u0010\u0010L\u001a\u00020 2\u0006\u0010M\u001a\u00020&H\u0016J\u0018\u0010N\u001a\u00020 2\u0006\u0010O\u001a\u00020\b2\u0006\u0010P\u001a\u00020\u0006H\u0016J\b\u0010Q\u001a\u00020 H\u0016J \u0010R\u001a\u00020 2\u0006\u0010S\u001a\u00020\b2\u0006\u0010T\u001a\u00020\b2\u0006\u0010U\u001a\u00020\u0006H\u0016J\b\u0010V\u001a\u00020 H\u0016J \u0010W\u001a\u00020 2\u0006\u0010X\u001a\u0002042\u0006\u0010E\u001a\u00020\b2\u0006\u0010Y\u001a\u00020\u0006H\u0016J\b\u0010Z\u001a\u00020 H\u0016J\u0018\u0010[\u001a\u00020 2\u0006\u0010O\u001a\u00020\b2\u0006\u0010\\\u001a\u00020\u0006H\u0016J\b\u0010]\u001a\u00020 H\u0016J\u0010\u0010^\u001a\u00020 2\u0006\u0010_\u001a\u000204H\u0016J\u0010\u0010`\u001a\u00020 2\u0006\u0010a\u001a\u000204H\u0016J\b\u0010b\u001a\u00020 H\u0016J\u0010\u0010c\u001a\u00020 2\u0006\u0010d\u001a\u00020\u0006H\u0002J\u0010\u0010e\u001a\u00020 2\u0006\u0010d\u001a\u00020&H\u0002J\u0018\u0010f\u001a\u00020 2\u0006\u0010E\u001a\u00020\b2\u0006\u0010g\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lcom/bendb/thrifty/protocol/CompactProtocol;", "Lcom/bendb/thrifty/protocol/BaseProtocol;", "transport", "Lcom/bendb/thrifty/transport/Transport;", "(Lcom/bendb/thrifty/transport/Transport;)V", "booleanFieldId", "", "booleanFieldType", "", "buffer", "", "lastReadingField", "", "lastWritingField", "readingFields", "Lcom/bendb/thrifty/protocol/CompactProtocol$ShortStack;", "writingFields", "readBinary", "Lokio/ByteString;", "readBool", "", "readByte", "readCollectionBegin", "T", "buildMetadata", "Lkotlin/Function2;", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "readDouble", "", "readFieldBegin", "Lcom/bendb/thrifty/protocol/FieldMetadata;", "readFieldEnd", "", "readFully", "count", "readI16", "readI32", "readI64", "", "readListBegin", "Lcom/bendb/thrifty/protocol/ListMetadata;", "readListEnd", "readMapBegin", "Lcom/bendb/thrifty/protocol/MapMetadata;", "readMapEnd", "readMessageBegin", "Lcom/bendb/thrifty/protocol/MessageMetadata;", "readMessageEnd", "readSetBegin", "Lcom/bendb/thrifty/protocol/SetMetadata;", "readSetEnd", "readString", "", "readStructBegin", "Lcom/bendb/thrifty/protocol/StructMetadata;", "readStructEnd", "readVarint32", "readVarint64", "writeBinary", "buf", "writeBool", "b", "writeByte", "writeDouble", "dub", "writeFieldBegin", "fieldId", "compactTypeId", "fieldName", "typeId", "writeFieldEnd", "writeFieldStop", "writeI16", "i16", "writeI32", "i32", "writeI64", "i64", "writeListBegin", "elementTypeId", "listSize", "writeListEnd", "writeMapBegin", "keyTypeId", "valueTypeId", "mapSize", "writeMapEnd", "writeMessageBegin", "name", "seqId", "writeMessageEnd", "writeSetBegin", "setSize", "writeSetEnd", "writeString", "str", "writeStructBegin", "structName", "writeStructEnd", "writeVarint32", "num", "writeVarint64", "writeVectorBegin", "size", "CompactTypes", "Companion", "ShortStack", "thrifty-runtime"})
@SourceDebugExtension(value={"SMAP\nCompactProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompactProtocol.kt\ncom/bendb/thrifty/protocol/CompactProtocol\n*L\n1#1,619:1\n377#1,8:620\n377#1,8:628\n*S KotlinDebug\n*F\n+ 1 CompactProtocol.kt\ncom/bendb/thrifty/protocol/CompactProtocol\n*L\n363#1:620,8\n373#1:628,8\n*E\n"})
public final class CompactProtocol
extends BaseProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int booleanFieldId;
    private byte booleanFieldType;
    @NotNull
    private final byte[] buffer;
    @NotNull
    private final ShortStack writingFields;
    private short lastWritingField;
    @NotNull
    private final ShortStack readingFields;
    private short lastReadingField;
    private static final byte PROTOCOL_ID = -126;
    private static final byte VERSION = 1;
    private static final byte VERSION_MASK = 31;
    private static final byte TYPE_MASK = -32;
    private static final byte TYPE_BITS = 7;
    private static final int TYPE_SHIFT_AMOUNT = 5;
    @NotNull
    private static final StructMetadata NO_STRUCT = new StructMetadata("");
    @NotNull
    private static final FieldMetadata END_FIELDS = new FieldMetadata("", 0, 0);

    public CompactProtocol(@NotNull Transport transport2) {
        Intrinsics.checkNotNullParameter((Object)transport2, (String)"transport");
        super(transport2);
        this.booleanFieldId = -1;
        this.booleanFieldType = (byte)-1;
        this.buffer = new byte[16];
        this.writingFields = new ShortStack();
        this.readingFields = new ShortStack();
    }

    @Override
    public void writeMessageBegin(@NotNull String name, byte typeId, int seqId) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.writeByte((byte)-126);
        this.writeByte((byte)(1 | typeId << 5 & 0xFFFFFFE0));
        this.writeVarint32(seqId);
        this.writeString(name);
    }

    @Override
    public void writeMessageEnd() throws IOException {
    }

    @Override
    public void writeStructBegin(@NotNull String structName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)structName, (String)"structName");
        this.writingFields.push(this.lastWritingField);
        this.lastWritingField = 0;
    }

    @Override
    public void writeStructEnd() throws IOException {
        this.lastWritingField = this.writingFields.pop();
    }

    @Override
    public void writeFieldBegin(@NotNull String fieldName, int fieldId, byte typeId) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        if (typeId == 2) {
            if (this.booleanFieldId != -1) {
                throw new ProtocolException("Nested invocation of writeFieldBegin");
            }
            this.booleanFieldId = fieldId;
        } else {
            this.writeFieldBegin(fieldId, CompactTypes.Companion.ttypeToCompact(typeId));
        }
    }

    private final void writeFieldBegin(int fieldId, byte compactTypeId) throws IOException {
        if (fieldId > this.lastWritingField && fieldId - this.lastWritingField <= 15) {
            this.writeByte((byte)(fieldId - this.lastWritingField << 4 | compactTypeId));
        } else {
            this.writeByte(compactTypeId);
            this.writeI16((short)fieldId);
        }
        this.lastWritingField = (short)fieldId;
    }

    @Override
    public void writeFieldEnd() throws IOException {
    }

    @Override
    public void writeFieldStop() throws IOException {
        this.writeByte((byte)0);
    }

    @Override
    public void writeMapBegin(byte keyTypeId, byte valueTypeId, int mapSize) throws IOException {
        if (mapSize == 0) {
            this.writeByte((byte)0);
        } else {
            byte compactKeyType = CompactTypes.Companion.ttypeToCompact(keyTypeId);
            byte compactValueType = CompactTypes.Companion.ttypeToCompact(valueTypeId);
            this.writeVarint32(mapSize);
            this.writeByte((byte)(compactKeyType << 4 | compactValueType));
        }
    }

    @Override
    public void writeMapEnd() throws IOException {
    }

    @Override
    public void writeListBegin(byte elementTypeId, int listSize) throws IOException {
        this.writeVectorBegin(elementTypeId, listSize);
    }

    @Override
    public void writeListEnd() throws IOException {
    }

    @Override
    public void writeSetBegin(byte elementTypeId, int setSize) throws IOException {
        this.writeVectorBegin(elementTypeId, setSize);
    }

    @Override
    public void writeSetEnd() throws IOException {
    }

    @Override
    public void writeBool(boolean b) throws IOException {
        byte compactValue;
        byte by = compactValue = b ? (byte)1 : 2;
        if (this.booleanFieldId != -1) {
            this.writeFieldBegin(this.booleanFieldId, compactValue);
            this.booleanFieldId = -1;
        } else {
            this.writeByte(compactValue);
        }
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.buffer[0] = b;
        this.transport.write(this.buffer, 0, 1);
    }

    @Override
    public void writeI16(short i16) throws IOException {
        this.writeVarint32(CompactProtocol.Companion.intToZigZag(i16));
    }

    @Override
    public void writeI32(int i32) throws IOException {
        this.writeVarint32(CompactProtocol.Companion.intToZigZag(i32));
    }

    @Override
    public void writeI64(long i64) throws IOException {
        this.writeVarint64(CompactProtocol.Companion.longToZigZag(i64));
    }

    @Override
    public void writeDouble(double dub) throws IOException {
        long bits = Double.doubleToRawLongBits(dub);
        this.buffer[0] = (byte)(bits & 0xFFL);
        this.buffer[1] = (byte)(bits >>> 8 & 0xFFL);
        this.buffer[2] = (byte)(bits >>> 16 & 0xFFL);
        this.buffer[3] = (byte)(bits >>> 24 & 0xFFL);
        this.buffer[4] = (byte)(bits >>> 32 & 0xFFL);
        this.buffer[5] = (byte)(bits >>> 40 & 0xFFL);
        this.buffer[6] = (byte)(bits >>> 48 & 0xFFL);
        this.buffer[7] = (byte)(bits >>> 56 & 0xFFL);
        this.transport.write(this.buffer, 0, 8);
    }

    @Override
    public void writeString(@NotNull String str) throws IOException {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        byte[] bytes = StringsKt.encodeToByteArray((String)str);
        this.writeVarint32(bytes.length);
        this.transport.write(bytes);
    }

    @Override
    public void writeBinary(@NotNull ByteString buf) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.writeVarint32(buf.size());
        this.transport.write(buf.toByteArray());
    }

    private final void writeVectorBegin(byte typeId, int size) throws IOException {
        byte compactId = CompactTypes.Companion.ttypeToCompact(typeId);
        if (size <= 14) {
            this.writeByte((byte)(size << 4 | compactId));
        } else {
            this.writeByte((byte)(0xF0 | compactId));
            this.writeVarint32(size);
        }
    }

    private final void writeVarint32(int num) throws IOException {
        int n = num;
        int n2 = this.buffer.length;
        for (int i = 0; i < n2; ++i) {
            if ((n & 0xFFFFFF80) == 0) {
                this.buffer[i] = (byte)n;
                this.transport.write(this.buffer, 0, i + 1);
                return;
            }
            this.buffer[i] = (byte)(n & 0x7F | 0x80);
            n >>>= 7;
        }
        throw new IllegalArgumentException("Cannot represent " + n + " as a varint in 16 bytes or less");
    }

    private final void writeVarint64(long num) throws IOException {
        long n = num;
        int n2 = this.buffer.length;
        for (int i = 0; i < n2; ++i) {
            if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.buffer[i] = (byte)n;
                this.transport.write(this.buffer, 0, i + 1);
                return;
            }
            this.buffer[i] = (byte)(n & 0x7FL | 0x80L);
            n >>>= 7;
        }
        throw new IllegalArgumentException("Cannot represent " + n + " as a varint in 16 bytes or less");
    }

    @Override
    @NotNull
    public MessageMetadata readMessageBegin() throws IOException {
        byte protocolId = this.readByte();
        if (protocolId != -126) {
            StringBuilder stringBuilder = new StringBuilder().append("Expected protocol ID -126 but got ");
            String string = Integer.toString(protocolId, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            throw new ProtocolException(stringBuilder.append(string).toString());
        }
        byte versionAndType = this.readByte();
        byte version = (byte)(0x1F & versionAndType);
        if (version != 1) {
            throw new ProtocolException("Version mismatch; expected version 1 but got " + version);
        }
        byte typeId = (byte)(versionAndType >> 5 & 7);
        int seqId = this.readVarint32();
        String name = this.readString();
        return new MessageMetadata(name, typeId, seqId);
    }

    @Override
    public void readMessageEnd() throws IOException {
    }

    @Override
    @NotNull
    public StructMetadata readStructBegin() throws IOException {
        this.readingFields.push(this.lastReadingField);
        this.lastReadingField = 0;
        return NO_STRUCT;
    }

    @Override
    public void readStructEnd() throws IOException {
        this.lastReadingField = this.readingFields.pop();
    }

    @Override
    @NotNull
    public FieldMetadata readFieldBegin() throws IOException {
        byte compactId = this.readByte();
        byte typeId = CompactTypes.Companion.compactToTtype((byte)(compactId & 0xF));
        if (compactId == 0) {
            return END_FIELDS;
        }
        short fieldId = 0;
        short modifier = (short)((compactId & 0xF0) >> 4);
        short s = fieldId = modifier == 0 ? this.readI16() : (short)(this.lastReadingField + modifier);
        if (typeId == 2) {
            this.booleanFieldType = (byte)(compactId & 0xF);
        }
        this.lastReadingField = fieldId;
        return new FieldMetadata("", typeId, fieldId);
    }

    @Override
    public void readFieldEnd() throws IOException {
    }

    @Override
    @NotNull
    public MapMetadata readMapBegin() throws IOException {
        int size = this.readVarint32();
        byte keyAndValueTypes = size == 0 ? (byte)0 : this.readByte();
        byte keyType = CompactTypes.Companion.compactToTtype((byte)(keyAndValueTypes >> 4 & 0xF));
        byte valueType = CompactTypes.Companion.compactToTtype((byte)(keyAndValueTypes & 0xF));
        return new MapMetadata(keyType, valueType, size);
    }

    @Override
    public void readMapEnd() throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ListMetadata readListBegin() throws IOException {
        void p1;
        CompactProtocol this_$iv = this;
        boolean $i$f$readCollectionBegin = false;
        byte sizeAndType$iv = this_$iv.readByte();
        int size$iv = sizeAndType$iv >> 4 & 0xF;
        if (size$iv == 15) {
            size$iv = this_$iv.readVarint32();
        }
        byte compactType$iv = (byte)(sizeAndType$iv & 0xF);
        byte ttype$iv = CompactTypes.Companion.compactToTtype(compactType$iv);
        int n = size$iv;
        byte p0 = ttype$iv;
        boolean bl = false;
        return new ListMetadata(p0, (int)p1);
    }

    @Override
    public void readListEnd() throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SetMetadata readSetBegin() throws IOException {
        void p1;
        CompactProtocol this_$iv = this;
        boolean $i$f$readCollectionBegin = false;
        byte sizeAndType$iv = this_$iv.readByte();
        int size$iv = sizeAndType$iv >> 4 & 0xF;
        if (size$iv == 15) {
            size$iv = this_$iv.readVarint32();
        }
        byte compactType$iv = (byte)(sizeAndType$iv & 0xF);
        byte ttype$iv = CompactTypes.Companion.compactToTtype(compactType$iv);
        int n = size$iv;
        byte p0 = ttype$iv;
        boolean bl = false;
        return new SetMetadata(p0, (int)p1);
    }

    private final <T> T readCollectionBegin(Function2<? super Byte, ? super Integer, ? extends T> buildMetadata) {
        boolean $i$f$readCollectionBegin = false;
        byte sizeAndType = this.readByte();
        int size = sizeAndType >> 4 & 0xF;
        if (size == 15) {
            size = this.readVarint32();
        }
        byte compactType = (byte)(sizeAndType & 0xF);
        byte ttype = CompactTypes.Companion.compactToTtype(compactType);
        return (T)buildMetadata.invoke((Object)ttype, (Object)size);
    }

    @Override
    public void readSetEnd() throws IOException {
    }

    @Override
    public boolean readBool() throws IOException {
        byte compactId = 0;
        if (this.booleanFieldType != -1) {
            compactId = this.booleanFieldType;
            this.booleanFieldType = (byte)-1;
        } else {
            compactId = this.readByte();
        }
        return compactId == 1;
    }

    @Override
    public byte readByte() throws IOException {
        this.readFully(this.buffer, 1);
        return this.buffer[0];
    }

    @Override
    public short readI16() throws IOException {
        return (short)CompactProtocol.Companion.zigZagToInt(this.readVarint32());
    }

    @Override
    public int readI32() throws IOException {
        return CompactProtocol.Companion.zigZagToInt(this.readVarint32());
    }

    @Override
    public long readI64() throws IOException {
        return CompactProtocol.Companion.zigZagToLong(this.readVarint64());
    }

    @Override
    public double readDouble() throws IOException {
        this.readFully(this.buffer, 8);
        long bits = (long)this.buffer[0] & 0xFFL | ((long)this.buffer[1] & 0xFFL) << 8 | ((long)this.buffer[2] & 0xFFL) << 16 | ((long)this.buffer[3] & 0xFFL) << 24 | ((long)this.buffer[4] & 0xFFL) << 32 | ((long)this.buffer[5] & 0xFFL) << 40 | ((long)this.buffer[6] & 0xFFL) << 48 | ((long)this.buffer[7] & 0xFFL) << 56;
        return Double.longBitsToDouble(bits);
    }

    @Override
    @NotNull
    public String readString() throws IOException {
        int length = this.readVarint32();
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        this.readFully(bytes, length);
        return StringsKt.decodeToString((byte[])bytes);
    }

    @Override
    @NotNull
    public ByteString readBinary() throws IOException {
        int length = this.readVarint32();
        if (length == 0) {
            return ByteString.EMPTY;
        }
        byte[] bytes = new byte[length];
        this.readFully(bytes, length);
        return ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])bytes, (int)0, (int)0, (int)3, null);
    }

    private final int readVarint32() throws IOException {
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = this.readByte();
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 128) {
                return result;
            }
            shift += 7;
        }
    }

    private final long readVarint64() throws IOException {
        long result = 0L;
        int shift = 0;
        while (true) {
            byte b = this.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 128) {
                return result;
            }
            shift += 7;
        }
    }

    private final void readFully(byte[] buffer, int count) throws IOException {
        int toRead = count;
        int offset = 0;
        while (toRead > 0) {
            int read = this.transport.read(buffer, offset, toRead);
            if (read == -1) {
                throw new EOFException();
            }
            toRead -= read;
            offset += read;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/bendb/thrifty/protocol/CompactProtocol$CompactTypes;", "", "()V", "Companion", "thrifty-runtime"})
    private static final class CompactTypes {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final byte BOOLEAN_TRUE = 1;
        public static final byte BOOLEAN_FALSE = 2;
        public static final byte BYTE = 3;
        public static final byte I16 = 4;
        public static final byte I32 = 5;
        public static final byte I64 = 6;
        public static final byte DOUBLE = 7;
        public static final byte BINARY = 8;
        public static final byte LIST = 9;
        public static final byte SET = 10;
        public static final byte MAP = 11;
        public static final byte STRUCT = 12;

        private CompactTypes() {
            throw new AssertionError((Object)"no instances");
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/bendb/thrifty/protocol/CompactProtocol$CompactTypes$Companion;", "", "()V", "BINARY", "", "BOOLEAN_FALSE", "BOOLEAN_TRUE", "BYTE", "DOUBLE", "I16", "I32", "I64", "LIST", "MAP", "SET", "STRUCT", "compactToTtype", "compactId", "ttypeToCompact", "typeId", "thrifty-runtime"})
        public static final class Companion {
            private Companion() {
            }

            public final byte ttypeToCompact(byte typeId) {
                int n;
                byte by = typeId;
                if (by == 0) {
                    n = 0;
                } else {
                    if (by == 1) {
                        throw new IllegalArgumentException("Unexpected VOID type");
                    }
                    if (by == 2) {
                        n = 1;
                    } else if (by == 3) {
                        n = 3;
                    } else if (by == 4) {
                        n = 7;
                    } else if (by == 6) {
                        n = 4;
                    } else if (by == 8) {
                        n = 5;
                    } else if (by == 10) {
                        n = 6;
                    } else if (by == 11) {
                        n = 8;
                    } else if (by == 12) {
                        n = 12;
                    } else if (by == 13) {
                        n = 11;
                    } else if (by == 14) {
                        n = 10;
                    } else if (by == 15) {
                        n = 9;
                    } else {
                        throw new IllegalArgumentException("Unknown TType ID: " + typeId);
                    }
                }
                return (byte)n;
            }

            public final byte compactToTtype(byte compactId) {
                int n;
                byte by = compactId;
                if (by == 0) {
                    n = 0;
                } else if (by == 1) {
                    n = 2;
                } else if (by == 2) {
                    n = 2;
                } else if (by == 3) {
                    n = 3;
                } else if (by == 4) {
                    n = 6;
                } else if (by == 5) {
                    n = 8;
                } else if (by == 6) {
                    n = 10;
                } else if (by == 7) {
                    n = 4;
                } else if (by == 8) {
                    n = 11;
                } else if (by == 9) {
                    n = 15;
                } else if (by == 10) {
                    n = 14;
                } else if (by == 11) {
                    n = 13;
                } else if (by == 12) {
                    n = 12;
                } else {
                    throw new IllegalArgumentException("Unknown compact type ID: " + compactId);
                }
                return (byte)n;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/bendb/thrifty/protocol/CompactProtocol$Companion;", "", "()V", "END_FIELDS", "Lcom/bendb/thrifty/protocol/FieldMetadata;", "NO_STRUCT", "Lcom/bendb/thrifty/protocol/StructMetadata;", "PROTOCOL_ID", "", "TYPE_BITS", "TYPE_MASK", "TYPE_SHIFT_AMOUNT", "", "VERSION", "VERSION_MASK", "intToZigZag", "n", "longToZigZag", "", "zigZagToInt", "zigZagToLong", "thrifty-runtime"})
    public static final class Companion {
        private Companion() {
        }

        private final int intToZigZag(int n) {
            return n << 1 ^ n >> 31;
        }

        private final long longToZigZag(long n) {
            return n << 1 ^ n >> 63;
        }

        private final int zigZagToInt(int n) {
            return n >>> 1 ^ -(n & 1);
        }

        private final long zigZagToLong(long n) {
            return n >>> 1 ^ -(n & 1L);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/bendb/thrifty/protocol/CompactProtocol$ShortStack;", "", "()V", "stack", "", "top", "", "pop", "", "push", "", "value", "thrifty-runtime"})
    private static final class ShortStack {
        @NotNull
        private short[] stack = new short[16];
        private int top = -1;

        public final void push(short value) {
            if (this.top + 1 == this.stack.length) {
                short[] sArray = Arrays.copyOf(this.stack, this.stack.length << 1);
                Intrinsics.checkNotNullExpressionValue((Object)sArray, (String)"copyOf(this, newSize)");
                this.stack = sArray;
            }
            ++this.top;
            this.stack[this.top] = value;
        }

        public final short pop() {
            int n = this.top;
            this.top = n + -1;
            return this.stack[n];
        }
    }
}

