/*
 * Decompiled with CFR 0.152.
 */
package com.bendb.thrifty.protocol;

import com.bendb.thrifty.protocol.BaseProtocol;
import com.bendb.thrifty.protocol.FieldMetadata;
import com.bendb.thrifty.protocol.ListMetadata;
import com.bendb.thrifty.protocol.MapMetadata;
import com.bendb.thrifty.protocol.MessageMetadata;
import com.bendb.thrifty.protocol.SetMetadata;
import com.bendb.thrifty.protocol.StructMetadata;
import com.bendb.thrifty.transport.Transport;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b9\u0018\u0000 r2\u00020\u0001:\u0006rstuvwB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\bH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0013H\u0002J\b\u0010&\u001a\u00020\u0013H\u0002J\b\u0010'\u001a\u00020\u0017H\u0002J\b\u0010(\u001a\u00020\u001bH\u0002J\b\u0010)\u001a\u00020$H\u0002J\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020\u0013H\u0002J\b\u0010-\u001a\u00020\u0013H\u0002J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0005H\u0002J\u0010\u00100\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u0013H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\u0013H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020\u0013H\u0016J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u0013H\u0016J\b\u0010=\u001a\u00020+H\u0016J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020\u0013H\u0016J\b\u0010A\u001a\u00020\u0013H\u0016J\b\u0010B\u001a\u00020\u0013H\u0002J\u0010\u0010C\u001a\u00020\u00132\u0006\u0010D\u001a\u00020\u0017H\u0016J\u0010\u0010E\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010F\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010G\u001a\u00020\u00132\u0006\u0010H\u001a\u00020\u001bH\u0016J \u0010I\u001a\u00020\u00132\u0006\u0010J\u001a\u00020+2\u0006\u0010K\u001a\u00020\"2\u0006\u0010L\u001a\u00020\u0011H\u0016J\b\u0010M\u001a\u00020\u0013H\u0016J\b\u0010N\u001a\u00020\u0013H\u0016J\u0010\u0010O\u001a\u00020\u00132\u0006\u0010P\u001a\u00020 H\u0016J\u0010\u0010Q\u001a\u00020\u00132\u0006\u0010R\u001a\u00020\"H\u0016J\u0010\u0010S\u001a\u00020\u00132\u0006\u0010T\u001a\u00020$H\u0016J\b\u0010U\u001a\u00020\u0013H\u0002J\b\u0010V\u001a\u00020\u0013H\u0002J\u0010\u0010W\u001a\u00020\u00132\u0006\u0010X\u001a\u00020\u001bH\u0002J\u0010\u0010Y\u001a\u00020\u00132\u0006\u0010X\u001a\u00020$H\u0002J\b\u0010Z\u001a\u00020\u0013H\u0002J\b\u0010[\u001a\u00020\u0013H\u0002J\u0010\u0010\\\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0018\u0010]\u001a\u00020\u00132\u0006\u0010^\u001a\u00020\u00112\u0006\u0010_\u001a\u00020\"H\u0016J\b\u0010`\u001a\u00020\u0013H\u0016J \u0010a\u001a\u00020\u00132\u0006\u0010b\u001a\u00020\u00112\u0006\u0010c\u001a\u00020\u00112\u0006\u0010d\u001a\u00020\"H\u0016J\b\u0010e\u001a\u00020\u0013H\u0016J \u0010f\u001a\u00020\u00132\u0006\u0010g\u001a\u00020+2\u0006\u0010L\u001a\u00020\u00112\u0006\u0010h\u001a\u00020\"H\u0016J\b\u0010i\u001a\u00020\u0013H\u0016J\u0018\u0010j\u001a\u00020\u00132\u0006\u0010^\u001a\u00020\u00112\u0006\u0010k\u001a\u00020\"H\u0016J\b\u0010l\u001a\u00020\u0013H\u0016J\u0010\u0010m\u001a\u00020\u00132\u0006\u0010n\u001a\u00020+H\u0016J\u0010\u0010o\u001a\u00020\u00132\u0006\u0010p\u001a\u00020+H\u0016J\b\u0010q\u001a\u00020\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006x"}, d2={"Lcom/bendb/thrifty/protocol/JsonProtocol;", "Lcom/bendb/thrifty/protocol/BaseProtocol;", "transport", "Lcom/bendb/thrifty/transport/Transport;", "fieldNamesAsString", "", "(Lcom/bendb/thrifty/transport/Transport;Z)V", "context", "Lcom/bendb/thrifty/protocol/JsonProtocol$JsonBaseContext;", "contextStack", "Lkotlin/collections/ArrayDeque;", "reader", "Lcom/bendb/thrifty/protocol/JsonProtocol$LookaheadReader;", "tmpbuf", "", "isJsonNumeric", "b", "", "popContext", "", "pushContext", "c", "readBinary", "Lokio/ByteString;", "readBool", "readByte", "readDouble", "", "readFieldBegin", "Lcom/bendb/thrifty/protocol/FieldMetadata;", "readFieldEnd", "readI16", "", "readI32", "", "readI64", "", "readJsonArrayEnd", "readJsonArrayStart", "readJsonBase64", "readJsonDouble", "readJsonInteger", "readJsonNumericChars", "", "readJsonObjectEnd", "readJsonObjectStart", "readJsonString", "skipContext", "readJsonSyntaxChar", "readListBegin", "Lcom/bendb/thrifty/protocol/ListMetadata;", "readListEnd", "readMapBegin", "Lcom/bendb/thrifty/protocol/MapMetadata;", "readMapEnd", "readMessageBegin", "Lcom/bendb/thrifty/protocol/MessageMetadata;", "readMessageEnd", "readSetBegin", "Lcom/bendb/thrifty/protocol/SetMetadata;", "readSetEnd", "readString", "readStructBegin", "Lcom/bendb/thrifty/protocol/StructMetadata;", "readStructEnd", "reset", "resetContext", "writeBinary", "buf", "writeBool", "writeByte", "writeDouble", "dub", "writeFieldBegin", "fieldName", "fieldId", "typeId", "writeFieldEnd", "writeFieldStop", "writeI16", "i16", "writeI32", "i32", "writeI64", "i64", "writeJsonArrayEnd", "writeJsonArrayStart", "writeJsonDouble", "num", "writeJsonInteger", "writeJsonObjectEnd", "writeJsonObjectStart", "writeJsonString", "writeListBegin", "elementTypeId", "listSize", "writeListEnd", "writeMapBegin", "keyTypeId", "valueTypeId", "mapSize", "writeMapEnd", "writeMessageBegin", "name", "seqId", "writeMessageEnd", "writeSetBegin", "setSize", "writeSetEnd", "writeString", "str", "writeStructBegin", "structName", "writeStructEnd", "Companion", "JsonBaseContext", "JsonListContext", "JsonPairContext", "JsonTypes", "LookaheadReader", "thrifty-runtime"})
public final class JsonProtocol
extends BaseProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean fieldNamesAsString;
    @NotNull
    private final ArrayDeque<JsonBaseContext> contextStack;
    @NotNull
    private JsonBaseContext context;
    @NotNull
    private LookaheadReader reader;
    @NotNull
    private final byte[] tmpbuf;
    @NotNull
    private static final byte[] COMMA;
    @NotNull
    private static final byte[] COLON;
    @NotNull
    private static final byte[] LBRACE;
    @NotNull
    private static final byte[] RBRACE;
    @NotNull
    private static final byte[] LBRACKET;
    @NotNull
    private static final byte[] RBRACKET;
    @NotNull
    private static final byte[] QUOTE;
    @NotNull
    private static final byte[] BACKSLASH;
    @NotNull
    private static final byte[] ESCSEQ;
    private static final long VERSION = 1L;
    @NotNull
    private static final byte[] JSON_CHAR_TABLE;
    @NotNull
    private static final String ESCAPE_CHARS = "\"\\/bfnrt";
    @NotNull
    private static final byte[] ESCAPE_CHAR_VALS;

    @JvmOverloads
    public JsonProtocol(@NotNull Transport transport2, boolean fieldNamesAsString) {
        Intrinsics.checkNotNullParameter((Object)transport2, (String)"transport");
        super(transport2);
        this.fieldNamesAsString = fieldNamesAsString;
        this.contextStack = new ArrayDeque();
        this.context = new JsonBaseContext();
        this.reader = new LookaheadReader();
        this.tmpbuf = new byte[4];
    }

    public /* synthetic */ JsonProtocol(Transport transport2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(transport2, bl);
    }

    private final void pushContext(JsonBaseContext c) {
        this.contextStack.addFirst((Object)this.context);
        this.context = c;
    }

    private final void popContext() {
        this.context = (JsonBaseContext)this.contextStack.removeFirst();
    }

    private final void resetContext() {
        while (!this.contextStack.isEmpty()) {
            this.popContext();
        }
    }

    @Override
    public void reset() {
        this.contextStack.clear();
        this.context = new JsonBaseContext();
        this.reader = new LookaheadReader();
    }

    private final void readJsonSyntaxChar(byte[] b) throws IOException {
        byte ch = this.reader.read();
        if (ch != b[0]) {
            throw new ProtocolException("Unexpected character:" + (char)ch);
        }
    }

    private final void writeJsonString(byte[] b) throws IOException {
        this.context.write();
        this.transport.write(QUOTE);
        int len = b.length;
        for (int i = 0; i < len; ++i) {
            if ((b[i] & 0xFF) >= 48) {
                if (b[i] == BACKSLASH[0]) {
                    this.transport.write(BACKSLASH);
                    this.transport.write(BACKSLASH);
                    continue;
                }
                this.transport.write(b, i, 1);
                continue;
            }
            this.tmpbuf[0] = JSON_CHAR_TABLE[b[i]];
            if (this.tmpbuf[0] == 1) {
                this.transport.write(b, i, 1);
                continue;
            }
            if (this.tmpbuf[0] > 1) {
                this.transport.write(BACKSLASH);
                this.transport.write(this.tmpbuf, 0, 1);
                continue;
            }
            this.transport.write(ESCSEQ);
            this.tmpbuf[0] = JsonProtocol.Companion.hexChar((byte)(b[i] >> 4));
            this.tmpbuf[1] = JsonProtocol.Companion.hexChar(b[i]);
            this.transport.write(this.tmpbuf, 0, 2);
        }
        this.transport.write(QUOTE);
    }

    private final void writeJsonInteger(long num) throws IOException {
        this.context.write();
        String str = String.valueOf(num);
        boolean escapeNum = this.context.escapeNum();
        if (escapeNum) {
            this.transport.write(QUOTE);
        }
        this.transport.write(StringsKt.encodeToByteArray((String)str));
        if (escapeNum) {
            this.transport.write(QUOTE);
        }
    }

    private final void writeJsonDouble(double num) throws IOException {
        boolean escapeNum;
        this.context.write();
        String str = String.valueOf(num);
        boolean special = false;
        char c = str.charAt(0);
        if (c == 'N' ? true : c == 'I') {
            special = true;
        } else if (c == '-' && str.charAt(1) == 'I') {
            special = true;
        }
        boolean bl = escapeNum = special || this.context.escapeNum();
        if (escapeNum) {
            this.transport.write(QUOTE);
        }
        this.transport.write(StringsKt.encodeToByteArray((String)str));
        if (escapeNum) {
            this.transport.write(QUOTE);
        }
    }

    private final void writeJsonObjectStart() throws IOException {
        this.context.write();
        this.transport.write(LBRACE);
        this.pushContext(new JsonPairContext());
    }

    private final void writeJsonObjectEnd() throws IOException {
        this.popContext();
        this.transport.write(RBRACE);
    }

    private final void writeJsonArrayStart() throws IOException {
        this.context.write();
        this.transport.write(LBRACKET);
        this.pushContext(new JsonListContext());
    }

    private final void writeJsonArrayEnd() throws IOException {
        this.popContext();
        this.transport.write(RBRACKET);
    }

    @Override
    public void writeMessageBegin(@NotNull String name, byte typeId, int seqId) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.resetContext();
        this.writeJsonArrayStart();
        this.writeJsonInteger(1L);
        this.writeJsonString(StringsKt.encodeToByteArray((String)name));
        this.writeJsonInteger(typeId);
        this.writeJsonInteger(seqId);
    }

    @Override
    public void writeMessageEnd() throws IOException {
        this.writeJsonArrayEnd();
    }

    @Override
    public void writeStructBegin(@NotNull String structName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)structName, (String)"structName");
        this.writeJsonObjectStart();
    }

    @Override
    public void writeStructEnd() throws IOException {
        this.writeJsonObjectEnd();
    }

    @Override
    public void writeFieldBegin(@NotNull String fieldName, int fieldId, byte typeId) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        if (this.fieldNamesAsString) {
            this.writeString(fieldName);
        } else {
            this.writeJsonInteger(fieldId);
        }
        this.writeJsonObjectStart();
        this.writeJsonString(JsonTypes.ttypeToJson(typeId));
    }

    @Override
    public void writeFieldEnd() throws IOException {
        this.writeJsonObjectEnd();
    }

    @Override
    public void writeFieldStop() {
    }

    @Override
    public void writeMapBegin(byte keyTypeId, byte valueTypeId, int mapSize) throws IOException {
        this.writeJsonArrayStart();
        this.writeJsonString(JsonTypes.ttypeToJson(keyTypeId));
        this.writeJsonString(JsonTypes.ttypeToJson(valueTypeId));
        this.writeJsonInteger(mapSize);
        this.writeJsonObjectStart();
    }

    @Override
    public void writeMapEnd() throws IOException {
        this.writeJsonObjectEnd();
        this.writeJsonArrayEnd();
    }

    @Override
    public void writeListBegin(byte elementTypeId, int listSize) throws IOException {
        this.writeJsonArrayStart();
        this.writeJsonString(JsonTypes.ttypeToJson(elementTypeId));
        this.writeJsonInteger(listSize);
    }

    @Override
    public void writeListEnd() throws IOException {
        this.writeJsonArrayEnd();
    }

    @Override
    public void writeSetBegin(byte elementTypeId, int setSize) throws IOException {
        this.writeJsonArrayStart();
        this.writeJsonString(JsonTypes.ttypeToJson(elementTypeId));
        this.writeJsonInteger(setSize);
    }

    @Override
    public void writeSetEnd() throws IOException {
        this.writeJsonArrayEnd();
    }

    @Override
    public void writeBool(boolean b) throws IOException {
        this.writeJsonInteger(b ? 1L : 0L);
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.writeJsonInteger(b);
    }

    @Override
    public void writeI16(short i16) throws IOException {
        this.writeJsonInteger(i16);
    }

    @Override
    public void writeI32(int i32) throws IOException {
        this.writeJsonInteger(i32);
    }

    @Override
    public void writeI64(long i64) throws IOException {
        this.writeJsonInteger(i64);
    }

    @Override
    public void writeDouble(double dub) throws IOException {
        this.writeJsonDouble(dub);
    }

    @Override
    public void writeString(@NotNull String str) throws IOException {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.writeJsonString(StringsKt.encodeToByteArray((String)str));
    }

    @Override
    public void writeBinary(@NotNull ByteString buf) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.writeString(buf.base64());
    }

    private final ByteString readJsonString(boolean skipContext) throws IOException {
        byte ch;
        Buffer buffer = new Buffer();
        ArrayList<Character> codeunits = new ArrayList<Character>();
        if (!skipContext) {
            this.context.read();
        }
        this.readJsonSyntaxChar(QUOTE);
        while ((ch = this.reader.read()) != QUOTE[0]) {
            if (ch == ESCSEQ[0]) {
                ch = this.reader.read();
                if (ch == ESCSEQ[1]) {
                    this.transport.read(this.tmpbuf, 0, 4);
                    short cu = (short)((JsonProtocol.Companion.hexVal(this.tmpbuf[0]) << 12) + (JsonProtocol.Companion.hexVal(this.tmpbuf[1]) << 8) + (JsonProtocol.Companion.hexVal(this.tmpbuf[2]) << 4) + JsonProtocol.Companion.hexVal(this.tmpbuf[3]));
                    try {
                        byte[] bytes;
                        if (Character.isHighSurrogate((char)cu)) {
                            if (codeunits.size() > 0) {
                                throw new ProtocolException("Expected low surrogate char");
                            }
                            codeunits.add(Character.valueOf((char)cu));
                            continue;
                        }
                        if (Character.isLowSurrogate((char)cu)) {
                            if (codeunits.size() == 0) {
                                throw new ProtocolException("Expected high surrogate char");
                            }
                            codeunits.add(Character.valueOf((char)cu));
                            Buffer buffer2 = new Buffer();
                            Object e = codeunits.get(0);
                            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                            Buffer buffer3 = buffer2.writeUtf8CodePoint((int)((Character)e).charValue());
                            Object e2 = codeunits.get(1);
                            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                            bytes = StringsKt.encodeToByteArray((String)buffer3.writeUtf8CodePoint((int)((Character)e2).charValue()).readUtf8());
                            buffer.write(bytes);
                            codeunits.clear();
                            continue;
                        }
                        bytes = StringsKt.encodeToByteArray((String)new Buffer().writeUtf8CodePoint((int)cu).readUtf8());
                        buffer.write(bytes);
                        continue;
                    }
                    catch (IOException ex) {
                        throw new ProtocolException("Invalid unicode sequence");
                    }
                }
                int off = StringsKt.indexOf$default((CharSequence)ESCAPE_CHARS, (char)((char)ch), (int)0, (boolean)false, (int)6, null);
                if (off == -1) {
                    throw new ProtocolException("Expected control char");
                }
                ch = ESCAPE_CHAR_VALS[off];
            }
            byte[] byArray = new byte[]{ch};
            buffer.write(byArray);
        }
        return buffer.readByteString();
    }

    private final boolean isJsonNumeric(byte b) {
        char c = (char)b;
        return (((((((((((((c == '+' ? true : c == '-') ? true : c == '.') ? true : c == '0') ? true : c == '1') ? true : c == '2') ? true : c == '3') ? true : c == '4') ? true : c == '5') ? true : c == '6') ? true : c == '7') ? true : c == '8') ? true : c == '9') ? true : c == 'E') ? true : c == 'e';
    }

    private final String readJsonNumericChars() throws IOException {
        byte ch;
        StringBuilder strbld = new StringBuilder();
        while (this.isJsonNumeric(ch = this.reader.peek())) {
            strbld.append((char)this.reader.read());
        }
        String string = strbld.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final long readJsonInteger() throws IOException {
        long l;
        this.context.read();
        if (this.context.escapeNum()) {
            this.readJsonSyntaxChar(QUOTE);
        }
        String str = this.readJsonNumericChars();
        if (this.context.escapeNum()) {
            this.readJsonSyntaxChar(QUOTE);
        }
        try {
            l = Long.parseLong(str);
        }
        catch (NumberFormatException ex) {
            throw new ProtocolException("Bad data encountered in numeric data");
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private final double readJsonDouble() throws IOException {
        double d;
        this.context.read();
        if (this.reader.peek() == QUOTE[0]) {
            void var2_3;
            ByteString str = this.readJsonString(true);
            double dub = Double.parseDouble(str.utf8());
            if (!(this.context.escapeNum() || Double.isNaN(dub) || Double.isInfinite(dub))) {
                throw new ProtocolException("Numeric data unexpectedly quoted");
            }
            d = var2_3;
        } else {
            double d2;
            if (this.context.escapeNum()) {
                this.readJsonSyntaxChar(QUOTE);
            }
            try {
                d2 = Double.parseDouble(this.readJsonNumericChars());
            }
            catch (NumberFormatException ex) {
                throw new ProtocolException("Bad data encountered in numeric data");
            }
            d = d2;
        }
        return d;
    }

    private final ByteString readJsonBase64() throws IOException {
        ByteString str = this.readJsonString(false);
        ByteString byteString = ByteString.Companion.decodeBase64(str.utf8());
        Intrinsics.checkNotNull((Object)byteString);
        return byteString;
    }

    private final void readJsonObjectStart() throws IOException {
        this.context.read();
        this.readJsonSyntaxChar(LBRACE);
        this.pushContext(new JsonPairContext());
    }

    private final void readJsonObjectEnd() throws IOException {
        this.readJsonSyntaxChar(RBRACE);
        this.popContext();
    }

    private final void readJsonArrayStart() throws IOException {
        this.context.read();
        this.readJsonSyntaxChar(LBRACKET);
        this.pushContext(new JsonListContext());
    }

    private final void readJsonArrayEnd() throws IOException {
        this.readJsonSyntaxChar(RBRACKET);
        this.popContext();
    }

    @Override
    @NotNull
    public MessageMetadata readMessageBegin() throws IOException {
        this.resetContext();
        this.readJsonArrayStart();
        if (this.readJsonInteger() != 1L) {
            throw new ProtocolException("Message contained bad version.");
        }
        String name = this.readJsonString(false).utf8();
        byte type = (byte)this.readJsonInteger();
        int seqid = (int)this.readJsonInteger();
        return new MessageMetadata(name, type, seqid);
    }

    @Override
    public void readMessageEnd() throws IOException {
        this.readJsonArrayEnd();
    }

    @Override
    @NotNull
    public StructMetadata readStructBegin() throws IOException {
        this.readJsonObjectStart();
        return new StructMetadata("");
    }

    @Override
    public void readStructEnd() throws IOException {
        this.readJsonObjectEnd();
    }

    @Override
    @NotNull
    public FieldMetadata readFieldBegin() throws IOException {
        byte ch = this.reader.peek();
        byte type = 0;
        short id = 0;
        if (ch == RBRACE[0]) {
            type = 0;
        } else {
            id = (short)this.readJsonInteger();
            this.readJsonObjectStart();
            type = JsonTypes.jsonToTtype(this.readJsonString(false).toByteArray());
        }
        return new FieldMetadata("", type, id);
    }

    @Override
    public void readFieldEnd() throws IOException {
        this.readJsonObjectEnd();
    }

    @Override
    @NotNull
    public MapMetadata readMapBegin() throws IOException {
        this.readJsonArrayStart();
        byte keyType = JsonTypes.jsonToTtype(this.readJsonString(false).toByteArray());
        byte valueType = JsonTypes.jsonToTtype(this.readJsonString(false).toByteArray());
        int size = (int)this.readJsonInteger();
        this.readJsonObjectStart();
        return new MapMetadata(keyType, valueType, size);
    }

    @Override
    public void readMapEnd() throws IOException {
        this.readJsonObjectEnd();
        this.readJsonArrayEnd();
    }

    @Override
    @NotNull
    public ListMetadata readListBegin() throws IOException {
        this.readJsonArrayStart();
        byte elemType = JsonTypes.jsonToTtype(this.readJsonString(false).toByteArray());
        int size = (int)this.readJsonInteger();
        return new ListMetadata(elemType, size);
    }

    @Override
    public void readListEnd() throws IOException {
        this.readJsonArrayEnd();
    }

    @Override
    @NotNull
    public SetMetadata readSetBegin() throws IOException {
        this.readJsonArrayStart();
        byte elemType = JsonTypes.jsonToTtype(this.readJsonString(false).toByteArray());
        int size = (int)this.readJsonInteger();
        return new SetMetadata(elemType, size);
    }

    @Override
    public void readSetEnd() throws IOException {
        this.readJsonArrayEnd();
    }

    @Override
    public boolean readBool() throws IOException {
        return this.readJsonInteger() != 0L;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readJsonInteger();
    }

    @Override
    public short readI16() throws IOException {
        return (short)this.readJsonInteger();
    }

    @Override
    public int readI32() throws IOException {
        return (int)this.readJsonInteger();
    }

    @Override
    public long readI64() throws IOException {
        return this.readJsonInteger();
    }

    @Override
    public double readDouble() throws IOException {
        return this.readJsonDouble();
    }

    @Override
    @NotNull
    public String readString() throws IOException {
        return this.readJsonString(false).utf8();
    }

    @Override
    @NotNull
    public ByteString readBinary() throws IOException {
        return this.readJsonBase64();
    }

    @JvmOverloads
    public JsonProtocol(@NotNull Transport transport2) {
        Intrinsics.checkNotNullParameter((Object)transport2, (String)"transport");
        this(transport2, false, 2, null);
    }

    static {
        byte[] byArray = new byte[]{44};
        COMMA = byArray;
        byArray = new byte[]{58};
        COLON = byArray;
        byArray = new byte[]{123};
        LBRACE = byArray;
        byArray = new byte[]{125};
        RBRACE = byArray;
        byArray = new byte[]{91};
        LBRACKET = byArray;
        byArray = new byte[]{93};
        RBRACKET = byArray;
        byArray = new byte[]{34};
        QUOTE = byArray;
        byArray = new byte[]{92};
        BACKSLASH = byArray;
        byArray = new byte[]{92, 117, 48, 48};
        ESCSEQ = byArray;
        byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 98, 116, 110, 0, 102, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 34, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        JSON_CHAR_TABLE = byArray;
        byArray = new byte[]{34, 92, 47, 8, 12, 10, 13, 9};
        ESCAPE_CHAR_VALS = byArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/bendb/thrifty/protocol/JsonProtocol$Companion;", "", "()V", "BACKSLASH", "", "COLON", "COMMA", "ESCAPE_CHARS", "", "ESCAPE_CHAR_VALS", "ESCSEQ", "JSON_CHAR_TABLE", "LBRACE", "LBRACKET", "QUOTE", "RBRACE", "RBRACKET", "VERSION", "", "hexChar", "", "value", "hexVal", "ch", "thrifty-runtime"})
    public static final class Companion {
        private Companion() {
        }

        private final byte hexVal(byte ch) throws IOException {
            byte by;
            if (ch >= 48 && ch <= 57) {
                by = (byte)((char)ch - 48);
            } else if (ch >= 97 && ch <= 102) {
                by = (byte)((char)ch - 97 + 10);
            } else {
                throw new ProtocolException("Expected hex character");
            }
            return by;
        }

        private final byte hexChar(byte value) {
            byte b = (byte)(value & 0xF);
            return b < 10 ? (byte)(b + 48) : (byte)(b - 10 + 97);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/bendb/thrifty/protocol/JsonProtocol$JsonBaseContext;", "", "()V", "escapeNum", "", "read", "", "write", "thrifty-runtime"})
    private static class JsonBaseContext {
        public void write() throws IOException {
        }

        public void read() throws IOException {
        }

        public boolean escapeNum() {
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/bendb/thrifty/protocol/JsonProtocol$JsonListContext;", "Lcom/bendb/thrifty/protocol/JsonProtocol$JsonBaseContext;", "(Lcom/bendb/thrifty/protocol/JsonProtocol;)V", "first", "", "read", "", "write", "thrifty-runtime"})
    private final class JsonListContext
    extends JsonBaseContext {
        private boolean first = true;

        @Override
        public void write() throws IOException {
            if (this.first) {
                this.first = false;
            } else {
                JsonProtocol.this.transport.write(COMMA);
            }
        }

        @Override
        public void read() throws IOException {
            if (this.first) {
                this.first = false;
            } else {
                JsonProtocol.this.readJsonSyntaxChar(COMMA);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/bendb/thrifty/protocol/JsonProtocol$JsonPairContext;", "Lcom/bendb/thrifty/protocol/JsonProtocol$JsonBaseContext;", "(Lcom/bendb/thrifty/protocol/JsonProtocol;)V", "colon", "", "first", "escapeNum", "read", "", "write", "thrifty-runtime"})
    private final class JsonPairContext
    extends JsonBaseContext {
        private boolean first = true;
        private boolean colon = true;

        @Override
        public void write() throws IOException {
            if (this.first) {
                this.first = false;
                this.colon = true;
            } else {
                JsonProtocol.this.transport.write(this.colon ? COLON : COMMA);
                this.colon = !this.colon;
            }
        }

        @Override
        public void read() throws IOException {
            if (this.first) {
                this.first = false;
                this.colon = true;
            } else {
                JsonProtocol.this.readJsonSyntaxChar(this.colon ? COLON : COMMA);
                this.colon = !this.colon;
            }
        }

        @Override
        public boolean escapeNum() {
            return this.colon;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u0005\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0010H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/bendb/thrifty/protocol/JsonProtocol$JsonTypes;", "", "()V", "BOOLEAN", "", "BYTE", "DOUBLE", "I16", "I32", "I64", "LIST", "MAP", "SET", "STRING", "STRUCT", "jsonToTtype", "", "jsonId", "ttypeToJson", "typeId", "thrifty-runtime"})
    @SourceDebugExtension(value={"SMAP\nJsonProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonProtocol.kt\ncom/bendb/thrifty/protocol/JsonProtocol$JsonTypes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,852:1\n1#2:853\n*E\n"})
    private static final class JsonTypes {
        @NotNull
        public static final JsonTypes INSTANCE = new JsonTypes();
        @JvmField
        @NotNull
        public static final byte[] BOOLEAN;
        @JvmField
        @NotNull
        public static final byte[] BYTE;
        @JvmField
        @NotNull
        public static final byte[] I16;
        @JvmField
        @NotNull
        public static final byte[] I32;
        @JvmField
        @NotNull
        public static final byte[] I64;
        @JvmField
        @NotNull
        public static final byte[] DOUBLE;
        @JvmField
        @NotNull
        public static final byte[] STRUCT;
        @JvmField
        @NotNull
        public static final byte[] STRING;
        @JvmField
        @NotNull
        public static final byte[] MAP;
        @JvmField
        @NotNull
        public static final byte[] LIST;
        @JvmField
        @NotNull
        public static final byte[] SET;

        private JsonTypes() {
        }

        @JvmStatic
        @NotNull
        public static final byte[] ttypeToJson(byte typeId) {
            byte[] byArray;
            byte by = typeId;
            if (by == 0) {
                throw new IllegalArgumentException("Unexpected STOP type");
            }
            if (by == 1) {
                throw new IllegalArgumentException("Unexpected VOID type");
            }
            if (by == 2) {
                byArray = BOOLEAN;
            } else if (by == 3) {
                byArray = BYTE;
            } else if (by == 4) {
                byArray = DOUBLE;
            } else if (by == 6) {
                byArray = I16;
            } else if (by == 8) {
                byArray = I32;
            } else if (by == 10) {
                byArray = I64;
            } else if (by == 11) {
                byArray = STRING;
            } else if (by == 12) {
                byArray = STRUCT;
            } else if (by == 13) {
                byArray = MAP;
            } else if (by == 14) {
                byArray = SET;
            } else if (by == 15) {
                byArray = LIST;
            } else {
                throw new IllegalArgumentException("Unknown TType ID: " + typeId);
            }
            return byArray;
        }

        @JvmStatic
        public static final byte jsonToTtype(@NotNull byte[] jsonId) {
            Intrinsics.checkNotNullParameter((Object)jsonId, (String)"jsonId");
            int result = 0;
            if (jsonId.length > 1) {
                char c = (char)jsonId[0];
                if (c == 'd') {
                    result = 4;
                } else if (c == 'i') {
                    char c2 = (char)jsonId[1];
                    if (c2 == '8') {
                        result = 3;
                    } else if (c2 == '1') {
                        result = 6;
                    } else if (c2 == '3') {
                        result = 8;
                    } else if (c2 == '6') {
                        result = 10;
                    }
                } else if (c == 'l') {
                    result = 15;
                } else if (c == 'm') {
                    result = 13;
                } else if (c == 'r') {
                    result = 12;
                } else if (c == 's') {
                    result = jsonId[1] == 116 ? 11 : 14;
                } else if (c == 't') {
                    result = 2;
                }
            }
            if (!(result != 0)) {
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("Unknown json type ID: ");
                String string = Arrays.toString(jsonId);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
                String string2 = stringBuilder.append(string).toString();
                throw new IllegalArgumentException(string2.toString());
            }
            return (byte)result;
        }

        static {
            byte[] byArray = new byte[]{116, 102};
            BOOLEAN = byArray;
            byArray = new byte[]{105, 56};
            BYTE = byArray;
            byArray = new byte[]{105, 49, 54};
            I16 = byArray;
            byArray = new byte[]{105, 51, 50};
            I32 = byArray;
            byArray = new byte[]{105, 54, 52};
            I64 = byArray;
            byArray = new byte[]{100, 98, 108};
            DOUBLE = byArray;
            byArray = new byte[]{114, 101, 99};
            STRUCT = byArray;
            byArray = new byte[]{115, 116, 114};
            STRING = byArray;
            byArray = new byte[]{109, 97, 112};
            MAP = byArray;
            byArray = new byte[]{108, 115, 116};
            LIST = byArray;
            byArray = new byte[]{115, 101, 116};
            SET = byArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/bendb/thrifty/protocol/JsonProtocol$LookaheadReader;", "", "(Lcom/bendb/thrifty/protocol/JsonProtocol;)V", "data", "", "hasData", "", "peek", "", "read", "thrifty-runtime"})
    private final class LookaheadReader {
        private boolean hasData;
        @NotNull
        private final byte[] data = new byte[1];

        public final byte read() throws IOException {
            if (this.hasData) {
                this.hasData = false;
            } else {
                JsonProtocol.this.transport.read(this.data, 0, 1);
            }
            return this.data[0];
        }

        public final byte peek() throws IOException {
            if (!this.hasData) {
                JsonProtocol.this.transport.read(this.data, 0, 1);
            }
            this.hasData = true;
            return this.data[0];
        }
    }
}

