/*
 * Decompiled with CFR 0.152.
 */
package com.bendb.thrifty.service;

import com.bendb.thrifty.Struct;
import com.bendb.thrifty.ThriftException;
import com.bendb.thrifty.protocol.Protocol;
import com.bendb.thrifty.service.ClientBase;
import com.bendb.thrifty.service.MethodCall;
import com.bendb.thrifty.service.ServiceMethodCallback;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB\u0017\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00112\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u00112\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\rH\u0004J\u001c\u0010\u001a\u001a\u00020\u00112\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/bendb/thrifty/service/AsyncClientBase;", "Lcom/bendb/thrifty/service/ClientBase;", "Ljava/io/Closeable;", "protocol", "Lcom/bendb/thrifty/protocol/Protocol;", "listener", "Lcom/bendb/thrifty/service/AsyncClientBase$Listener;", "(Lcom/bendb/thrifty/protocol/Protocol;Lcom/bendb/thrifty/service/AsyncClientBase$Listener;)V", "callbackExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "pendingCalls", "Ljava/util/concurrent/BlockingQueue;", "Lcom/bendb/thrifty/service/MethodCall;", "workerThread", "Lcom/bendb/thrifty/service/AsyncClientBase$WorkerThread;", "close", "", "error", "", "complete", "call", "result", "", "enqueue", "methodCall", "fail", "Listener", "WorkerThread", "thrifty-runtime"})
@SourceDebugExtension(value={"SMAP\nAsyncClientBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncClientBase.kt\ncom/bendb/thrifty/service/AsyncClientBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1#2:232\n*E\n"})
public class AsyncClientBase
extends ClientBase
implements Closeable {
    @NotNull
    private final Listener listener;
    private final ExecutorService callbackExecutor;
    @NotNull
    private final BlockingQueue<MethodCall<?>> pendingCalls;
    @NotNull
    private final WorkerThread workerThread;

    protected AsyncClientBase(@NotNull Protocol protocol, @NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        super(protocol);
        this.listener = listener;
        this.callbackExecutor = Executors.newSingleThreadExecutor();
        this.pendingCalls = new LinkedBlockingQueue();
        this.workerThread = new WorkerThread();
        this.workerThread.setDaemon(true);
        this.workerThread.start();
    }

    protected final void enqueue(@NotNull MethodCall<?> methodCall) {
        Intrinsics.checkNotNullParameter(methodCall, (String)"methodCall");
        if (!this.getRunning().get()) {
            boolean $i$a$-check-AsyncClientBase$enqueue$32 = false;
            String $i$a$-check-AsyncClientBase$enqueue$32 = "Cannot write to a closed service client";
            throw new IllegalStateException($i$a$-check-AsyncClientBase$enqueue$32.toString());
        }
        if (!this.pendingCalls.offer(methodCall)) {
            boolean bl = false;
            String string = "Call queue is full";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public void close() throws IOException {
        this.close(null);
    }

    private final void close(Throwable error) {
        if (!this.getRunning().compareAndSet(true, false)) {
            return;
        }
        this.workerThread.interrupt();
        this.closeProtocol();
        if (!this.pendingCalls.isEmpty()) {
            List incompleteCalls = new ArrayList();
            this.pendingCalls.drainTo(incompleteCalls);
            CancellationException e = new CancellationException();
            for (MethodCall call : incompleteCalls) {
                try {
                    this.fail(call, e);
                }
                catch (Exception exception) {}
            }
        }
        this.callbackExecutor.execute(() -> AsyncClientBase.close$lambda$2(error, this));
        try {
            this.callbackExecutor.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void complete(MethodCall<?> call, Object result) {
        this.callbackExecutor.execute(() -> AsyncClientBase.complete$lambda$3(call, result));
    }

    private final void fail(MethodCall<?> call, Throwable error) {
        this.callbackExecutor.execute(() -> AsyncClientBase.fail$lambda$4(call, error));
    }

    private static final void close$lambda$2(Throwable $error, AsyncClientBase this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($error != null) {
            this$0.listener.onError($error);
        } else {
            this$0.listener.onTransportClosed();
        }
    }

    private static final void complete$lambda$3(MethodCall $call, Object $result) {
        Intrinsics.checkNotNullParameter((Object)$call, (String)"$call");
        ServiceMethodCallback<Object> serviceMethodCallback = $call.callback;
        Intrinsics.checkNotNull(serviceMethodCallback, (String)"null cannot be cast to non-null type com.bendb.thrifty.service.ServiceMethodCallback<kotlin.Any?>");
        serviceMethodCallback.onSuccess($result);
    }

    private static final void fail$lambda$4(MethodCall $call, Throwable $error) {
        Intrinsics.checkNotNullParameter((Object)$call, (String)"$call");
        Intrinsics.checkNotNullParameter((Object)$error, (String)"$error");
        ServiceMethodCallback serviceMethodCallback = $call.callback;
        Intrinsics.checkNotNull(serviceMethodCallback);
        serviceMethodCallback.onError($error);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/bendb/thrifty/service/AsyncClientBase$Listener;", "", "onError", "", "error", "", "onTransportClosed", "thrifty-runtime"})
    public static interface Listener {
        public void onTransportClosed();

        public void onError(@NotNull Throwable var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/bendb/thrifty/service/AsyncClientBase$WorkerThread;", "Ljava/lang/Thread;", "(Lcom/bendb/thrifty/service/AsyncClientBase;)V", "invokeRequest", "", "run", "thrifty-runtime"})
    private final class WorkerThread
    extends Thread {
        @Override
        public void run() {
            Throwable error = null;
            while (AsyncClientBase.this.getRunning().get()) {
                try {
                    this.invokeRequest();
                }
                catch (Throwable e) {
                    error = e;
                    break;
                }
            }
            try {
                AsyncClientBase.this.close(error);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private final void invokeRequest() throws ThriftException, IOException, InterruptedException {
            MethodCall call = (MethodCall)AsyncClientBase.this.pendingCalls.take();
            if (!AsyncClientBase.this.getRunning().get()) {
                Intrinsics.checkNotNull((Object)call);
                AsyncClientBase.this.fail(call, new CancellationException());
                return;
            }
            Object result = null;
            Exception error = null;
            try {
                Intrinsics.checkNotNull((Object)call);
                result = AsyncClientBase.this.invokeRequest(call);
            }
            catch (IOException e) {
                Intrinsics.checkNotNull((Object)call);
                AsyncClientBase.this.fail(call, e);
                throw e;
            }
            catch (RuntimeException e) {
                Intrinsics.checkNotNull((Object)call);
                AsyncClientBase.this.fail(call, e);
                throw e;
            }
            catch (ClientBase.ServerException e) {
                error = e.getThriftException();
            }
            catch (Exception e) {
                if (!(e instanceof Struct)) {
                    throw new AssertionError("Unexpected exception", e);
                }
                error = e;
            }
            try {
                if (error != null) {
                    Intrinsics.checkNotNull((Object)call);
                    AsyncClientBase.this.fail(call, error);
                } else {
                    Intrinsics.checkNotNull((Object)call);
                    AsyncClientBase.this.complete(call, result);
                }
            }
            catch (RejectedExecutionException e) {
                if (error != null) {
                    ServiceMethodCallback serviceMethodCallback = call.callback;
                    Intrinsics.checkNotNull(serviceMethodCallback);
                    serviceMethodCallback.onError(error);
                }
                ServiceMethodCallback<Object> serviceMethodCallback = call.callback;
                Intrinsics.checkNotNull(serviceMethodCallback, (String)"null cannot be cast to non-null type com.bendb.thrifty.service.ServiceMethodCallback<kotlin.Any?>");
                serviceMethodCallback.onSuccess(result);
            }
        }
    }
}

