/*
 * Decompiled with CFR 0.152.
 */
package com.bendb.thrifty.service;

import com.bendb.thrifty.Struct;
import com.bendb.thrifty.ThriftException;
import com.bendb.thrifty.protocol.MessageMetadata;
import com.bendb.thrifty.protocol.Protocol;
import com.bendb.thrifty.service.MethodCall;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0001\u0017B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u000fJ\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0004J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00122\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/bendb/thrifty/service/ClientBase;", "Ljava/io/Closeable;", "Lokio/Closeable;", "protocol", "Lcom/bendb/thrifty/protocol/Protocol;", "(Lcom/bendb/thrifty/protocol/Protocol;)V", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "Lcom/bendb/thrifty/internal/AtomicBoolean;", "getRunning", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "seqId", "Ljava/util/concurrent/atomic/AtomicInteger;", "Lcom/bendb/thrifty/internal/AtomicInteger;", "close", "", "closeProtocol", "execute", "", "methodCall", "Lcom/bendb/thrifty/service/MethodCall;", "invokeRequest", "call", "ServerException", "thrifty-runtime"})
@SourceDebugExtension(value={"SMAP\nClientBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientBase.kt\ncom/bendb/thrifty/service/ClientBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
public class ClientBase
implements Closeable {
    @NotNull
    private final Protocol protocol;
    @NotNull
    private final AtomicInteger seqId;
    @NotNull
    private final AtomicBoolean running;

    protected ClientBase(@NotNull Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        this.protocol = protocol;
        this.seqId = new AtomicInteger(0);
        this.running = new AtomicBoolean(true);
    }

    @NotNull
    public final AtomicBoolean getRunning() {
        return this.running;
    }

    @Nullable
    protected final Object execute(@NotNull MethodCall<?> methodCall) throws Exception {
        Object object;
        Intrinsics.checkNotNullParameter(methodCall, (String)"methodCall");
        if (!this.running.get()) {
            boolean $i$a$-check-ClientBase$execute$22 = false;
            String $i$a$-check-ClientBase$execute$22 = "Cannot write to a closed service client";
            throw new IllegalStateException($i$a$-check-ClientBase$execute$22.toString());
        }
        try {
            object = this.invokeRequest(methodCall);
        }
        catch (ServerException e) {
            throw e.getThriftException();
        }
        return object;
    }

    @Override
    public void close() throws IOException {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        this.closeProtocol();
    }

    public final void closeProtocol() {
        try {
            this.protocol.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    public final Object invokeRequest(@NotNull MethodCall<?> call) throws Exception {
        Object obj;
        Intrinsics.checkNotNullParameter(call, (String)"call");
        boolean isOneWay = call.callTypeId == 4;
        int sid = this.seqId.incrementAndGet();
        this.protocol.writeMessageBegin(call.name, call.callTypeId, sid);
        call.send(this.protocol);
        this.protocol.writeMessageEnd();
        this.protocol.flush();
        if (isOneWay) {
            return Unit.INSTANCE;
        }
        MessageMetadata metadata = this.protocol.readMessageBegin();
        if (metadata.seqId != sid) {
            throw new ThriftException(ThriftException.Kind.BAD_SEQUENCE_ID, "Unrecognized sequence ID");
        }
        if (metadata.type == 3) {
            ThriftException e = ThriftException.Companion.read(this.protocol);
            this.protocol.readMessageEnd();
            throw new ServerException(e);
        }
        if (metadata.type != 2) {
            throw new ThriftException(ThriftException.Kind.INVALID_MESSAGE_TYPE, "Invalid message type: " + metadata.type);
        }
        if (metadata.seqId != this.seqId.get()) {
            throw new ThriftException(ThriftException.Kind.BAD_SEQUENCE_ID, "Out-of-order response");
        }
        if (!Intrinsics.areEqual((Object)metadata.name, (Object)call.name)) {
            throw new ThriftException(ThriftException.Kind.WRONG_METHOD_NAME, "Unexpected method name in reply; expected " + call.name + " but received " + metadata.name);
        }
        try {
            Object result = call.receive(this.protocol, metadata);
            this.protocol.readMessageEnd();
            obj = result;
        }
        catch (Exception e) {
            if (e instanceof Struct) {
                this.protocol.readMessageEnd();
            }
            throw e;
        }
        return obj;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/bendb/thrifty/service/ClientBase$ServerException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "thriftException", "Lcom/bendb/thrifty/ThriftException;", "(Lcom/bendb/thrifty/ThriftException;)V", "getThriftException", "()Lcom/bendb/thrifty/ThriftException;", "thrifty-runtime"})
    public static final class ServerException
    extends Exception {
        @NotNull
        private final ThriftException thriftException;

        public ServerException(@NotNull ThriftException thriftException) {
            Intrinsics.checkNotNullParameter((Object)thriftException, (String)"thriftException");
            this.thriftException = thriftException;
        }

        @NotNull
        public final ThriftException getThriftException() {
            return this.thriftException;
        }
    }
}

