/*
 * Decompiled with CFR 0.152.
 */
package com.bendb.thrifty.transport;

import com.bendb.thrifty.transport.Transport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001!B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0018J\b\u0010\u001a\u001a\u00020\u0018H\u0016J \u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J \u0010 \u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/bendb/thrifty/transport/SocketTransport;", "Lcom/bendb/thrifty/transport/Transport;", "builder", "Lcom/bendb/thrifty/transport/SocketTransport$Builder;", "(Lcom/bendb/thrifty/transport/SocketTransport$Builder;)V", "connectTimeout", "", "host", "", "inputStream", "Ljava/io/InputStream;", "isConnected", "", "()Z", "outputStream", "Ljava/io/OutputStream;", "port", "readTimeout", "socket", "Ljava/net/Socket;", "socketFactory", "Ljavax/net/SocketFactory;", "kotlin.jvm.PlatformType", "close", "", "connect", "flush", "read", "buffer", "", "offset", "count", "write", "Builder", "thrifty-runtime"})
public final class SocketTransport
implements Transport {
    @NotNull
    private final String host;
    private final int port;
    private final int readTimeout;
    private final int connectTimeout;
    private final SocketFactory socketFactory;
    @Nullable
    private Socket socket;
    @Nullable
    private InputStream inputStream;
    @Nullable
    private OutputStream outputStream;

    public SocketTransport(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.host = builder.getHost$thrifty_runtime();
        this.port = builder.getPort$thrifty_runtime();
        this.readTimeout = builder.getReadTimeout$thrifty_runtime();
        this.connectTimeout = builder.getConnectTimeout$thrifty_runtime();
        SocketFactory socketFactory = builder.getSocketFactory$thrifty_runtime();
        if (socketFactory == null) {
            socketFactory = SocketFactory.getDefault();
        }
        this.socketFactory = socketFactory;
    }

    public final boolean isConnected() {
        Socket s = this.socket;
        return s != null && s.isConnected() && !s.isClosed();
    }

    @Override
    public int read(@NotNull byte[] buffer, int offset, int count) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        InputStream inputStream = this.inputStream;
        Intrinsics.checkNotNull((Object)inputStream);
        return inputStream.read(buffer, offset, count);
    }

    @Override
    public void write(@NotNull byte[] buffer, int offset, int count) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        OutputStream outputStream = this.outputStream;
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.write(buffer, offset, count);
    }

    @Override
    public void flush() throws IOException {
        OutputStream outputStream = this.outputStream;
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.flush();
    }

    public final void connect() throws IOException {
        if (this.socket == null) {
            this.socket = this.socketFactory.createSocket();
        }
        Socket socket = this.socket;
        Intrinsics.checkNotNull((Object)socket);
        socket.setTcpNoDelay(true);
        Socket socket2 = this.socket;
        Intrinsics.checkNotNull((Object)socket2);
        socket2.setSoLinger(false, 0);
        Socket socket3 = this.socket;
        Intrinsics.checkNotNull((Object)socket3);
        socket3.setKeepAlive(true);
        Socket socket4 = this.socket;
        Intrinsics.checkNotNull((Object)socket4);
        socket4.setSoTimeout(this.readTimeout);
        Socket socket5 = this.socket;
        Intrinsics.checkNotNull((Object)socket5);
        socket5.connect(new InetSocketAddress(this.host, this.port), this.connectTimeout);
        Socket socket6 = this.socket;
        Intrinsics.checkNotNull((Object)socket6);
        this.inputStream = socket6.getInputStream();
        Socket socket7 = this.socket;
        Intrinsics.checkNotNull((Object)socket7);
        this.outputStream = socket7.getOutputStream();
    }

    @Override
    public void close() {
        Socket socket = this.socket;
        InputStream input = this.inputStream;
        OutputStream output = this.outputStream;
        this.socket = null;
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u001a\u0010\u0007\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u001a\u0010\u000f\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lcom/bendb/thrifty/transport/SocketTransport$Builder;", "", "host", "", "port", "", "(Ljava/lang/String;I)V", "connectTimeout", "getConnectTimeout$thrifty_runtime", "()I", "setConnectTimeout$thrifty_runtime", "(I)V", "getHost$thrifty_runtime", "()Ljava/lang/String;", "getPort$thrifty_runtime", "readTimeout", "getReadTimeout$thrifty_runtime", "setReadTimeout$thrifty_runtime", "socketFactory", "Ljavax/net/SocketFactory;", "getSocketFactory$thrifty_runtime", "()Ljavax/net/SocketFactory;", "setSocketFactory$thrifty_runtime", "(Ljavax/net/SocketFactory;)V", "build", "Lcom/bendb/thrifty/transport/SocketTransport;", "thrifty-runtime"})
    @SourceDebugExtension(value={"SMAP\nSocketTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketTransport.kt\ncom/bendb/thrifty/transport/SocketTransport$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1#2:141\n*E\n"})
    public static final class Builder {
        @NotNull
        private final String host;
        private final int port;
        private int readTimeout;
        private int connectTimeout;
        @Nullable
        private SocketFactory socketFactory;

        public Builder(@NotNull String host, int port) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            if (!(!StringsKt.isBlank((CharSequence)host))) {
                boolean $i$a$-require-SocketTransport$Builder$32 = false;
                String $i$a$-require-SocketTransport$Builder$32 = "host must not be null or empty";
                throw new IllegalArgumentException($i$a$-require-SocketTransport$Builder$32.toString());
            }
            if (!(0 <= port ? port < 65536 : false)) {
                boolean bl = false;
                String string = "Invalid port number: " + port;
                throw new IllegalArgumentException(string.toString());
            }
            this.host = host;
            this.port = port;
        }

        @NotNull
        public final String getHost$thrifty_runtime() {
            return this.host;
        }

        public final int getPort$thrifty_runtime() {
            return this.port;
        }

        public final int getReadTimeout$thrifty_runtime() {
            return this.readTimeout;
        }

        public final void setReadTimeout$thrifty_runtime(int n) {
            this.readTimeout = n;
        }

        public final int getConnectTimeout$thrifty_runtime() {
            return this.connectTimeout;
        }

        public final void setConnectTimeout$thrifty_runtime(int n) {
            this.connectTimeout = n;
        }

        @Nullable
        public final SocketFactory getSocketFactory$thrifty_runtime() {
            return this.socketFactory;
        }

        public final void setSocketFactory$thrifty_runtime(@Nullable SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
        }

        @NotNull
        public final Builder readTimeout(int readTimeout) {
            if (!(readTimeout >= 0)) {
                boolean bl = false;
                String string = "readTimeout cannot be negative";
                throw new IllegalArgumentException(string.toString());
            }
            this.readTimeout = readTimeout;
            return this;
        }

        @NotNull
        public final Builder connectTimeout(int connectTimeout) {
            if (!(connectTimeout >= 0)) {
                boolean bl = false;
                String string = "connectTimeout cannot be negative";
                throw new IllegalArgumentException(string.toString());
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        @NotNull
        public final Builder socketFactory(@Nullable SocketFactory socketFactory) {
            SocketFactory socketFactory2 = socketFactory;
            if (socketFactory2 == null) {
                Builder builder = this;
                boolean bl = false;
                Builder builder2 = builder;
                String string = "socketFactory";
                throw new IllegalArgumentException(string.toString());
            }
            this.socketFactory = socketFactory2;
            return this;
        }

        @NotNull
        public final SocketTransport build() {
            return new SocketTransport(this);
        }
    }
}

