/*
 * Decompiled with CFR 0.152.
 */
package com.benoitquenaudon.rxdatabinding.databinding;

import android.databinding.Observable;
import android.databinding.ObservableField;
import com.benoitquenaudon.rxdatabinding.internal.Preconditions;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class ObservableFieldObservable<T>
extends io.reactivex.Observable<T> {
    private final ObservableField<T> observableField;

    ObservableFieldObservable(ObservableField<T> observableField) {
        this.observableField = observableField;
    }

    protected void subscribeActual(Observer<? super T> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.observableField, observer);
        observer.onSubscribe((Disposable)listener);
        this.observableField.addOnPropertyChangedCallback(listener.onPropertyChangedCallback);
    }

    private final class Listener
    extends MainThreadDisposable {
        final Observable.OnPropertyChangedCallback onPropertyChangedCallback;
        private final ObservableField<T> observableField;

        Listener(ObservableField<T> observableField, final Observer<? super T> observer) {
            this.observableField = observableField;
            this.onPropertyChangedCallback = new Observable.OnPropertyChangedCallback(){

                public void onPropertyChanged(Observable observable, int ignoredPropertyId) {
                    if (!Listener.this.isDisposed()) {
                        ObservableField observableField = Listener.this.convert(observable);
                        observer.onNext(observableField.get());
                    }
                }
            };
        }

        ObservableField<T> convert(Observable observable) {
            return (ObservableField)this.observableField.getClass().cast(observable);
        }

        protected void onDispose() {
            this.observableField.removeOnPropertyChangedCallback(this.onPropertyChangedCallback);
        }
    }
}

