/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj;

import com.beowulfchain.beowulfj.base.models.Block;
import com.beowulfchain.beowulfj.base.models.FutureExtensions;
import com.beowulfchain.beowulfj.base.models.ScheduledHardfork;
import com.beowulfchain.beowulfj.chain.CompletedTransaction;
import com.beowulfchain.beowulfj.chain.SignedTransaction;
import com.beowulfchain.beowulfj.communication.CommunicationHandler;
import com.beowulfchain.beowulfj.configuration.BeowulfJConfig;
import com.beowulfchain.beowulfj.enums.PrivateKeyType;
import com.beowulfchain.beowulfj.exceptions.BeowulfCommunicationException;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.exceptions.BeowulfResponseException;
import com.beowulfchain.beowulfj.plugins.apis.condenser.CondenserApi;
import com.beowulfchain.beowulfj.plugins.apis.condenser.models.AccountHistoryReturn;
import com.beowulfchain.beowulfj.plugins.apis.condenser.models.ExtendedAccount;
import com.beowulfchain.beowulfj.plugins.apis.condenser.models.FindSmtTokenByName;
import com.beowulfchain.beowulfj.plugins.apis.database.DatabaseApi;
import com.beowulfchain.beowulfj.plugins.apis.database.models.Config;
import com.beowulfchain.beowulfj.plugins.apis.database.models.DynamicGlobalProperty;
import com.beowulfchain.beowulfj.plugins.apis.database.models.Supernode;
import com.beowulfchain.beowulfj.plugins.apis.database.models.SupernodeSchedule;
import com.beowulfchain.beowulfj.plugins.apis.network.broadcast.models.BroadcastTransactionSynchronousReturn;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.protocol.Asset;
import com.beowulfchain.beowulfj.protocol.AssetInfo;
import com.beowulfchain.beowulfj.protocol.Authority;
import com.beowulfchain.beowulfj.protocol.BlockHeader;
import com.beowulfchain.beowulfj.protocol.Price;
import com.beowulfchain.beowulfj.protocol.PublicKey;
import com.beowulfchain.beowulfj.protocol.SignedBlock;
import com.beowulfchain.beowulfj.protocol.TransactionId;
import com.beowulfchain.beowulfj.protocol.enums.AssetSymbolType;
import com.beowulfchain.beowulfj.protocol.operations.AccountCreateOperation;
import com.beowulfchain.beowulfj.protocol.operations.Operation;
import com.beowulfchain.beowulfj.protocol.operations.SmtCreateOperation;
import com.beowulfchain.beowulfj.protocol.operations.TransferOperation;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import eu.bittrade.crypto.core.ECKey;
import eu.bittrade.crypto.core.Sha256Hash;
import java.security.InvalidParameterException;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.joou.UInteger;
import org.joou.ULong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeowulfJ {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeowulfJ.class);
    private static final String NO_DEFAULT_ACCOUNT_ERROR_MESSAGE = "You try to use a simplified operation without having a default account configured in BeowulfJConfig. Please configure a default account or use another method.";
    private static BeowulfJ beowulfJ;
    private CommunicationHandler communicationHandler = new CommunicationHandler();

    private BeowulfJ() throws BeowulfCommunicationException {
    }

    public static BeowulfJ getInstance() throws BeowulfCommunicationException {
        if (beowulfJ == null) {
            beowulfJ = new BeowulfJ();
        }
        return beowulfJ;
    }

    public static BeowulfJ getNewInstance() throws BeowulfCommunicationException {
        beowulfJ = new BeowulfJ();
        return beowulfJ;
    }

    public static Asset beowulfToWd(Price price, Asset beowulfAsset) {
        if (beowulfAsset == null || !beowulfAsset.getName().equals((Object)AssetSymbolType.BWF)) {
            throw new InvalidParameterException("The asset needs be of SymbolType BWF.");
        }
        if (price == null) {
            return new Asset(0L, AssetSymbolType.W);
        }
        return price.multiply(beowulfAsset);
    }

    public static Asset wdToBeowulf(Price price, Asset wdAsset) {
        if (wdAsset == null || !wdAsset.getName().equals((Object)AssetSymbolType.W)) {
            throw new InvalidParameterException("The asset needs be of SymbolType BWF.");
        }
        if (price == null) {
            return new Asset(0L, AssetSymbolType.BWF);
        }
        return price.multiply(wdAsset);
    }

    public static ImmutablePair<PublicKey, String> getPrivateKeyFromPassword(AccountName account, PrivateKeyType role, String beowulfPassword) {
        String seed = account.getName() + role.name().toLowerCase() + beowulfPassword;
        ECKey keyPair = ECKey.fromPrivate((byte[])Sha256Hash.hash((byte[])seed.getBytes(), (int)0, (int)seed.length()));
        return new ImmutablePair((Object)new PublicKey(keyPair), (Object)BeowulfJUtils.privateKeyToWIF(keyPair));
    }

    public List<String> getKeyReferences(List<PublicKey> publicKeys) throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getKeyReferences(this.communicationHandler, publicKeys);
    }

    @Deprecated
    public List<AccountHistoryReturn> getAccountHistory(AccountName accountName, ULong start, UInteger limit) throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getAccountHistory(this.communicationHandler, accountName.getName(), start.longValue(), limit.longValue());
    }

    public Block getBlock(long blockNumber) throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getBlock(this.communicationHandler, blockNumber);
    }

    public BlockHeader getBlockHeader(long blockNumber) throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getBlockHeader(this.communicationHandler, blockNumber);
    }

    public TransactionId broadcastTransaction(SignedTransaction transaction) throws BeowulfCommunicationException, BeowulfResponseException, BeowulfInvalidTransactionException {
        return CondenserApi.broadcastTransaction(this.communicationHandler, transaction);
    }

    public BroadcastTransactionSynchronousReturn broadcastTransactionSynchronous(SignedTransaction transaction) throws BeowulfCommunicationException, BeowulfResponseException, BeowulfInvalidTransactionException {
        return CondenserApi.broadcastTransactionSynchronous(this.communicationHandler, transaction);
    }

    public void broadcastBlock(SignedBlock signedBlock) throws BeowulfCommunicationException, BeowulfResponseException {
        CondenserApi.broadcastBlock(this.communicationHandler, signedBlock);
    }

    public List<AccountName> getActiveSupernodes() throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getActiveSuperNodes(this.communicationHandler);
    }

    public DynamicGlobalProperty getDynamicGlobalProperties() throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getDynamicGlobalProperties(this.communicationHandler);
    }

    public Config getConfig() throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getConfig(this.communicationHandler);
    }

    public long getAccountCount() throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getAccountCount(this.communicationHandler).longValue();
    }

    public List<ExtendedAccount> getAccounts(List<AccountName> accountNames) throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getExtAccounts(this.communicationHandler, accountNames);
    }

    public Asset getBalance(AccountName accountName, AssetInfo assetInfo) throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getBalance(this.communicationHandler, accountName.getName(), assetInfo);
    }

    public ScheduledHardfork getNextScheduledHarfork() throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getNextScheduleHardfork(this.communicationHandler);
    }

    public String getTransactionHex(SignedTransaction signedTransaction) throws BeowulfCommunicationException, BeowulfResponseException, BeowulfInvalidTransactionException {
        if (BeowulfJConfig.getInstance().getDefaultAccount().isEmpty()) {
            throw new InvalidParameterException(NO_DEFAULT_ACCOUNT_ERROR_MESSAGE);
        }
        String result = CondenserApi.getTransactionHex(this.communicationHandler, signedTransaction);
        return result;
    }

    public CompletedTransaction getTransactionDetail(String trx_id) throws BeowulfCommunicationException, BeowulfResponseException {
        if (BeowulfJConfig.getInstance().getDefaultAccount().isEmpty()) {
            throw new InvalidParameterException(NO_DEFAULT_ACCOUNT_ERROR_MESSAGE);
        }
        CompletedTransaction result = CondenserApi.getTransactionDetail(this.communicationHandler, trx_id);
        return result;
    }

    public Supernode getSupernodeByAccount(AccountName supernodeName) throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getSupernodeByAccount(this.communicationHandler, supernodeName);
    }

    public List<Supernode> getSupernodesByVote(AccountName supernodeName, int limit, int vestingShare) throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getSupernodesByVote(this.communicationHandler, supernodeName, limit, vestingShare);
    }

    public int getSupernodeCount() throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getSupernodeCount(this.communicationHandler);
    }

    public List<Supernode> getSupernodes() throws BeowulfCommunicationException, BeowulfResponseException {
        return null;
    }

    public SupernodeSchedule getSupernodeSchedule() throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.getSupernodeSchedule(this.communicationHandler);
    }

    public List<String> lookupAccounts(String pattern, int limit) throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.lookupAccounts(this.communicationHandler, pattern, limit);
    }

    public List<String> lookupSupernodeAccounts(String pattern, int limit) throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.lookupSupernodeAccounts(this.communicationHandler, pattern, limit);
    }

    public boolean verifyAuthority(SignedTransaction signedTransaction) throws BeowulfCommunicationException, BeowulfResponseException {
        return DatabaseApi.verifyAccountAuthority(this.communicationHandler, null).isValid();
    }

    public TransferOperation transfer(AccountName from, AccountName to, Asset amount, Asset fee, String memo) {
        TransferOperation transferOperation = new TransferOperation(from, to, amount, fee, memo);
        return transferOperation;
    }

    public List<FindSmtTokenByName> findSmtTokenByName(List<String> names) throws BeowulfCommunicationException, BeowulfResponseException {
        return CondenserApi.findSmtTokenByName(this.communicationHandler, names);
    }

    public SmtCreateOperation smtCreate(AccountName controlAccount, AccountName creator, AssetInfo assetInfo, Asset smtCreationFee, long maxSupply) {
        UInteger precision = assetInfo.getDecimals();
        SmtCreateOperation smtCreateOperation = new SmtCreateOperation(controlAccount, creator, assetInfo, smtCreationFee, precision, null, maxSupply);
        return smtCreateOperation;
    }

    public AccountCreateOperation createAccount(AccountName creator, Asset fee, AccountName newAccount, Authority owner, String jsonMetadata) {
        AccountCreateOperation accountCreateOperation = new AccountCreateOperation(creator, fee, newAccount, owner, jsonMetadata);
        return accountCreateOperation;
    }

    public BroadcastTransactionSynchronousReturn signAndBroadcastSynchronous(List<Operation> operations) throws BeowulfCommunicationException, BeowulfResponseException, BeowulfInvalidTransactionException {
        SignedTransaction signedTransaction = this.signTransaction(operations, null);
        return this.broadcastTransactionSynchronous(signedTransaction);
    }

    public TransactionId signAndBroadcast(List<Operation> operations) throws BeowulfCommunicationException, BeowulfResponseException, BeowulfInvalidTransactionException {
        SignedTransaction signedTransaction = this.signTransaction(operations, null);
        return this.broadcastTransaction(signedTransaction);
    }

    private SignedTransaction signTransaction(List<Operation> operations, List<FutureExtensions> extensions) throws BeowulfCommunicationException, BeowulfResponseException {
        DynamicGlobalProperty globalProperties = this.getDynamicGlobalProperties();
        return new SignedTransaction(globalProperties.getHeadBlockId(), operations, extensions);
    }

    public TransactionId signAndBroadcastWithExtension(List<Operation> operations, List<FutureExtensions> extensions) throws BeowulfCommunicationException, BeowulfResponseException, BeowulfInvalidTransactionException, JsonProcessingException {
        SignedTransaction signedTransaction = this.signTransaction(operations, extensions);
        return this.broadcastTransaction(signedTransaction);
    }
}

