/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.base.models;

import com.beowulfchain.beowulfj.enums.ValidationType;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.interfaces.ByteTransformable;
import com.beowulfchain.beowulfj.interfaces.Validatable;
import com.beowulfchain.beowulfj.protocol.AccountName;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class BeneficiaryRouteType
implements ByteTransformable,
Validatable {
    @JsonProperty(value="account")
    private AccountName account;
    @JsonProperty(value="weight")
    private short weight;

    @JsonCreator
    public BeneficiaryRouteType(@JsonProperty(value="account") AccountName account, @JsonProperty(value="weight") short weight) {
        this.setAccount(account);
        this.setWeight(weight);
    }

    public AccountName getAccount() {
        return this.account;
    }

    public void setAccount(AccountName account) {
        if (account == null) {
            throw new InvalidParameterException("The account cannot be null.");
        }
        this.account = account;
    }

    public short getWeight() {
        return this.weight;
    }

    public void setWeight(short weight) {
        if (weight < 0) {
            throw new InvalidParameterException("The weight cannot be negative.");
        }
        this.weight = weight;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedBeneficiaryRouteType = new ByteArrayOutputStream();){
            serializedBeneficiaryRouteType.write(this.getAccount().toByteArray());
            serializedBeneficiaryRouteType.write(BeowulfJUtils.transformShortToByteArray(this.getWeight()));
            byte[] byArray = serializedBeneficiaryRouteType.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the operation into a byte array.", e);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public void validate(ValidationType validationType) {
        if (!validationType.equals((Object)ValidationType.SKIP_VALIDATION) && this.getWeight() > 10000) {
            throw new InvalidParameterException("Cannot allocate more than 100% of rewards to one account.");
        }
    }
}

