/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.base.models;

import com.beowulfchain.beowulfj.base.models.BeneficiaryRouteType;
import com.beowulfchain.beowulfj.base.models.CommentOptionsExtension;
import com.beowulfchain.beowulfj.enums.CommentOptionsExtensionsType;
import com.beowulfchain.beowulfj.enums.ValidationType;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.util.BeowulfJUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonDeserialize
public class CommentPayoutBeneficiaries
extends CommentOptionsExtension {
    @JsonProperty(value="beneficiaries")
    private List<BeneficiaryRouteType> beneficiaries;

    public List<BeneficiaryRouteType> getBeneficiaries() {
        return this.beneficiaries;
    }

    public void setBeneficiaries(List<BeneficiaryRouteType> beneficiaries) {
        this.beneficiaries = beneficiaries;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedCommentPayoutBeneficiaries = new ByteArrayOutputStream();){
            serializedCommentPayoutBeneficiaries.write(BeowulfJUtils.transformIntToVarIntByteArray(CommentOptionsExtensionsType.COMMENT_PAYOUT_BENEFICIARIES.ordinal()));
            serializedCommentPayoutBeneficiaries.write(BeowulfJUtils.transformLongToVarIntByteArray(this.getBeneficiaries().size()));
            for (BeneficiaryRouteType beneficiaryRouteType : this.getBeneficiaries()) {
                serializedCommentPayoutBeneficiaries.write(beneficiaryRouteType.toByteArray());
            }
            Object object = serializedCommentPayoutBeneficiaries.toByteArray();
            return object;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the operation into a byte array.", e);
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public void validate(ValidationType validationType) {
        if (!validationType.equals((Object)ValidationType.SKIP_VALIDATION)) {
            if (this.getBeneficiaries().isEmpty()) {
                throw new InvalidParameterException("Must specify at least one beneficiary.");
            }
            if (this.getBeneficiaries().size() >= 128) {
                throw new InvalidParameterException("Cannot specify more than 127 beneficiaries.");
            }
            int sum = 0;
            for (BeneficiaryRouteType beneficiaryRouteType : this.getBeneficiaries()) {
                if ((sum += beneficiaryRouteType.getWeight()) <= 10000) continue;
                throw new InvalidParameterException("Cannot allocate more than 100% of rewards to a comment");
            }
        }
    }
}

