/*
 * Decompiled with CFR 0.152.
 */
package com.beowulfchain.beowulfj.base.models;

import com.beowulfchain.beowulfj.base.models.BlockHeaderExtensions;
import com.beowulfchain.beowulfj.exceptions.BeowulfInvalidTransactionException;
import com.beowulfchain.beowulfj.fc.TimePointSec;
import com.beowulfchain.beowulfj.protocol.HardforkVersion;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonDeserialize
@JsonSerialize
public class HardforkVersionVote
extends BlockHeaderExtensions {
    @JsonProperty(value="hf_version")
    protected HardforkVersion hfVersion;
    @JsonProperty(value="hf_time")
    protected TimePointSec hfTime;

    @JsonCreator
    public HardforkVersionVote(@JsonProperty(value="hf_version") HardforkVersion hfVersion, @JsonProperty(value="hf_time") TimePointSec hfTime) {
        this.setHfTime(hfTime);
        this.setHfVersion(hfVersion);
    }

    public HardforkVersion getHfVersion() {
        return this.hfVersion;
    }

    public void setHfVersion(HardforkVersion hfVersion) {
        this.hfVersion = hfVersion;
    }

    public TimePointSec getHfTime() {
        return this.hfTime;
    }

    public void setHfTime(TimePointSec hfTime) {
        this.hfTime = hfTime;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] toByteArray() throws BeowulfInvalidTransactionException {
        try (ByteArrayOutputStream serializedHardforkVersionVoteExtension = new ByteArrayOutputStream();){
            serializedHardforkVersionVoteExtension.write(this.getHfVersion().toByteArray());
            serializedHardforkVersionVoteExtension.write(this.getHfTime().toByteArray());
            byte[] byArray = serializedHardforkVersionVoteExtension.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new BeowulfInvalidTransactionException("A problem occured while transforming the operation into a byte array.", e);
        }
    }
}

